/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeomBuilder {
    private List<Geom> paths = new ArrayList<Geom>();
    private boolean oddEven = false;
    private DoublePrimitiveArrayList xp = new DoublePrimitiveArrayList();
    private DoublePrimitiveArrayList yp = new DoublePrimitiveArrayList();
    private IntPrimitiveArrayList controls = new IntPrimitiveArrayList();
    private boolean usesCurve = false;
    private boolean closed = false;

    public final void setOddEven(boolean bl) {
        this.oddEven = bl;
    }

    public Geom getGeom() {
        this.makeGeom();
        Geom geom = null;
        if (this.paths.size() == 1) {
            geom = this.paths.get(0);
        } else if (this.paths.size() > 1) {
            Geom[] geomArray = this.paths.toArray(new Geom[this.paths.size()]);
            geom = new CompositeGeom(geomArray, this.oddEven, null);
        }
        this.paths.clear();
        return geom;
    }

    public final void moveTo(double d, double d2) {
        this.makeGeom();
        this.xp.add(d);
        this.yp.add(d2);
        this.controls.add(0);
    }

    public void lineTo(double d, double d2) {
        if (this.xp.size() == 0) {
            throw new EngineException("CurveBuilder#lineTo called without previous point", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.xp.add(d);
        this.yp.add(d2);
        this.controls.add(0);
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        if (this.xp.size() == 0) {
            throw new EngineException("CurveBuilder#quadTo called without previous point", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.xp.add(d);
        this.yp.add(d2);
        this.controls.add(1);
        this.xp.add(d3);
        this.yp.add(d4);
        this.controls.add(0);
        this.usesCurve = true;
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.xp.size() == 0) {
            throw new EngineException("CurveBuilder#curveTo called without previous point", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.xp.add(d);
        this.yp.add(d2);
        this.controls.add(1);
        this.xp.add(d3);
        this.yp.add(d4);
        this.controls.add(1);
        this.xp.add(d5);
        this.yp.add(d6);
        this.controls.add(0);
        this.usesCurve = true;
    }

    public void closePath() {
        this.closed = true;
        this.makeGeom();
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5) {
        if (this.xp.size() == 0) {
            throw new EngineException("CurveBuilder#arcTo called without previous point", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        Point point = new Point(d + d3 * Math.cos(d4), d2 + d3 * Math.sin(d4));
        Point point2 = new Point(d + d3 * Math.cos(d5), d2 + d3 * Math.sin(d5));
        double d6 = Math.abs(d5 - d4);
        if (d3 < 0.001 || d6 < 0.01 && point.distance(point2) < 0.001) {
            this.lineTo(point2.getX(), point2.getY());
            return;
        }
        int n = (int)Math.ceil((d6 - 0.01) / 1.5707963267948966);
        if (n < 1) {
            n = 1;
        }
        if (n > 4) {
            n = 4;
        }
        double d7 = (d4 - d5) / (2.0 * (double)n);
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double[][] dArrayArray = new double[][]{{(4.0 - d8) / 3.0, (1.0 - d8) * (3.0 - d8) / (3.0 * d9)}, {(4.0 - d8) / 3.0, -(1.0 - d8) * (3.0 - d8) / (3.0 * d9)}, {d8, -d9}};
        double d10 = d4;
        for (int i = 0; i < n; ++i) {
            double d11 = Math.cos(d7 - d10);
            double d12 = Math.sin(d7 - d10);
            double d13 = d + d3 * (d11 * dArrayArray[0][0] + d12 * dArrayArray[0][1]);
            double d14 = d2 + d3 * (-d12 * dArrayArray[0][0] + d11 * dArrayArray[0][1]);
            double d15 = d + d3 * (d11 * dArrayArray[1][0] + d12 * dArrayArray[1][1]);
            double d16 = d2 + d3 * (-d12 * dArrayArray[1][0] + d11 * dArrayArray[1][1]);
            double d17 = d + d3 * (d11 * dArrayArray[2][0] + d12 * dArrayArray[2][1]);
            double d18 = d2 + d3 * (-d12 * dArrayArray[2][0] + d11 * dArrayArray[2][1]);
            if (i == n - 1) {
                d17 = point2.getX();
                d18 = point2.getY();
            }
            this.curveTo(d13, d14, d15, d16, d17, d18);
            d10 -= 2.0 * d7;
        }
    }

    public void makeArcPath(double d, double d2, double d3, double d4, double d5) {
        this.makeGeom();
        this.moveTo(d + d3 * Math.cos(d4), d2 + d3 * Math.sin(d4));
        this.arcTo(d, d2, d3, d4, d5);
        this.makeGeom();
    }

    public void makeToroidPath(double d, double d2, double d3, double d4, double d5, double d6) {
        boolean bl;
        this.makeGeom();
        boolean bl2 = bl = Math.abs(d6 - d5) > 6.282185307179586;
        if (bl) {
            d6 = d6 > d5 ? d5 + Math.PI * 2 : d5 - Math.PI * 2;
        }
        if (d3 < 0.001) {
            if (bl) {
                this.moveTo(d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
            } else {
                this.moveTo(d, d2);
                this.lineTo(d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
            }
            this.arcTo(d, d2, d4, d6, d5);
            this.closePath();
            return;
        }
        if (bl) {
            this.moveTo(d + d3 * Math.cos(d5), d2 + d3 * Math.sin(d5));
            this.arcTo(d, d2, d3, d5, d6);
            this.closePath();
            this.moveTo(d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
            this.arcTo(d, d2, d4, d6, d5);
            this.closePath();
            return;
        }
        this.moveTo(d + d3 * Math.cos(d5), d2 + d3 * Math.sin(d5));
        this.arcTo(d, d2, d3, d5, d6);
        this.lineTo(d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
        this.arcTo(d, d2, d4, d6, d5);
        this.closePath();
    }

    public void makeInsetToroidPath(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl;
        this.makeGeom();
        if (d7 <= 0.0) {
            this.makeToroidPath(d, d2, d3, d4, d5, d6);
            return;
        }
        d3 += d7;
        d4 -= d7;
        boolean bl2 = bl = Math.abs(d6 - d5) > 6.282185307179586;
        if (bl) {
            this.makeToroidPath(d, d2, d3, d4, d5, d6);
            return;
        }
        double d8 = Math.abs(d6 - d5) / 2.0;
        double d9 = Math.min(Math.asin(d7 / d3), d8);
        double d10 = Math.min(Math.asin(d7 / d4), d8);
        if (d6 < d5) {
            d9 = -d9;
            d10 = -d10;
        }
        this.moveTo(d + d3 * Math.cos(d5 + d9), d2 + d3 * Math.sin(d5 + d9));
        this.arcTo(d, d2, d3, d5 + d9, d6 - d9);
        this.lineTo(d + d4 * Math.cos(d6 - d10), d2 + d4 * Math.sin(d6 - d10));
        this.arcTo(d, d2, d4, d6 - d10, d5 + d10);
        this.closePath();
    }

    private void makeGeom() {
        int n = this.xp.size();
        if (n > 0) {
            Geom geom;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.xp.get(i);
                dArray2[i] = this.yp.get(i);
            }
            if (this.usesCurve) {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = this.controls.get(i) == 1;
                }
                geom = new Curve(dArray, dArray2, blArray, this.closed);
            } else {
                geom = new Poly(dArray, dArray2, this.closed);
            }
            this.paths.add(geom);
        }
        this.xp.clear();
        this.yp.clear();
        this.controls.clear();
        this.usesCurve = false;
        this.closed = false;
    }
}

