/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.geom;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeomInternalUtilities {
    public static final int SCALE_NONE = 0;
    public static final int SCALE_X = 1;
    public static final int SCALE_Y = 2;
    public static final int SCALE_BOTH = 3;

    public static Geom getRendererGeom(Geom geom, double d, boolean bl) {
        Geom geom2;
        Geom geom3 = geom2 = Math.abs(d) > 0.001 ? geom.inset(d) : geom;
        if (geom2.type() == 1006 || geom2.type() == 1005) {
            geom2 = ((NonBasicGeom)geom2).asSimple();
        }
        if (bl) {
            Rect rect = geom2.getBounds();
            double d2 = Math.round(rect.getMinX());
            double d3 = Math.round(rect.getMaxX());
            double d4 = Math.round(rect.getMinY());
            double d5 = Math.round(rect.getMaxY());
            double d6 = rect.getWidth() < 0.001 ? 0.0 : (d3 - d2) / rect.getWidth();
            double d7 = d2 - d6 * rect.getMinX();
            double d8 = rect.getHeight() < 0.001 ? 0.0 : (d5 - d4) / rect.getHeight();
            double d9 = d4 - d8 * rect.getMinY();
            if (geom2 == geom) {
                geom2 = geom.copy();
            }
            geom2.transform(d6, d7, d8, d9);
        }
        return geom2;
    }

    public static Poly makeFromPoints(List<Point> list, boolean bl) {
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            Point point = list.get(i);
            dArray[i] = point.getX();
            dArray2[i] = point.getY();
        }
        return new Poly(dArray, dArray2, bl);
    }

    public static Poly coordinateTransform(Poly poly, Affine affine) {
        Affine affine2 = affine.getInverse();
        double[] dArray = poly.getX();
        double[] dArray2 = poly.getY();
        int n = dArray.length;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[2];
        for (int i = 0; i < n; ++i) {
            affine2.transformInto(dArray5, dArray[i], dArray2[i]);
            dArray3[i] = dArray5[0];
            dArray4[i] = dArray5[1];
        }
        return new Poly(dArray3, dArray4, poly.isClosed());
    }
}

