/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.geom.qt;

import com.ibm.vis.engine.internal.geom.qt.QTItem;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class QuadTree<T> {
    private final int maxListSize;
    private final double left;
    private final double right;
    private final double top;
    private final double bottom;
    private final List<QTItem<T>> covering = new ArrayList<QTItem<T>>();
    private List<QTItem<T>> intersecting = new ArrayList<QTItem<T>>();
    private QuadTree<T> NW;
    private QuadTree<T> NE;
    private QuadTree<T> SW;
    private QuadTree<T> SE;

    public QuadTree(int n, double d, double d2, double d3, double d4) {
        this.maxListSize = n;
        this.left = d2;
        this.top = d;
        this.bottom = d3;
        this.right = d4;
    }

    public void add(QTItem<T> qTItem) {
        int n = qTItem.testIntersection(this.top, this.left, this.bottom, this.right);
        if (n == 2) {
            this.covering.add(qTItem);
        } else if (n == 1) {
            if (this.intersecting == null) {
                this.NW.add(qTItem);
                this.NE.add(qTItem);
                this.SW.add(qTItem);
                this.SE.add(qTItem);
            } else {
                this.intersecting.add(qTItem);
                if (this.intersecting.size() > this.maxListSize && (this.right - this.left) * (this.bottom - this.top) > 1.0) {
                    this.split();
                }
            }
        }
    }

    public void remove(QTItem<T> qTItem) {
        if (qTItem.testIntersection(this.top, this.left, this.bottom, this.right) == 0) {
            return;
        }
        this.removeMatch(this.covering, qTItem);
        if (this.intersecting == null) {
            this.NW.remove(qTItem);
            this.SE.remove(qTItem);
            this.SW.remove(qTItem);
            this.NE.remove(qTItem);
        } else {
            this.removeMatch(this.intersecting, qTItem);
        }
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.bottom <= d || this.right <= d2 || this.top >= d3 || this.left >= d4) {
            return false;
        }
        if (this.covering.size() > 0) {
            return true;
        }
        if (this.intersecting == null) {
            if (this.NW.intersects(d, d2, d3, d4)) {
                return true;
            }
            if (this.NE.intersects(d, d2, d3, d4)) {
                return true;
            }
            if (this.SW.intersects(d, d2, d3, d4)) {
                return true;
            }
            if (this.SE.intersects(d, d2, d3, d4)) {
                return true;
            }
        } else {
            for (QTItem<T> qTItem : this.intersecting) {
                if (qTItem.testIntersection(d, d2, d3, d4) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void addIntersecting(Set<QTItem<T>> set, double d, double d2, double d3, double d4, int n) {
        if (this.bottom <= d || this.right <= d2 || this.top >= d3 || this.left >= d4) {
            return;
        }
        set.addAll(this.covering);
        if (set.size() >= n) {
            return;
        }
        if (this.intersecting == null) {
            this.NW.addIntersecting(set, d, d2, d3, d4, n);
            this.NE.addIntersecting(set, d, d2, d3, d4, n);
            this.SW.addIntersecting(set, d, d2, d3, d4, n);
            this.SE.addIntersecting(set, d, d2, d3, d4, n);
        } else {
            for (QTItem<T> qTItem : this.intersecting) {
                if (qTItem.testIntersection(d, d2, d3, d4) == 0) continue;
                set.add(qTItem);
            }
        }
    }

    private QTItem<T> removeMatch(List<QTItem<T>> list, QTItem<T> qTItem) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).item != qTItem.item) continue;
            return list.remove(i);
        }
        return null;
    }

    private void split() {
        double d = (this.left + this.right) / 2.0;
        double d2 = (this.top + this.bottom) / 2.0;
        this.NW = new QuadTree<T>(this.maxListSize, this.top, this.left, d2, d);
        this.NE = new QuadTree<T>(this.maxListSize, this.top, d, d2, this.right);
        this.SW = new QuadTree<T>(this.maxListSize, d2, this.left, this.bottom, d);
        this.SE = new QuadTree<T>(this.maxListSize, d2, d, this.bottom, this.right);
        for (QTItem<T> qTItem : this.intersecting) {
            this.NW.add(qTItem);
            this.NE.add(qTItem);
            this.SW.add(qTItem);
            this.SE.add(qTItem);
        }
        this.intersecting = null;
    }

    public String structureDebug() {
        if (this.intersecting == null) {
            return "[" + this.listdebug(this.covering, true) + this.NW.structureDebug() + this.NE.structureDebug() + this.SW.structureDebug() + this.SE.structureDebug() + "]";
        }
        return "(" + this.listdebug(this.covering, true) + this.listdebug(this.intersecting, false) + ")";
    }

    private String listdebug(List<QTItem<T>> list, boolean bl) {
        String string = "";
        for (QTItem<T> qTItem : list) {
            string = string + qTItem.item.toString();
        }
        if (bl && string.length() > 0) {
            string = "{" + string + "}";
        }
        return string;
    }
}

