/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.globalization;

import com.ibm.vis.engine.internal.globalization.CodePointRange;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NumericShaper {
    static final int EUROPEAN = 0;
    static final int ARABIC = 1;
    static final int EASTERN_ARABIC = 2;
    static final int DEVANAGARI = 3;
    static final int BENGALI = 4;
    static final int GURMUKHI = 5;
    static final int GUJARATI = 6;
    static final int ORIYA = 7;
    static final int TAMIL = 8;
    static final int TELUGU = 9;
    static final int KANNADA = 10;
    static final int MALAYALAM = 11;
    static final int THAI = 12;
    static final int LAO = 13;
    static final int TIBETAN = 14;
    static final int MYANMAR = 15;
    static final int ETHIOPIC = 16;
    static final int KHMER = 17;
    static final int MONGOLIAN = 18;
    static final int EXTENDED_ARABIC = 19;
    private static CodePointRange[] ranges = new CodePointRange[]{new CodePointRange(0, 768), new CodePointRange(1536, 1792), new CodePointRange(1536, 1792), new CodePointRange(2304, 2432), new CodePointRange(2432, 2560), new CodePointRange(2560, 2688), new CodePointRange(2688, 2816), new CodePointRange(2816, 2944), new CodePointRange(2944, 3072), new CodePointRange(3072, 3200), new CodePointRange(3200, 3328), new CodePointRange(3328, 3456), new CodePointRange(3584, 3712), new CodePointRange(3712, 3840), new CodePointRange(3840, 4096), new CodePointRange(4096, 4256), new CodePointRange(4608, 5024), new CodePointRange(6016, 6144), new CodePointRange(6144, 6320), new CodePointRange(1872, 1920)};
    private static final CodePointRange[] contextualCharRanges = new CodePointRange[]{new CodePointRange(65, 91), new CodePointRange(97, 123), new CodePointRange(170, 171), new CodePointRange(181, 182), new CodePointRange(186, 187), new CodePointRange(192, 215), new CodePointRange(216, 247), new CodePointRange(248, 697), new CodePointRange(699, 706), new CodePointRange(720, 722), new CodePointRange(736, 741), new CodePointRange(750, 751), new CodePointRange(1544, 1545), new CodePointRange(1547, 1548), new CodePointRange(1549, 1550), new CodePointRange(1563, 1611), new CodePointRange(1645, 1648), new CodePointRange(1649, 1750), new CodePointRange(1765, 1767), new CodePointRange(1774, 1776), new CodePointRange(1786, 1793), new CodePointRange(1872, 1921), new CodePointRange(2307, 2362), new CodePointRange(2363, 2364), new CodePointRange(2365, 2369), new CodePointRange(2377, 2381), new CodePointRange(2382, 2385), new CodePointRange(2392, 2402), new CodePointRange(2404, 2433), new CodePointRange(2434, 2492), new CodePointRange(2493, 2497), new CodePointRange(2503, 2509), new CodePointRange(2510, 2530), new CodePointRange(2534, 2546), new CodePointRange(2548, 2555), new CodePointRange(2563, 2620), new CodePointRange(2622, 2625), new CodePointRange(2649, 2672), new CodePointRange(2674, 2677), new CodePointRange(2691, 2748), new CodePointRange(2749, 2753), new CodePointRange(2761, 2765), new CodePointRange(2768, 2786), new CodePointRange(2790, 2801), new CodePointRange(2818, 2876), new CodePointRange(2877, 2879), new CodePointRange(2880, 2881), new CodePointRange(2887, 2893), new CodePointRange(2903, 2914), new CodePointRange(2918, 2946), new CodePointRange(2947, 3008), new CodePointRange(3009, 3021), new CodePointRange(3024, 3059), new CodePointRange(3073, 3134), new CodePointRange(3137, 3142), new CodePointRange(3160, 3170), new CodePointRange(3174, 3192), new CodePointRange(3199, 3260), new CodePointRange(3261, 3276), new CodePointRange(3285, 3298), new CodePointRange(3302, 3393), new CodePointRange(3398, 3405), new CodePointRange(3406, 3426), new CodePointRange(3430, 3457), new CodePointRange(3584, 3633), new CodePointRange(3634, 3636), new CodePointRange(3648, 3655), new CodePointRange(3663, 3761), new CodePointRange(3762, 3764), new CodePointRange(3773, 3784), new CodePointRange(3792, 3864), new CodePointRange(3866, 3893), new CodePointRange(3894, 3895), new CodePointRange(3896, 3897), new CodePointRange(3902, 3953), new CodePointRange(3967, 3968), new CodePointRange(3973, 3974), new CodePointRange(3976, 3981), new CodePointRange(4030, 4038), new CodePointRange(4039, 4141), new CodePointRange(4145, 4146), new CodePointRange(4152, 4153), new CodePointRange(4155, 4157), new CodePointRange(4159, 4184), new CodePointRange(4186, 4190), new CodePointRange(4193, 4209), new CodePointRange(4213, 4225), new CodePointRange(4608, 4957), new CodePointRange(4960, 4993), new CodePointRange(6016, 6071), new CodePointRange(6078, 6086), new CodePointRange(6087, 6089), new CodePointRange(6100, 6107), new CodePointRange(6108, 6109), new CodePointRange(6112, 6128), new CodePointRange(6160, 6313), new CodePointRange(6314, 6401)};
    private static int[] offsets = new int[]{0, 1584, 1728, 2358, 2486, 2614, 2742, 2870, 2998, 3126, 3254, 3382, 3616, 3744, 3824, 4112, 4921, 6064, 6112};

    public static String shape(String string, NumericShapingInfo numericShapingInfo) {
        if (numericShapingInfo == null || numericShapingInfo.isNone()) {
            return string;
        }
        if (numericShapingInfo.isNational()) {
            return NumericShaper.shapeNationally(string, numericShapingInfo.getNationalDigitCode());
        }
        if (numericShapingInfo.isContextual()) {
            return NumericShaper.shapeContextually(string, numericShapingInfo.getContextualDigitCodes(), numericShapingInfo.getStartingContextCode());
        }
        return string;
    }

    private static String shapeNationally(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n > offsets.length - 1) {
            return string;
        }
        int n2 = offsets[n];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 48;
        int n4 = 57;
        for (int i = 0; i < string.length(); ++i) {
            int n5 = BasicFactory.charCodeAt(string, i);
            if (n5 >= n3 && n5 <= n4) {
                stringBuilder.append(BasicFactory.fromCharCode(n5 + n2));
                continue;
            }
            stringBuilder.append(BasicFactory.fromCharCode(n5));
        }
        return stringBuilder.toString();
    }

    private static int search(CodePointRange[] codePointRangeArray, int n) {
        int n2 = 0;
        int n3 = codePointRangeArray.length - 1;
        while (n2 <= n3) {
            int n4 = (int)Math.floor((n2 + n3) / 2);
            if (codePointRangeArray[n4].start <= n && codePointRangeArray[n4].end > n) {
                return n4;
            }
            if (codePointRangeArray[n4].start > n) {
                n3 = n4 - 1;
                continue;
            }
            if (codePointRangeArray[n4].end > n) continue;
            n2 = n4 + 1;
        }
        return -1;
    }

    static boolean hasContext(int n) {
        int n2 = NumericShaper.search(contextualCharRanges, n);
        return n2 != -1;
    }

    static int getRange(int n) {
        int n2 = NumericShaper.search(ranges, n);
        if (n2 == -1) {
            return 0;
        }
        if (n2 == 19) {
            return 1;
        }
        return n2;
    }

    private static String shapeContextually(String string, int[] nArray, int n) {
        if (string == null) {
            return null;
        }
        int n2 = n > offsets.length - 1 || nArray.length == 0 ? 0 : n;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 |= 1 << nArray[i];
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        int n5 = 0;
        if ((1 << n2 & n3) != 0) {
            n4 = offsets[n2];
            n5 = n2;
        }
        for (int i = 0; i < string.length(); ++i) {
            int n6 = BasicFactory.charCodeAt(string, i);
            int n7 = 48;
            int n8 = 57;
            if (n6 >= n7 && n6 <= n8) {
                stringBuilder.append(BasicFactory.fromCharCode(n6 + n4));
                continue;
            }
            stringBuilder.append(BasicFactory.fromCharCode(n6));
            int n9 = NumericShaper.getRange(n6);
            if (n9 == n5 || !NumericShaper.hasContext(n6)) continue;
            if ((1 << n9 & n3) != 0) {
                n5 = n9;
                if (n5 == 1 && (n3 & 4) != 0) {
                    n5 = 2;
                }
                n4 = offsets[n5];
                continue;
            }
            if ((1 << n9 & n3) != 0) continue;
            if (n9 == 2) {
                if ((2 & n3) == 0) continue;
                n5 = 1;
                n4 = offsets[n5];
                continue;
            }
            if (n9 == 1) {
                if ((4 & n3) == 0) continue;
                n5 = 2;
                n4 = offsets[n5];
                continue;
            }
            n5 = 0;
            n4 = 0;
        }
        return stringBuilder.toString();
    }
}

