/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.globalization;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.spec.internal.LocalizationSpec;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NumericShapingInfo {
    private static String ARABIC = "ARABIC";
    private static String BENGALI = "BENGALI";
    private static String DEVANAGARI = "DEVANAGARI";
    private static String EASTERN_ARABIC = "EASTERN_ARABIC";
    private static String ETHIOPIC = "ETHIOPIC";
    private static String EUROPEAN = "EUROPEAN";
    private static String GUJARATI = "GUJARATI";
    private static String GURMUKHI = "GURMUKHI";
    private static String KANNADA = "KANNADA";
    private static String KHMER = "KHMER";
    private static String LAO = "LAO";
    private static String MALAYALAM = "MALAYALAM";
    private static String MONGOLIAN = "MONGOLIAN";
    private static String MYANMAR = "MYANMAR";
    private static String ORIYA = "ORIYA";
    private static String TAMIL = "TAMIL";
    private static String TELUGU = "TELUGU";
    private static String THAI = "THAI";
    private static String TIBETAN = "TIBETAN";
    private static Map<String, Integer> digitMap = new HashMap<String, Integer>();
    private static final int NONE = 1;
    private static final int NATIONAL = 2;
    private static final int CONTEXTUAL = 4;
    private int type = 1;
    private int nationalDigitCode = 0;
    private int[] contextualDigitCodes = null;
    private int startingContextCode = 0;

    static int getDigitCode(String string) {
        Integer n = digitMap.get(string);
        if (n == null) {
            return digitMap.get(EUROPEAN);
        }
        return n;
    }

    static int[] getDigitCodes(String[] stringArray) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        String[] objectArray = stringArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i];
            int n2 = NumericShapingInfo.getDigitCode(string);
            intPrimitiveArrayList.add(n2);
        }
        int[] nArray = new int[intPrimitiveArrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = intPrimitiveArrayList.get(n);
        }
        return nArray;
    }

    private NumericShapingInfo(int n, int n2, int[] nArray, int n3) {
        this.type = n;
        this.nationalDigitCode = n2;
        this.contextualDigitCodes = nArray;
        this.startingContextCode = n3;
    }

    public static NumericShapingInfo getShapingInfo(LocalizationSpec localizationSpec) {
        if (localizationSpec != null) {
            if (localizationSpec.nationalShaping != null) {
                int n = NumericShapingInfo.getDigitCode(localizationSpec.nationalShaping.digits);
                return new NumericShapingInfo(2, n, null, 0);
            }
            if (localizationSpec.contextualShaping != null) {
                int[] nArray = NumericShapingInfo.getDigitCodes(localizationSpec.contextualShaping.digits);
                int n = NumericShapingInfo.getDigitCode(localizationSpec.contextualShaping.defaultContext);
                return new NumericShapingInfo(4, 0, nArray, n);
            }
        }
        return new NumericShapingInfo(1, 0, null, 0);
    }

    public boolean isNational() {
        return (this.type & 2) != 0;
    }

    public boolean isContextual() {
        return (this.type & 4) != 0;
    }

    public boolean isNone() {
        return (this.type & 1) != 0;
    }

    public int getNationalDigitCode() {
        return this.nationalDigitCode;
    }

    public int[] getContextualDigitCodes() {
        return this.contextualDigitCodes;
    }

    public int getStartingContextCode() {
        return this.startingContextCode;
    }

    static {
        digitMap.put(ARABIC, 1);
        digitMap.put(BENGALI, 4);
        digitMap.put(DEVANAGARI, 3);
        digitMap.put(EASTERN_ARABIC, 2);
        digitMap.put(ETHIOPIC, 16);
        digitMap.put(EUROPEAN, 0);
        digitMap.put(GUJARATI, 6);
        digitMap.put(GURMUKHI, 5);
        digitMap.put(KANNADA, 10);
        digitMap.put(KHMER, 17);
        digitMap.put(LAO, 13);
        digitMap.put(MALAYALAM, 11);
        digitMap.put(MONGOLIAN, 18);
        digitMap.put(MYANMAR, 15);
        digitMap.put(ORIYA, 7);
        digitMap.put(TAMIL, 8);
        digitMap.put(TELUGU, 9);
        digitMap.put(THAI, 12);
        digitMap.put(TIBETAN, 14);
    }
}

