/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar;

import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;

public class LabelLineProducer {
    private final StyleSpec lineStyle;
    private final double minLength;

    public LabelLineProducer(StyleSpec styleSpec, double d) {
        assert (d >= 0.0);
        this.lineStyle = styleSpec == null ? new StyleSpec() : styleSpec;
        this.minLength = d;
    }

    public ShapeLine makeLabelLine(Rect rect, Shape shape) {
        Geom geom = shape.getGeom();
        double d = rect.distanceToGeom(geom);
        if (d == 0.0 || d < this.minLength) {
            return null;
        }
        Point point = this.getAttachLocation(geom.getCenter(), rect);
        Point point2 = null;
        point2 = geom.type() == 1002 ? this.getAttachLocation(point, (Rect)geom) : geom.boundaryPoint(point.getX(), point.getY());
        ShapeLine shapeLine = ShapeLine.make(point.getX(), point.getY(), point2.getX(), point2.getY());
        shapeLine.addMeta(shape);
        StyleBuilder.setUnfilled(shapeLine, this.lineStyle, null);
        if (shape.getRows() != null) {
            shapeLine.setRow(shape.getRows()[0]);
        }
        return shapeLine;
    }

    private Point getAttachLocation(Point point, Rect rect) {
        Point point2 = rect.getCenter();
        if (point.getX() < rect.getMinX() - 2.0) {
            point2.setX(rect.getMinX());
        } else if (point.getX() > rect.getMaxX() + 2.0) {
            point2.setX(rect.getMaxX());
        }
        if (point.getY() < rect.getMinY() - 2.0) {
            point2.setY(rect.getMinY());
        } else if (point.getY() > rect.getMaxY() + 2.0) {
            point2.setY(rect.getMaxY());
        }
        return point2;
    }
}

