/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar;

import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.struct.Shape;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ShapeIterator<T extends Shape>
implements Iterator<T> {
    private final ShapeList shapeList;
    private final ListIterator<T> it;
    private T currentItem;

    public ShapeIterator(ShapeList shapeList, List<T> list, int n) {
        this.shapeList = shapeList;
        this.it = list.listIterator(n);
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public T next() {
        this.currentItem = (Shape)this.it.next();
        return this.currentItem;
    }

    @Override
    public void remove() {
        if (this.currentItem == null) {
            throw new IllegalStateException();
        }
        this.it.remove();
        this.shapeList.removeLinkages((Shape)this.currentItem);
        this.currentItem = null;
    }

    public void replace(T t) {
        if (this.currentItem == null) {
            throw new IllegalStateException();
        }
        if (t == null) {
            this.remove();
        } else {
            this.it.set(t);
            this.shapeList.replace((Shape)this.currentItem, (Shape)t);
        }
    }

    public boolean seekTo(T t) {
        while (this.hasNext()) {
            if (this.next() != t) continue;
            return true;
        }
        return false;
    }
}

