/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.grammar.GroupComparator;
import com.ibm.vis.engine.internal.grammar.LabelLineProducer;
import com.ibm.vis.engine.internal.grammar.ShapeIterator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.Branch;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.ElementInfo;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ShapeList {
    private String idPrefix = "";
    private int nextShapeIndex = 0;
    private final List<Shape> elementShapes = new ArrayList<Shape>();
    private final List<Text> elementLabels = new ArrayList<Text>();
    private final List<Shape> plaques = new ArrayList<Shape>();
    private final List<Shape> nonElements = new ArrayList<Shape>();
    private final List<Shape> allShapes = new ArrayList<Shape>();
    private final Map<Shape, Shape> plaqueForLabel = new HashMap<Shape, Shape>();
    private final Map<Shape, Shape> shapeForLabel = new HashMap<Shape, Shape>();
    private final Map<Shape, Shape> labelForPlaque = new HashMap<Shape, Shape>();
    private final Map<Shape, LabelLineProducer> lineProducers = new HashMap<Shape, LabelLineProducer>();
    private final Map<Shape, List<Text>> labelsForElement = new HashMap<Shape, List<Text>>();
    private Map<Shape, Shape> replacements;

    public final List<Text> getElementLabels() {
        return this.elementLabels;
    }

    public void addElementShape(Shape shape) {
        this.elementShapes.add(shape);
        this.allShapes.add(shape);
        shape.setID(this.idPrefix + "S" + this.nextShapeIndex++);
    }

    public void addPlaqueAndLabelForShape(Shape shape, Text text, Shape shape2, boolean bl, LabelLineProducer labelLineProducer) {
        this.elementLabels.add(text);
        if (bl) {
            int n = this.allShapes.indexOf(shape);
            boolean bl2 = false;
            while (!bl2 && n + 1 < this.allShapes.size()) {
                Shape shape3 = this.allShapes.get(n + 1);
                if (this.getShapeForLabel(this.getLabelForPlaque(shape3)) == shape) {
                    n += 2;
                    continue;
                }
                if (this.getShapeForLabel(shape3) == shape) {
                    ++n;
                    continue;
                }
                bl2 = true;
            }
            assert (n >= 0);
            if (shape2 != null) {
                this.allShapes.add(n + 1, shape2);
                this.allShapes.add(n + 2, text);
                this.plaqueForLabel.put(text, shape2);
                this.plaques.add(shape2);
                this.labelForPlaque.put(shape2, text);
            } else {
                this.allShapes.add(n + 1, text);
            }
        } else {
            if (shape2 != null) {
                this.allShapes.add(shape2);
                this.plaques.add(shape2);
                this.plaqueForLabel.put(text, shape2);
                this.labelForPlaque.put(shape2, text);
            }
            this.allShapes.add(text);
        }
        this.shapeForLabel.put(text, shape);
        this.lineProducers.put(text, labelLineProducer);
        List<Text> list = this.labelsForElement.get(shape);
        if (list == null) {
            list = new ArrayList<Text>();
            this.labelsForElement.put(shape, list);
        }
        if (shape2 != null) {
            shape2.setID(shape.getID().replace("S", "LB") + "P" + list.size());
        }
        text.setID(shape.getID().replace("S", "L") + "P" + list.size());
        list.add(text);
    }

    public void addNonElementShape(Shape shape) {
        this.nonElements.add(shape);
        this.allShapes.add(shape);
        shape.setID(this.idPrefix + "S" + this.nextShapeIndex++);
    }

    public List<Shape> getAllShapes() {
        this.doReplacements();
        return Collections.unmodifiableList(this.allShapes);
    }

    public Branch createClusterAndStackGroups() {
        if (this.elementShapes.isEmpty()) {
            return null;
        }
        Branch branch = new Branch();
        branch.list = this.allShapes;
        String string = this.elementShapes.get(0).getElementInfo().getKey();
        int n = string == null ? 0 : string.split(BasicFactory.getRegExBarString()).length;
        this.splitBranch(branch, 0, n);
        return branch;
    }

    private void splitBranch(Branch branch, int n, int n2) {
        this.splitByKey(branch, n);
        if (n2 > n + 2) {
            for (String string : branch.map.keySet()) {
                this.splitBranch(branch.map.get(string), n + 1, n2);
            }
        }
    }

    private void splitByKey(Branch branch, int n) {
        branch.map = new LinkedHashMap<String, Branch>();
        for (Shape shape : branch.list) {
            ElementInfo elementInfo = shape.getElementInfo();
            String string = elementInfo.getKey();
            string = string == null ? "0" : this.shiftKey(string, n);
            Branch branch2 = branch.map.get(string);
            if (branch2 == null) {
                branch2 = new Branch();
                branch2.list = new ArrayList<Shape>();
                branch.map.put(string, branch2);
                branch2.key = branch.key == null ? string : branch.key + "|" + string;
            }
            branch2.list.add(shape);
        }
        branch.list = null;
    }

    private String shiftKey(String string, int n) {
        String[] stringArray = string.split(BasicFactory.getRegExBarString());
        return stringArray[n];
    }

    public List<Shape> getElementShapes() {
        return this.elementShapes;
    }

    private void allocateReplacements() {
        if (this.replacements == null) {
            int n = Math.max(this.elementShapes.size() + this.nonElements.size(), 16);
            this.replacements = new HashMap<Shape, Shape>(n * 4 / 3);
        }
    }

    private void doReplacements() {
        if (this.replacements == null) {
            return;
        }
        ListIterator<Shape> listIterator = this.allShapes.listIterator();
        while (listIterator.hasNext()) {
            Shape shape = listIterator.next();
            if (!this.replacements.containsKey(shape)) continue;
            Shape shape2 = this.replacements.get(shape);
            if (shape2 == null) {
                listIterator.remove();
                continue;
            }
            listIterator.set(shape2);
        }
        this.replacements = null;
    }

    public ShapeIterator<Shape> elementIterator() {
        return new ShapeIterator<Shape>(this, this.elementShapes, 0);
    }

    public ShapeIterator<Shape> nonElementIterator() {
        return new ShapeIterator<Shape>(this, this.nonElements, 0);
    }

    public ShapeIterator<Text> elementLabelIterator(int n) {
        return new ShapeIterator<Text>(this, this.elementLabels, n);
    }

    public ShapeIterator<Shape> plaqueIterator() {
        return new ShapeIterator<Shape>(this, this.plaques, 0);
    }

    public Shape getPlaqueForLabel(Text text) {
        return this.plaqueForLabel.get(text);
    }

    public Text getLabelForPlaque(Shape shape) {
        return (Text)this.labelForPlaque.get(shape);
    }

    public Shape getShapeForLabel(Shape shape) {
        return this.shapeForLabel.get(shape);
    }

    void removeLinkages(Shape shape) {
        this.allocateReplacements();
        this.replacements.put(shape, null);
        this.labelForPlaque.remove(shape);
        this.plaqueForLabel.remove(shape);
        Shape shape2 = this.shapeForLabel.get(shape);
        if (shape2 != null) {
            this.shapeForLabel.remove(shape);
            this.labelsForElement.get(shape2).remove(shape);
        }
        this.labelsForElement.remove(shape);
    }

    void replace(Shape shape, Shape shape2) {
        List<Text> list;
        this.allocateReplacements();
        this.replacements.put(shape, shape2);
        shape2.setID(shape.getID());
        Shape shape3 = this.labelForPlaque.get(shape);
        if (shape3 != null) {
            this.labelForPlaque.put(shape2, shape3);
            this.plaqueForLabel.put(shape3, shape2);
            this.labelForPlaque.remove(shape);
        }
        if ((shape3 = this.plaqueForLabel.get(shape)) != null) {
            this.plaqueForLabel.put(shape2, shape3);
            this.labelForPlaque.put(shape3, shape2);
            this.plaqueForLabel.remove(shape);
        }
        if ((shape3 = this.shapeForLabel.get(shape)) != null) {
            this.shapeForLabel.put(shape2, shape3);
            this.shapeForLabel.remove(shape);
            list = this.labelsForElement.get(shape3);
            list.set(list.indexOf(shape), (Text)shape2);
        }
        if ((list = this.labelsForElement.get(shape)) != null) {
            this.labelsForElement.remove(shape);
            this.labelsForElement.put(shape2, list);
        }
    }

    public void sortByAestheticGroup() {
        this.sort(new GroupComparator());
    }

    private void sort(Comparator<Shape> comparator) {
        int n = 0;
        for (Shape shape : this.allShapes) {
            shape.setIndex(n++);
        }
        BasicFactory.sortList(this.elementShapes, comparator);
        BasicFactory.sortList(this.elementLabels, comparator);
        BasicFactory.sortList(this.plaques, comparator);
        BasicFactory.sortList(this.nonElements, comparator);
        BasicFactory.sortList(this.allShapes, comparator);
    }

    public void addLabelLine(Shape shape, Shape shape2, Text text, boolean bl) {
        if (bl) {
            int n = this.allShapes.indexOf(text);
            assert (n >= 0) : "Illegal to add a label line before the label and shape are added.";
            this.allShapes.add(n + 1, shape);
        } else {
            this.allShapes.add(shape);
        }
        shape.setID(text.getID().replace("L", "LN"));
    }

    public void applyShapeIDs(String string) {
        this.idPrefix = string;
        this.nextShapeIndex = 0;
        for (Shape shape : this.getAllShapes()) {
            shape.setID(this.idPrefix + "S" + this.nextShapeIndex++);
        }
    }

    public void addLabelLines() {
        for (Text text : this.elementLabels) {
            Shape shape;
            Shape shape2 = this.getShapeForLabel(text);
            if (shape2 == null) continue;
            Shape shape3 = this.plaqueForLabel.get(text);
            Rect rect = text.getBounds();
            if (shape3 != null && !ShapeList.labelHasTransparentPlaque(text)) {
                rect = shape3.getBounds();
            }
            if ((shape = this.makeLabelLine(text, rect)) == null) continue;
            this.addLabelLine(shape, shape2, text, true);
            shape.setVisible(shape2.isVisible() && text.isVisible());
            if (shape2.getKey() == null) continue;
            shape.setKey(shape2.getKey() + "|" + "LN");
        }
    }

    public Shape makeLabelLine(Text text, Rect rect) {
        Shape shape = this.getShapeForLabel(text);
        if (shape == null) {
            return null;
        }
        LabelLineProducer labelLineProducer = this.lineProducers.get(text);
        if (labelLineProducer == null) {
            return null;
        }
        return labelLineProducer.makeLabelLine(rect, shape);
    }

    public static boolean labelHasTransparentPlaque(Text text) {
        Object object;
        StyleSpec styleSpec = text.getBackgroundStyle();
        if (styleSpec != null && styleSpec.fill != null && !"transparent".equals(object = styleSpec.fill)) {
            ColorSpec colorSpec;
            ColorSpec colorSpec2 = colorSpec = object instanceof ColorSpec ? (ColorSpec)object : null;
            if (colorSpec != null) {
                ColorNew colorNew = ColorUtil.createColorFromColorSpec(colorSpec);
                if (colorSpec.a != null && colorSpec.a.doubleValue() == 0.0 || colorNew.getRGBA()[3] == 0.0) {
                    return true;
                }
            }
        }
        return false;
    }

    public void moveLabel(Text text, double d, double d2) {
        text.affine(1.0, d, 1.0, d2, false);
        Shape shape = this.getPlaqueForLabel(text);
        if (shape != null) {
            shape.affine(1.0, d, 1.0, d2, false);
        }
    }

    public Rect getBoundsForLabel(Text text) {
        Shape shape = this.getPlaqueForLabel(text);
        if (shape != null) {
            return shape.getBounds();
        }
        return text.getBounds();
    }
}

