/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapping;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AccessibilityAestheticValueProducer
extends AestheticValueProducer {
    private final VisContext visContext;
    private final String key;
    private final boolean isStringProperty;
    private final ValueProvider provider;
    private final String[] categories;

    public AccessibilityAestheticValueProducer(VisContext visContext, String string, ValueProvider valueProvider) {
        this.visContext = visContext;
        this.key = string;
        this.isStringProperty = AccessibleInfo.isStringProperty(string);
        assert (this.isStringProperty || AccessibleInfo.isBooleanProperty(string));
        this.provider = valueProvider;
        this.categories = valueProvider == null ? null : valueProvider.getCategories();
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        if (BasicFactory.isNumber(object) && BasicFactory.isNumber(object2)) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            return (1.0 - d) * number.doubleValue() + d * number2.doubleValue();
        }
        return d >= 1.0 ? object2 : object;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.text == null && mappingSpec.value == null && mappingSpec.state == null) {
            throw new SpecException("Accessibility aesthetic should use either 'text', 'value' or 'state' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        if (this.isStringProperty) {
            if (mappingSpec.text != null) {
                return mappingSpec.text;
            }
            return mappingSpec.value;
        }
        return mappingSpec.state;
    }

    @Override
    public Object make(Object object) {
        return object;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n2);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return n2;
    }

    @Override
    public Object getDefaultForNumeric(double d, Number number) {
        return number;
    }

    @Override
    protected Object calculateNumericMapping(Shape shape, double d, AestheticMapping aestheticMapping, int n, int n2, Object object, Object object2, String string) {
        if (n == n2) {
            return object;
        }
        double d2 = (d - aestheticMapping.getStop(n)) / (aestheticMapping.getStop(n2) - aestheticMapping.getStop(n));
        return this.interpolate(object, object2, d2);
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (!this.visContext.getGenerateAccessibility()) {
            return shape;
        }
        if (this.isStringProperty) {
            String string2 = this.getStringValue(object);
            shape.getA11yInfo().setStringProperty(this.key, string2);
        } else {
            Boolean bl = this.getBooleanValue(object);
            shape.getA11yInfo().setBooleanProperty(this.key, bl);
        }
        return shape;
    }

    private String getStringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (BasicFactory.isString(object)) {
            return (String)object;
        }
        if (BasicFactory.isBoolean(object)) {
            return object.toString();
        }
        if (BasicFactory.isNumber(object)) {
            Number number = (Number)object;
            if (this.categories != null) {
                int n = number.intValue();
                if (n < 0) {
                    n = 0;
                }
                if (n >= this.categories.length) {
                    n = this.categories.length - 1;
                }
                return this.categories[n];
            }
            if (this.provider != null && this.provider.getBaseField() != null) {
                return this.provider.getBaseField().getFormattedStringValue(number.doubleValue(), -1, null);
            }
            return number.toString();
        }
        throw new EngineException("Bad data type passed to AccessibilityAestheticValueProvider#getStringValue", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
    }

    private Boolean getBooleanValue(Object object) {
        if (object == null) {
            return null;
        }
        if (BasicFactory.isString(object)) {
            return true;
        }
        if (BasicFactory.isBoolean(object)) {
            return (Boolean)object;
        }
        if (BasicFactory.isNumber(object)) {
            Number number = (Number)object;
            return number.doubleValue() != 0.0;
        }
        throw new EngineException("Bad data type passed to AccessibilityAestheticValueProvider#getBooleanValue", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
    }
}

