/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.aesthetic.AccessibilityAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapping;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.ColorAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.DashingAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.FontAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.MetaAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.OffsetAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.SizeAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.SplitAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.StyleByAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.SymbolAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.VisibilityAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleBuilder;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.grammar.values.ValueProviderFactory;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.internal.accessibility.AccessibilityValidation;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import java.io.Serializable;
import java.util.ArrayList;

public class Aesthetic
extends IdentifiableItem {
    public static final String FONT_KEYWORD = "font";
    public static final int FONT_NUMBER = 1;
    public static final String COLOR_KEYWORD = "color";
    public static final int COLOR_NUMBER = 2;
    public static final String SIZE_KEYWORD = "size";
    public static final int SIZE_NUMBER = 4;
    public static final String DASHING_KEYWORD = "dashing";
    public static final int DASHING_NUMBER = 8;
    public static final String META_KEYWORD = "meta";
    public static final int META_NUMBER = 16;
    public static final String SYMBOL_KEYWORD = "symbol";
    public static final int SYMBOL_NUMBER = 32;
    public static final String SPLIT_KEYWORD = "split";
    public static final int SPLIT_NUMBER = 64;
    public static final String STYLE_BY_KEYWORD = "styleBy";
    public static final int STYLE_BY_NUMBER = 128;
    public static final String VISIBILITY_KEYWORD = "visibility";
    public static final int VISIBILITY_NUMBER = 256;
    public static final String OFFSET_KEYWORD = "offset";
    public static final int OFFSET_NUMBER = 512;
    public static final String ACCESSIBILITY_KEYWORD = "accessibility";
    public static final int ACCESSIBILITY_NUMBER = 1024;
    public final AestheticSpec spec;
    public final String type;
    public final int typeNumber;
    public final ValueProvider valueProvider;
    public Scale scale;
    public final Element element;
    public final LabelProducer labelProducer;
    private final Vis vis;
    private final AestheticValueProducer producer;
    private final AestheticMapping mapping;
    private final AestheticPalette palette;
    private final Object nullValue;
    private final String modifiesType;
    private final String modifiesPart;
    private final boolean modifiesDescendants;
    private boolean splits;
    private final boolean applicableToLegend;
    private final boolean useForDefaultLegends;

    public static Aesthetic[] getElementAesthetics(Element element, ElementsSpec elementsSpec) {
        ArrayList<Aesthetic> arrayList = new ArrayList<Aesthetic>();
        Aesthetic.addAesthetic(arrayList, STYLE_BY_KEYWORD, element, elementsSpec.styleBy);
        Aesthetic.addAesthetic(arrayList, SIZE_KEYWORD, element, elementsSpec.size);
        Aesthetic.addAesthetic(arrayList, SYMBOL_KEYWORD, element, elementsSpec.symbol);
        Aesthetic.addAesthetic(arrayList, OFFSET_KEYWORD, element, elementsSpec.offset);
        Aesthetic.addAesthetic(arrayList, COLOR_KEYWORD, element, elementsSpec.color);
        Aesthetic.addAesthetic(arrayList, DASHING_KEYWORD, element, elementsSpec.dashing);
        Aesthetic.addAesthetic(arrayList, FONT_KEYWORD, element, elementsSpec.font);
        Aesthetic.addAesthetic(arrayList, META_KEYWORD, element, elementsSpec.meta);
        Aesthetic.addAesthetic(arrayList, SPLIT_KEYWORD, element, elementsSpec.split);
        Aesthetic.addAesthetic(arrayList, VISIBILITY_KEYWORD, element, elementsSpec.visibility);
        Aesthetic.addAesthetic(arrayList, ACCESSIBILITY_KEYWORD, element, elementsSpec.accessibility);
        return arrayList.toArray(new Aesthetic[arrayList.size()]);
    }

    private static void addAesthetic(ArrayList<Aesthetic> arrayList, String string, Element element, AestheticSpec[] aestheticSpecArray) {
        if (aestheticSpecArray != null) {
            for (AestheticSpec aestheticSpec : aestheticSpecArray) {
                arrayList.add(new Aesthetic(aestheticSpec.id, element.grammar.vis, string, element, null, aestheticSpec));
            }
        }
    }

    public static Aesthetic[] getLabelAesthetics(Element element, LabelProducer labelProducer, ElementLabelSpec elementLabelSpec) {
        ArrayList<Aesthetic> arrayList = new ArrayList<Aesthetic>();
        if (elementLabelSpec.color != null) {
            arrayList.add(new Aesthetic(elementLabelSpec.color.id, element.grammar.vis, COLOR_KEYWORD, element, labelProducer, elementLabelSpec.color));
        }
        if (elementLabelSpec.size != null) {
            arrayList.add(new Aesthetic(elementLabelSpec.size.id, element.grammar.vis, SIZE_KEYWORD, element, labelProducer, elementLabelSpec.size));
        }
        if (elementLabelSpec.font != null) {
            arrayList.add(new Aesthetic(elementLabelSpec.font.id, element.grammar.vis, FONT_KEYWORD, element, labelProducer, elementLabelSpec.font));
        }
        if (elementLabelSpec.visibility != null) {
            arrayList.add(new Aesthetic(elementLabelSpec.visibility.id, element.grammar.vis, VISIBILITY_KEYWORD, element, labelProducer, elementLabelSpec.visibility));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new Aesthetic[arrayList.size()]);
    }

    public static Aesthetic make(String string, Vis vis, String string2, Element element, AestheticSpec aestheticSpec) {
        return new Aesthetic(string, vis, string2, element, null, aestheticSpec);
    }

    public Aesthetic(String string, VisInterface visInterface, String string2, Element element, LabelProducer labelProducer, AestheticSpec aestheticSpec) {
        super(string, visInterface);
        Serializable serializable;
        Object object;
        Object object2;
        this.vis = (Vis)visInterface;
        this.type = string2;
        this.element = element;
        this.labelProducer = labelProducer;
        this.valueProvider = ValueProviderFactory.makeAestheticProvider(aestheticSpec, this.vis);
        this.spec = aestheticSpec;
        if (string2.equals(SIZE_KEYWORD)) {
            this.typeNumber = 4;
            this.producer = new SizeAestheticValueProducer();
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(DASHING_KEYWORD)) {
            this.typeNumber = 8;
            this.producer = new DashingAestheticValueProducer();
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(COLOR_KEYWORD)) {
            this.typeNumber = 2;
            this.producer = new ColorAestheticValueProducer();
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(META_KEYWORD)) {
            this.typeNumber = 16;
            this.producer = new MetaAestheticValueProducer(aestheticSpec.key, this.valueProvider);
            this.useForDefaultLegends = false;
            this.applicableToLegend = false;
            this.splits = false;
        } else if (string2.equals(ACCESSIBILITY_KEYWORD)) {
            this.typeNumber = 1024;
            AccessibilityValidation.validateAccessibilityAestheticSpec(this.vis, this.spec);
            this.producer = new AccessibilityAestheticValueProducer(this.vis.getVisContext(), aestheticSpec.key, this.valueProvider);
            this.useForDefaultLegends = false;
            this.applicableToLegend = false;
            this.splits = false;
        } else if (string2.equals(SYMBOL_KEYWORD)) {
            this.typeNumber = 32;
            this.producer = new SymbolAestheticValueProducer(this.element, this.vis.getVisContext(), true);
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(FONT_KEYWORD)) {
            this.typeNumber = 1;
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
            this.producer = new FontAestheticValueProducer(this.vis.getVisContext());
        } else if (string2.equals(SPLIT_KEYWORD)) {
            this.typeNumber = 64;
            this.producer = new SplitAestheticValueProducer();
            this.useForDefaultLegends = false;
            this.applicableToLegend = false;
            this.splits = true;
        } else if (string2.equals(STYLE_BY_KEYWORD)) {
            this.typeNumber = 128;
            this.producer = object2 = new StyleByAestheticValueProducer(this.vis.getVisContext(), this.element, aestheticSpec);
            this.useForDefaultLegends = ((StyleByAestheticValueProducer)object2).hasDefaultLegendProperties();
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(VISIBILITY_KEYWORD)) {
            this.typeNumber = 256;
            this.producer = new VisibilityAestheticValueProducer();
            this.useForDefaultLegends = true;
            this.applicableToLegend = true;
            this.splits = true;
        } else if (string2.equals(OFFSET_KEYWORD)) {
            this.typeNumber = 512;
            this.producer = new OffsetAestheticValueProducer(this.element.grammar.coordinates);
            this.useForDefaultLegends = false;
            this.applicableToLegend = false;
            this.splits = false;
        } else {
            throw new UnsupportedOperationException("Unsupported aesthetic: " + string2);
        }
        object2 = aestheticSpec.modifies;
        if (aestheticSpec.modifies == null) {
            this.modifiesPart = null;
            this.modifiesType = this.typeNumber == 4 ? element.getDefaultSizeModifierType(element.grammar.coordinates.transposesAxes()) : null;
            this.modifiesDescendants = false;
        } else if (BasicFactory.isString(object2)) {
            this.modifiesType = (String)object2;
            this.modifiesPart = null;
            this.modifiesDescendants = false;
        } else {
            ModifiesSpec modifiesSpec = (ModifiesSpec)object2;
            this.modifiesPart = modifiesSpec.part;
            object = modifiesSpec.type;
            this.modifiesType = object == null && this.typeNumber == 4 ? element.getDefaultSizeModifierType(element.grammar.coordinates.transposesAxes()) : object;
            this.modifiesDescendants = modifiesSpec.descendants != null ? modifiesSpec.descendants : false;
        }
        this.palette = AestheticPalette.makePalette(this.producer, aestheticSpec);
        boolean bl = this.valueProvider.isCategorical();
        object = this.vis.getVisContext();
        if (aestheticSpec.scale == null) {
            this.scale = new Scale(null, this.vis.getSize());
            ScaleBuilder.makeForProvider(this.scale, this.valueProvider, bl, (VisContext)object).createSpansFromProvider(this.valueProvider);
        } else {
            if (aestheticSpec.scale.local != null) {
                bl = aestheticSpec.scale.local;
            }
            serializable = new ArrayList<Unit>();
            serializable.add(this.valueProvider.getUnit());
            ArrayList<Field> arrayList = new ArrayList<Field>();
            if (this.valueProvider.getBaseField() != null) {
                arrayList.add(this.valueProvider.getBaseField());
            }
            this.scale = ScaleBuilder.createFromSpec(aestheticSpec.scale, false, bl, arrayList, serializable, this.vis, null, null);
            if (this.valueProvider.getBaseField() != null) {
                Scale scale = new Scale(null, this.vis.getSize());
                ScaleBuilder.makeForProvider(scale, this.valueProvider, bl, (VisContext)object).createSpansFromProvider(this.valueProvider);
                this.scale.useValuesFrom(scale);
            }
        }
        serializable = null;
        if (this.valueProvider.isCategorical() && this.valueProvider.getBaseField() != null) {
            serializable = this.scale.getCategoryCount();
        }
        this.scale.initializeForRequiredTickCount((Integer)serializable);
        this.mapping = AestheticMapping.makeMapping(this.producer, aestheticSpec, this.scale, this.valueProvider);
        this.nullValue = this.producer.make(aestheticSpec.nullValue);
    }

    public final boolean isSplitting() {
        return this.splits;
    }

    public final boolean isDefaultLegendAesthetic() {
        return this.useForDefaultLegends;
    }

    public final boolean isApplicableToLegend() {
        return this.applicableToLegend;
    }

    public Shape apply(Shape shape, Row row) {
        double d = this.valueProvider.getNumber(row);
        shape.setRowValue(d);
        if (!Double.isNaN(d)) {
            Double d2 = this.scale.toZeroOneClamped(d, this.valueProvider.getUnit());
            if (d2 != null) {
                Shape shape2 = this.getTargetShape(shape);
                Object object = this.getAestheticValue(shape2, d2, d, true, this.modifiesType);
                return this.applyAestheticValue(shape, object, this.modifiesType);
            }
        } else {
            if (this.nullValue != null) {
                return this.applyAestheticValue(shape, this.nullValue, this.modifiesType);
            }
            return this.applyAestheticValue(shape, null, this.modifiesType);
        }
        return shape;
    }

    private Shape getTargetShape(Shape shape) {
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null && this.modifiesPart != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (this.modifiesPart.equals(shapeArray[i].getElementPart())) {
                    return shapeArray[i];
                }
                Shape shape2 = this.getTargetShape(shapeArray[i]);
                if (shapeArray[i] == shape2) continue;
                return shape2;
            }
        }
        return shape;
    }

    public Shape applyValue(Shape shape, double d, Number number, boolean bl) {
        Object object = this.getAestheticValue(shape, d, number, bl, this.modifiesType);
        return this.applyAestheticValue(shape, object, this.modifiesType);
    }

    public boolean modifiesSymbol() {
        return this.typeNumber == 32 || SYMBOL_KEYWORD.equals(this.modifiesPart);
    }

    public final AestheticValueProducer getProducer() {
        return this.producer;
    }

    public final AestheticMapping getMapping() {
        return this.mapping;
    }

    public final String getModifiesType() {
        return this.modifiesType;
    }

    public Object getAestheticValue(Shape shape, double d, Number number, boolean bl, String string) {
        Object object;
        assert (d >= 0.0 && d <= 1.0);
        if (this.producer != null && this.element != null) {
            this.producer.setGrammarSize(this.element.grammar.graphSize);
        }
        if (this.valueProvider.isCategorical()) {
            int n = (int)Math.round(number.doubleValue());
            Integer n2 = this.scale.getScaleCategoryIndex(n, this.valueProvider.getUnit());
            if (bl && this.valueProvider.getBaseField() != null && this.valueProvider.getBaseField().order != null) {
                n2 = this.valueProvider.getBaseField().order[n2];
                object = this.producer.applyCategoricalMapping(n2, this.mapping);
            } else {
                object = this.producer.applyCategoricalMapping(n, this.mapping);
            }
            if (object == null) {
                object = this.producer.makeUsingPalette(n2, n, this.palette, this.valueProvider);
            }
            if (object == null) {
                object = this.producer.getDefaultForCategory(n2, n, d);
            }
        } else {
            object = this.producer.applyNumericMapping(shape, d, this.mapping, string);
            if (object == null) {
                object = this.producer.getDefaultForNumeric(d, number);
            }
        }
        return object;
    }

    public Shape applyAestheticValue(Shape shape, Object object, String string) {
        Shape shape2 = shape;
        if (this.typeNumber == 512) {
            this.producer.setGrammarSize(this.element.grammar.graphSize);
        }
        boolean bl = false;
        if (this.modifiesPart == null || this.modifiesPart.equals(shape2.getElementPart())) {
            this.prepareShapeParts(shape2, true);
            shape2 = this.producer.modify(shape2, object, string);
            bl = true;
            this.prepareShapeParts(shape2, false);
        }
        if (shape2 != shape && shape2 instanceof Schema) {
            return shape2;
        }
        this.modifyShapeParts(shape2, object, bl);
        return shape2;
    }

    private void modifyShapeParts(Shape shape, Object object, boolean bl) {
        Shape[] shapeArray;
        boolean bl2;
        boolean bl3 = bl2 = this.typeNumber == 4;
        if (!(bl2 && this.modifiesPart == null || (shapeArray = shape.getParts()) == null)) {
            for (int i = 0; i < shapeArray.length; ++i) {
                boolean bl4 = false;
                boolean bl5 = true;
                if (this.modifiesPart == null || this.modifiesPart.equals(shapeArray[i].getElementPart()) || bl && this.modifiesDescendants && !bl2) {
                    Shape shape2 = shapeArray[i];
                    shapeArray[i] = this.producer.modify(shapeArray[i], object, this.modifiesType);
                    bl4 = true;
                    if (bl2 || shapeArray[i] != shape2 && shapeArray[i] instanceof Schema) {
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                this.modifyShapeParts(shapeArray[i], object, bl4);
            }
        }
    }

    private void prepareShapeParts(Shape shape, boolean bl) {
        if (shape.getParts() != null && this.typeNumber == 4) {
            Shape[] shapeArray = shape.getParts();
            for (int i = 0; i < shapeArray.length; ++i) {
                int n = shapeArray[i].getScaleDimensions();
                boolean bl2 = n == 3 || n == 0;
                shapeArray[i].setRelativeToParent(bl && bl2);
            }
        }
    }
}

