/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapValue;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.CategoricalAestheticMapValue;
import com.ibm.vis.engine.internal.grammar.aesthetic.PercentageAestheticMapValue;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.MappingSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AestheticMapValueFactory {
    public static List<AestheticMapValue> createMapValue(MappingSpec mappingSpec, AestheticValueProducer aestheticValueProducer, Scale scale, ValueProvider valueProvider) {
        ArrayList<AestheticMapValue> arrayList;
        block7: {
            Object object;
            block5: {
                block6: {
                    String string;
                    Object object2 = aestheticValueProducer.getMappingValueSpec(mappingSpec);
                    object = aestheticValueProducer.make(object2);
                    arrayList = new ArrayList<AestheticMapValue>();
                    if (mappingSpec.at == null) break block5;
                    if (!BasicFactory.isString(mappingSpec.at)) break block6;
                    String string2 = string = (String)mappingSpec.at;
                    String string3 = string.substring(0, string2.length() - 1);
                    if (string.endsWith("%") && AestheticMapValueFactory.canBeParsedToDouble(string3)) {
                        arrayList.add(new PercentageAestheticMapValue(object, Double.parseDouble(string3), scale, valueProvider));
                    }
                    break block7;
                }
                if (!BasicFactory.isNumber(mappingSpec.at)) break block7;
                Number number = (Number)mappingSpec.at;
                if (scale.isCategorical()) {
                    arrayList.add(new CategoricalAestheticMapValue(object, number, scale, valueProvider));
                } else {
                    arrayList.add(new AestheticMapValue(object, number, scale, valueProvider));
                }
                break block7;
            }
            if (mappingSpec.atLabel != null) {
                String[] stringArray = valueProvider.getCategories();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equals(mappingSpec.atLabel)) continue;
                    arrayList.add(new CategoricalAestheticMapValue(object, i, scale, valueProvider));
                }
            }
        }
        return arrayList;
    }

    public static boolean canBeParsedToDouble(String string) throws NumberFormatException {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

