/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapValue;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapValueComparator;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapValueFactory;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AestheticMapping {
    private final List<AestheticMapValue> mapValues;
    public static final String SYMMETRIC_LOWER = "symmetricLower";
    public static final String SYMMETRIC_UPPER = "symmetricUpper";
    private Range range;

    public static AestheticMapping makeMapping(AestheticValueProducer aestheticValueProducer, AestheticSpec aestheticSpec, Scale scale, ValueProvider valueProvider) {
        if (aestheticSpec.mapping == null) {
            return null;
        }
        AestheticMapping.checkValidMappingStops(valueProvider, aestheticSpec.mapping);
        return new AestheticMapping(aestheticValueProducer, aestheticSpec.mapping, scale, valueProvider);
    }

    private static void checkValidMappingStops(ValueProvider valueProvider, MappingSpec[] mappingSpecArray) {
        Field field = null;
        if (valueProvider != null) {
            field = valueProvider.getBaseField();
        }
        boolean bl = field != null && field.isCategorical();
        for (MappingSpec mappingSpec : mappingSpecArray) {
            if (mappingSpec.at == null) continue;
            String string = mappingSpec.at.toString();
            if (!(!BasicFactory.isString(mappingSpec.at) || string.endsWith("%") || string.equals(SYMMETRIC_UPPER) || string.equals(SYMMETRIC_LOWER) || bl)) {
                throw new SpecException("Mapping stops values as string different than \"symmetricUpper\", \"symmetricLower\", or a percentage value are invalid.", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            if (!bl || !string.endsWith("%")) continue;
            throw new SpecException("Percentage indexes are not allowed in mappings for categorical fields.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    private AestheticMapping(AestheticValueProducer aestheticValueProducer, MappingSpec[] mappingSpecArray, Scale scale, ValueProvider valueProvider) {
        this.calculateRange(scale, valueProvider);
        HashMap<Number, AestheticMapValue> hashMap = new HashMap<Number, AestheticMapValue>();
        this.applyDivergentColorRanges(mappingSpecArray, scale);
        for (int i = 0; i < mappingSpecArray.length && (mappingSpecArray[i].at != null || mappingSpecArray[i].atLabel != null); ++i) {
            List<AestheticMapValue> list = AestheticMapValueFactory.createMapValue(mappingSpecArray[i], aestheticValueProducer, scale, valueProvider);
            for (int j = 0; j < list.size(); ++j) {
                AestheticMapValue aestheticMapValue = list.get(j);
                if (aestheticMapValue == null) continue;
                hashMap.put(aestheticMapValue.getStop(), aestheticMapValue);
            }
        }
        this.mapValues = new ArrayList(hashMap.values());
        BasicFactory.sortList(this.mapValues, new AestheticMapValueComparator());
    }

    private void calculateRange(Scale scale, ValueProvider valueProvider) {
        ScaleSpan scaleSpan;
        this.range = valueProvider.getRange();
        Unit unit = valueProvider.getUnit();
        if (scale != null && unit != null && this.range != null && (scaleSpan = scale.getMatchingSpan(this.range.getMin(), unit)) != null) {
            this.range = scaleSpan.getAdjustedInputRange();
        }
        if (this.range == null) {
            this.range = new Range(0.0, 0.0);
        }
    }

    private void applyDivergentColorRanges(MappingSpec[] mappingSpecArray, Scale scale) {
        double d = -1.0;
        double d2 = -1.0;
        int n = -1;
        int n2 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        for (int i = 0; i < mappingSpecArray.length; ++i) {
            Object object = mappingSpecArray[i].at;
            if (!BasicFactory.isString(object)) continue;
            String string = (String)object;
            if (string.equals(SYMMETRIC_LOWER)) {
                bl = true;
                n = i;
                if (i + 1 < mappingSpecArray.length && BasicFactory.isNumber(mappingSpecArray[i + 1].at)) {
                    d3 = ((Number)mappingSpecArray[i + 1].at).doubleValue();
                    d = d3 - this.range.getMin();
                    continue;
                }
                throw new SpecException("symmetricLower is not provided with a threshold. A threshold offset must be provided after symmetricLower value to calculate the Divergent Color Range.", ErrorCode.SPEC_INVALID_VALUE, null);
            }
            if (!string.equals(SYMMETRIC_UPPER)) continue;
            bl = true;
            n2 = i;
            if (i - 1 >= 0 && BasicFactory.isNumber(mappingSpecArray[i - 1].at)) {
                d4 = ((Number)mappingSpecArray[i - 1].at).doubleValue();
                d2 = this.range.getMax() - d4;
                continue;
            }
            throw new SpecException("symmetricUpper is not provided with a threshold. A threshold offset must be provided before symmetricUpper value to calculate the Divergent Color Range.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (scale != null && scale.isCategorical() && bl) {
            throw new SpecException("symmetricUpper/symmetricLower is not applicable to categorical scale span", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (d > d2) {
            if (n != -1) {
                mappingSpecArray[n].at = d3 - d;
            }
            if (n2 != -1) {
                mappingSpecArray[n2].at = d4 + d;
            }
        } else {
            if (n2 != -1) {
                mappingSpecArray[n2].at = d4 + d2;
            }
            if (n != -1) {
                mappingSpecArray[n].at = d3 - d2;
            }
        }
    }

    public Object getCategoryValue(int n) {
        for (AestheticMapValue aestheticMapValue : this.mapValues) {
            if (aestheticMapValue.getIndex() != n) continue;
            return aestheticMapValue.getValue();
        }
        return null;
    }

    public double getStop(int n) {
        return this.mapValues.get(n).getStop().doubleValue();
    }

    public Object getValue(int n) {
        return this.mapValues.get(n).getValue();
    }

    public int size() {
        return this.mapValues.size();
    }

    protected Range getRange() {
        return this.range;
    }
}

