/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AestheticPalette {
    private final Object[] paletteItems;

    public static AestheticPalette makePalette(AestheticValueProducer aestheticValueProducer, AestheticSpec aestheticSpec) {
        if (aestheticSpec.palette != null) {
            return new AestheticPalette(aestheticValueProducer, aestheticSpec);
        }
        return null;
    }

    private AestheticPalette(AestheticValueProducer aestheticValueProducer, AestheticSpec aestheticSpec) {
        Object[] objectArray = aestheticSpec.palette;
        if (objectArray.length == 0) {
            throw new SpecException("A palette must have at least one entry", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        this.paletteItems = new Object[objectArray.length];
        for (int i = 0; i < this.paletteItems.length; ++i) {
            this.paletteItems[i] = aestheticValueProducer.make(objectArray[i]);
        }
    }

    public Object getPaletteItem(int n) {
        return this.paletteItems[Math.abs(n) % this.paletteItems.length];
    }
}

