/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapping;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AestheticValueProducer {
    private Dim grammarSize;

    public abstract Object make(Object var1);

    public abstract Object getMappingValueSpec(MappingSpec var1);

    protected abstract Object interpolate(Object var1, Object var2, double var3);

    public abstract Object getAestheticFromPalette(int var1, int var2, AestheticPalette var3);

    public abstract Object getDefaultForCategory(int var1, int var2, double var3);

    public abstract Shape modify(Shape var1, Object var2, String var3);

    protected AestheticValueProducer() {
    }

    public Dim getGrammarSize() {
        return this.grammarSize;
    }

    public void setGrammarSize(Dim dim) {
        this.grammarSize = dim;
    }

    public Object getDefaultForNumeric(double d, Number number) {
        return this.interpolate(null, null, d);
    }

    public Object makeUsingPalette(int n, int n2, AestheticPalette aestheticPalette, ValueProvider valueProvider) {
        if (valueProvider.isCategorical() && aestheticPalette != null) {
            return this.getAestheticFromPalette(n, n2, aestheticPalette);
        }
        return null;
    }

    public Object applyCategoricalMapping(int n, AestheticMapping aestheticMapping) {
        if (aestheticMapping != null) {
            return aestheticMapping.getCategoryValue(n);
        }
        return null;
    }

    public Object applyNumericMapping(Shape shape, double d, AestheticMapping aestheticMapping, String string) {
        double d2 = 1.0E-8;
        if (aestheticMapping == null || aestheticMapping.size() == 0) {
            return null;
        }
        int n = 0;
        int n2 = aestheticMapping.size() - 1;
        for (int i = 0; i < aestheticMapping.size(); ++i) {
            if (aestheticMapping.getStop(i) < d || Math.abs(d - aestheticMapping.getStop(i)) < d2) {
                n = i;
            }
            if (!(aestheticMapping.getStop(i) > d) && !(Math.abs(aestheticMapping.getStop(i) - d) < d2)) continue;
            n2 = i;
            break;
        }
        Object object = aestheticMapping.getValue(n);
        Object object2 = aestheticMapping.getValue(n2);
        return this.calculateNumericMapping(shape, d, aestheticMapping, n, n2, object, object2, string);
    }

    protected Object calculateNumericMapping(Shape shape, double d, AestheticMapping aestheticMapping, int n, int n2, Object object, Object object2, String string) {
        Number number;
        Object object3 = object;
        Object object4 = object2;
        if (BasicFactory.isString(object3)) {
            number = (Number)this.interpolate(null, null, 1.0);
            object3 = UnitConverter.convertLength(object3, number.doubleValue(), number.doubleValue());
        }
        if (BasicFactory.isString(object4)) {
            number = (Number)this.interpolate(null, null, 1.0);
            object4 = UnitConverter.convertLength(object4, number.doubleValue(), number.doubleValue());
        }
        if (n == n2) {
            return object3;
        }
        double d2 = (d - aestheticMapping.getStop(n)) / (aestheticMapping.getStop(n2) - aestheticMapping.getStop(n));
        return this.interpolate(object3, object4, d2);
    }
}

