/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ColorAestheticValueProducer
extends AestheticValueProducer {
    private final ColorNew[] defaultPalette = ColorUtil.getDefaultColors();

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.color == null) {
            throw new SpecException("Color aesthetic should use 'color' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.color;
    }

    @Override
    public Object make(Object object) {
        return ColorUtil.toCanonicalColor(object);
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null) {
            return shape;
        }
        ColorNew colorNew = (ColorNew)object;
        if ("outline".equals(string)) {
            ColorNew colorNew2 = ColorUtil.makeCombinedColor(colorNew, shape.getOutline());
            StyleBuilder.modifyStrokeColor(shape, colorNew2);
        } else if ("both".equals(string)) {
            ColorNew colorNew3 = ColorUtil.makeCombinedColor(colorNew, shape.getOutline());
            StyleBuilder.modifyStrokeColor(shape, colorNew3);
            StyleBuilder.modifyMainColor(shape, colorNew);
        } else {
            StyleBuilder.modifyMainColor(shape, colorNew);
        }
        return shape;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        int n3 = n < 0 ? -n : n;
        return this.defaultPalette[n3 % this.defaultPalette.length];
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        if (object == null || object2 == null) {
            return ColorUtil.temperature(d);
        }
        ColorNew colorNew = (ColorNew)object;
        return colorNew.interpolateWithColor((ColorNew)object2, d);
    }
}

