/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DashingAestheticValueProducer
extends AestheticValueProducer {
    private static final String[] DASH_ORDER = new String[]{"Solid", "LongDashDotDot", "LongDashDot", "LongDash", "ShortDashDotDot", "ShortDashDot", "ShortDash", "DashDot", "Dash", "ShortDot", "Dot"};

    DashingAestheticValueProducer() {
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.pattern == null) {
            throw new SpecException("Dashing aesthetic should use 'pattern' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.pattern;
    }

    @Override
    public Object make(Object object) {
        if (BasicFactory.isString(object)) {
            String string = (String)object;
            for (int i = 0; i < DASH_ORDER.length; ++i) {
                if (!DASH_ORDER[i].equals(string)) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null) {
            return shape;
        }
        int n = (int)Math.round(((Number)object).doubleValue());
        StyleBuilder.modifyStrokeStyle(shape, DASH_ORDER[n]);
        return shape;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return Math.abs(n) % DASH_ORDER.length;
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        double d2;
        double d3 = object == null ? 0.0 : ((Number)object).doubleValue();
        double d4 = Math.round(d3 + d * ((d2 = object2 == null ? (double)DASH_ORDER.length : ((Number)object2).doubleValue()) - d3));
        if (d4 >= (double)DASH_ORDER.length) {
            d4 -= 1.0;
        }
        return d4;
    }
}

