/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FontAestheticValueProducer
extends AestheticValueProducer {
    private final VisContext context;

    public FontAestheticValueProducer(VisContext visContext) {
        this.context = visContext;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        Font font = FontHelper.makeDefaultFont(12.0, this.context.getMinimumFontSize(), this.context.usesFractionalMetrics());
        return font;
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        return d >= 1.0 ? object2 : object;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.font == null) {
            throw new SpecException("Font aesthetic should use 'font' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.font;
    }

    @Override
    public Object make(Object object) {
        FontSpec fontSpec;
        if (object == null) {
            return null;
        }
        if (object instanceof StyleSpec) {
            fontSpec = new FontSpec();
            fontSpec.size = ((StyleSpec)object).size;
        } else if (object instanceof ColorSpec) {
            fontSpec = new FontSpec();
        } else if (object instanceof FontSpec) {
            fontSpec = (FontSpec)object;
        } else {
            throw new SpecException("Font aesthetic palettes or mappings must have fonts as values", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        Font font = FontHelper.makeFromSpec(fontSpec, this.context.getMinimumFontSize(), this.context.usesFractionalMetrics());
        return font;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null || !(shape instanceof Text)) {
            return shape;
        }
        Text text = (Text)shape;
        text.setFont((Font)object);
        return shape;
    }
}

