/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class MetaAestheticValueProducer
extends AestheticValueProducer {
    private final String key;
    private final String[] categories;

    MetaAestheticValueProducer(String string, ValueProvider valueProvider) {
        this.key = string;
        String[] stringArray = null;
        if (valueProvider.getBaseField() != null) {
            stringArray = valueProvider.getBaseField().categories;
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{""};
            }
        } else {
            stringArray = new String[]{valueProvider.getNumber(Row.createEmptyRow(0, 0)) + ""};
        }
        this.categories = stringArray;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        return null;
    }

    @Override
    public Object make(Object object) {
        return null;
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        throw new EngineException("MetaAestheticValueProducer#interpolate was called", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null) {
            return shape;
        }
        shape.setMeta(this.key, object.toString());
        return shape;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        int n3 = n2;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.categories.length) {
            n3 = this.categories.length - 1;
        }
        return this.categories[n3];
    }

    @Override
    public Object getDefaultForNumeric(double d, Number number) {
        return number;
    }
}

