/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class OffsetAestheticValueProducer
extends AestheticValueProducer {
    private final Coordinates coordinates;

    public OffsetAestheticValueProducer(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.size == null) {
            throw new SpecException("Offset aesthetic should use 'size' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.size;
    }

    @Override
    public Object make(Object object) {
        return object;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        assert (string == null);
        if (object == null) {
            return shape;
        }
        Dim dim = this.getGrammarSize();
        double d = this.coordinates.getDistancefromBaseInYDirection(dim);
        double d2 = UnitConverter.convertLength(object, d, d);
        if (d2 != 0.0) {
            Point point = this.coordinates.getOffsetInFreeDirection(shape, d2, dim);
            shape.affine(1.0, point.getX(), 1.0, point.getY(), false);
        }
        return shape;
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        double d2 = object == null ? 0.0 : ((Number)object).doubleValue();
        double d3 = object2 == null ? 100.0 : ((Number)object2).doubleValue();
        return d2 + d * (d3 - d2);
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return null;
    }
}

