/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticMapping;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.SizeAestheticScaleValue;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SizeAestheticValueProducer
extends AestheticValueProducer {
    private static final double DEFAULT_MIN_INTERPOLATE = 20.0;
    private static final double DEFAULT_MAX_INTERPOLATE = 100.0;

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.size == null) {
            throw new SpecException("Size aesthetic should use 'size' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.size;
    }

    @Override
    public Object make(Object object) {
        return object;
    }

    @Override
    protected Object calculateNumericMapping(Shape shape, double d, AestheticMapping aestheticMapping, int n, int n2, Object object, Object object2, String string) {
        Object object3;
        double d2;
        Object object4 = object;
        boolean bl = false;
        double d3 = d2 = this.getGrammarSize() == null ? 100.0 : Math.min(this.getGrammarSize().getWidth(), this.getGrammarSize().getHeight());
        if (object4 == null) {
            bl = true;
        } else if (BasicFactory.isString(object4)) {
            bl = ((String)object4).endsWith("%");
            object4 = UnitConverter.convertLength(object4, 100.0, d2);
        } else if (BasicFactory.isNumber(object4)) {
            boolean bl2 = bl = ((Number)object4).doubleValue() == 0.0;
        }
        if (n == n2) {
            object3 = object4;
            if (object3 == null) {
                object3 = this.interpolate(null, null, d);
            }
            if (bl) {
                object3 = object3 + "%";
            }
        } else {
            Object object5 = object2;
            boolean bl3 = false;
            if (object5 == null) {
                bl3 = true;
            } else if (BasicFactory.isString(object5)) {
                bl3 = ((String)object5).endsWith("%");
                object5 = UnitConverter.convertLength(object5, 100.0, d2);
            } else if (BasicFactory.isNumber(object5)) {
                bl3 = ((Number)object5).doubleValue() == 0.0;
            }
            double d4 = (d - aestheticMapping.getStop(n)) / (aestheticMapping.getStop(n2) - aestheticMapping.getStop(n));
            if (bl != bl3) {
                assert (shape != null);
                Rect rect = shape.getBounds();
                if ("height".equals(string) || rect.getWidth() == rect.getHeight()) {
                    if (!bl) {
                        object4 = ((Number)object4).doubleValue() / rect.getHeight() * 100.0;
                    } else {
                        object5 = ((Number)object5).doubleValue() / rect.getHeight() * 100.0;
                    }
                    object3 = this.interpolate(object4, object5, d4) + "%";
                } else if ("width".equals(string)) {
                    if (!bl) {
                        object4 = ((Number)object4).doubleValue() / rect.getWidth() * 100.0;
                    } else {
                        object5 = ((Number)object5).doubleValue() / rect.getWidth() * 100.0;
                    }
                    object3 = this.interpolate(object4, object5, d4) + "%";
                } else {
                    Object object6;
                    Object object7;
                    Object object8 = object7 = object4;
                    Object object9 = object6 = object5;
                    if (!bl) {
                        object8 = ((Number)object4).doubleValue() / rect.getWidth() * 100.0;
                        object7 = ((Number)object4).doubleValue() / rect.getHeight() * 100.0;
                    } else {
                        object9 = ((Number)object5).doubleValue() / rect.getWidth() * 100.0;
                        object6 = ((Number)object5).doubleValue() / rect.getHeight() * 100.0;
                    }
                    object3 = new SizeAestheticScaleValue(((Number)this.interpolate(object8, object9, d4)).doubleValue() / 100.0, ((Number)this.interpolate(object7, object6, d4)).doubleValue() / 100.0);
                }
            } else {
                object3 = this.interpolate(object4, object5, d4);
                if (bl) {
                    object3 = object3 + "%";
                }
            }
        }
        return object3;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        Dim dim;
        double d;
        if (object == null) {
            return shape;
        }
        if (shape instanceof Text) {
            ((Text)shape).setSizeAestheticValue(object);
        }
        if (object instanceof SizeAestheticScaleValue) {
            return SizeAestheticValueProducer.modifyByPercent(shape, ((SizeAestheticScaleValue)object).getWidthScale(), ((SizeAestheticScaleValue)object).getHeightScale(), string);
        }
        if (BasicFactory.isString(object)) {
            d = UnitConverter.convertLength(object, 100.0, 100.0);
            if (((String)object).endsWith("%")) {
                return SizeAestheticValueProducer.modifyByPercent(shape, d /= 100.0, d, string);
            }
        } else {
            d = ((Number)object).doubleValue();
        }
        if ((dim = shape.getActualDim()) != null && string == null) {
            double d2 = dim.getWidth();
            if (Double.isNaN(shape.getRowValue()) && d > d2) {
                d = d2;
            }
        }
        return SizeAestheticValueProducer.modifyByPixels(shape, d, string);
    }

    private static Shape modifyByPercent(Shape shape, double d, double d2, String string) {
        if (shape.isFilled()) {
            if ("outline".equals(string)) {
                StyleBuilder.scaleStrokeSize(shape, d);
                return shape;
            }
            if ("height".equals(string)) {
                shape.scale(1.0, d2);
            } else if ("width".equals(string)) {
                shape.scale(d, 1.0);
            } else {
                shape.scale(d, d2);
            }
        } else if (Path.isBarLike(shape)) {
            if (shape.getSymbol() != null && ("i-beam".equals(shape.getSymbol()) || "t-beam".equals(shape.getSymbol())) && "width".equals(string)) {
                SizeAestheticValueProducer.scaleByDimension(shape, d, 1.0);
            } else {
                SizeAestheticValueProducer.scaleByDimension(shape, d, d2);
            }
        } else if (!"outline".equals(string) && !"height".equals(string)) {
            StyleBuilder.scaleStrokeSize(shape, d2);
            return shape;
        }
        return shape;
    }

    public static Shape modifyByPixels(Shape shape, double d, String string) {
        Shape shape2 = shape.getContainingShape();
        Rect rect = shape2 != null && 1010 == shape2.getType() ? new Bounds(shape.getBoundsSpec(), null).getRectWithinParent((Rect)shape2.getGeom().copy()) : shape.getBounds();
        if (shape.isFilled()) {
            if ("outline".equals(string)) {
                StyleBuilder.setStrokeSize(shape, d);
                return shape;
            }
            if (rect != null) {
                double d2 = rect.getHeight();
                double d3 = rect.getWidth();
                if (d2 > 0.0 && "height".equals(string)) {
                    shape.scale(1.0, d / d2);
                } else if (d3 > 0.0 && "width".equals(string)) {
                    shape.scale(d / d3, 1.0);
                } else if (d3 > 0.0 && d2 > 0.0) {
                    shape.scale(d / d3, d / d2);
                }
            }
        } else if (Path.isBarLike(shape)) {
            if (rect != null && rect.getWidth() > 0.0 && rect.getHeight() > 0.0) {
                shape.scale(d / rect.getWidth(), d / rect.getHeight());
            }
        } else if (!"outline".equals(string) && !"height".equals(string)) {
            StyleBuilder.setStrokeSize(shape, d);
            return shape;
        }
        return shape;
    }

    protected static void scaleByDimension(Shape shape, double d, double d2) {
        int n = shape.getScaleDimensions();
        double d3 = n == 2 ? 1.0 : d;
        double d4 = n == 1 ? 1.0 : d2;
        shape.scale(d3, d4);
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return d * 100.0 + "%";
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        double d2 = object == null ? 0.0 : ((Number)object).doubleValue();
        double d3 = object2 == null ? 100.0 : ((Number)object2).doubleValue();
        return d2 + d * (d3 - d2);
    }

    @Override
    public Object getDefaultForNumeric(double d, Number number) {
        return this.interpolate(20.0, 100.0, d) + "%";
    }
}

