/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.aesthetic.SymbolAestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StyleByAestheticValueProducer
extends AestheticValueProducer {
    private final VisContext visContext;
    private final Element element;
    private final boolean hasLegendProperties;

    public StyleByAestheticValueProducer(VisContext visContext, Element element, AestheticSpec aestheticSpec) {
        this.visContext = visContext;
        this.element = element;
        boolean bl = false;
        if (aestheticSpec.palette != null) {
            for (Object object : aestheticSpec.palette) {
                StyleSpec styleSpec = null;
                if (object instanceof StyleSpec) {
                    styleSpec = (StyleSpec)object;
                }
                if (styleSpec == null || styleSpec.symbol == null && styleSpec.fill == null && styleSpec.outline == null && styleSpec.stroke == null && styleSpec.effect == null && styleSpec.startArrow == null && styleSpec.endArrow == null && styleSpec.font == null && styleSpec.image == null) continue;
                bl = true;
                break;
            }
        }
        this.hasLegendProperties = bl;
    }

    public boolean hasDefaultLegendProperties() {
        return this.hasLegendProperties;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return null;
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        return null;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.style == null) {
            throw new SpecException("StyleBy aesthetic should use 'style' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.style;
    }

    @Override
    public Object make(Object object) {
        return object;
    }

    private Shape updateTextShape(Shape shape, StyleSpec styleSpec) {
        Text text = (Text)shape;
        if (styleSpec.align != null) {
            text.align = styleSpec.align;
        }
        if (styleSpec.valign != null) {
            text.valign = styleSpec.valign;
        }
        if (styleSpec.font != null) {
            FontSpec fontSpec = new FontSpec();
            fontSpec.family = styleSpec.font.family;
            fontSpec.size = styleSpec.font.size;
            fontSpec.style = styleSpec.font.style;
            fontSpec.weight = styleSpec.font.weight;
            if (fontSpec.size == null) {
                fontSpec.size = text.getFont().getSize();
            }
            if (fontSpec.weight == null) {
                fontSpec.weight = text.getFont().getBold() ? "bold" : "regular";
            }
            text.setFont(FontHelper.makeFromSpec(fontSpec, this.visContext.getMinimumFontSize(), this.visContext.usesFractionalMetrics()));
        }
        return shape;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null) {
            return shape;
        }
        StyleSpec styleSpec = null;
        if (object instanceof StyleSpec) {
            styleSpec = (StyleSpec)object;
        }
        Shape shape2 = StyleBuilder.modifyShapeStyle(shape, styleSpec);
        shape2 = SymbolAestheticValueProducer.modifySymbol(shape2, styleSpec, this.element, this.visContext, true);
        if (shape instanceof Text) {
            shape2 = this.updateTextShape(shape2, styleSpec);
        }
        if (this.visContext.getGenerateAccessibility()) {
            shape2.getA11yInfo().fromStyle(styleSpec.accessibility);
        }
        return shape2;
    }
}

