/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SymbolAestheticValueProducer
extends AestheticValueProducer {
    private String[] symbolNames;
    private int[] symbolIndices;
    private final Element element;
    private final VisContext visContext;
    private final boolean needScaling;

    public int getCategoricalIndicesLength() {
        return this.symbolIndices.length;
    }

    public String getContinuousSymbolName(int n) {
        return this.symbolNames[n];
    }

    public SymbolAestheticValueProducer(Element element, VisContext visContext, boolean bl) {
        this.element = element;
        this.visContext = visContext;
        this.needScaling = bl;
        if (this.element != null && "interval".equals(this.element.type)) {
            this.symbolNames = new String[]{"rectangle", "i-beam", "t-beam"};
            this.symbolIndices = new int[]{0, 1, 2};
        } else {
            this.symbolNames = new String[]{"circle", "poly-8", "poly-7", "poly-6", "poly-5", "square", "triangle", "plus", "cross", "star", "star-6", "star-7"};
            this.symbolIndices = new int[]{0, 5, 7, 8, 9, 6, 3, 4, 2};
        }
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        return this.findSymbolIndex(this.symbolNames[this.symbolIndices[n % this.symbolIndices.length]]);
    }

    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        double d2 = object == null ? 0.0 : ((Number)object).doubleValue();
        double d3 = object2 == null ? (double)(this.symbolNames.length - 1) : ((Number)object2).doubleValue();
        return Math.round(d2 + d * (d3 - d2));
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.symbol == null) {
            throw new SpecException("Symbol aesthetic should use 'symbol' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.symbol;
    }

    @Override
    public Object make(Object object) {
        if (object == null) {
            return null;
        }
        if (BasicFactory.isString(object)) {
            int n = this.findSymbolIndex((String)object);
            if (n >= 0) {
                return n;
            }
            return object;
        }
        return object;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        String string2 = null;
        if (object == null || !this.isSupportedShape(shape)) {
            return shape;
        }
        Dim dim = shape.getActualDim();
        Rect rect = shape.getBounds();
        if (dim == null) {
            dim = rect.getExtent();
        }
        Shape shape2 = null;
        ArrayList<Shape> arrayList = null;
        if (BasicFactory.isNumber(object)) {
            int n = (int)Math.round(((Number)object).doubleValue());
            if (n >= 0) {
                string2 = this.symbolNames[n];
                shape2 = SymbolBuilder.makeSymbol(string2, rect.getCenterX(), rect.getCenterY(), dim.getWidth(), dim.getHeight(), null, this.visContext);
            }
        } else if (BasicFactory.isString(object)) {
            string2 = (String)object;
            shape2 = SymbolBuilder.makeSymbol(string2, rect.getCenterX(), rect.getCenterY(), dim.getWidth(), dim.getHeight(), null, this.visContext);
        } else if (((SymbolSpec)object).shape != null) {
            CustomGlyphBuilder customGlyphBuilder;
            Dim dim2 = null;
            if (this.element != null) {
                dim2 = this.element.extent;
            }
            if ((shape2 = (customGlyphBuilder = new CustomGlyphBuilder((SymbolSpec)object, dim2, this.visContext)).makeCustomShape(rect.getCenterX(), rect.getCenterY(), dim.getWidth(), dim.getHeight(), null)).getParts() != null && shape2.getParts().length == 1) {
                shape2 = shape2.getParts()[0];
            }
            arrayList = new ArrayList<Shape>();
            this.saveStyles(shape2, arrayList);
        }
        if (shape2 != null) {
            Shape shape3 = shape.getParts() != null && shape.getParts().length == 1 ? shape.getParts()[0] : shape;
            this.copyStyles(shape2, shape3);
            if (arrayList != null) {
                this.restoreStyles(shape2, arrayList.iterator());
            }
            if (this.needScaling && this.element != null && "interval".equals(this.element.type)) {
                SymbolBuilder.scaleSymbol(shape2, string2, dim.getWidth(), dim.getHeight());
            }
            return shape2;
        }
        return shape;
    }

    private void copyStyles(Shape shape, Shape shape2) {
        shape.copyInfoFrom(shape2);
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                this.copyStyles(shapeArray[i], shape2);
            }
        }
    }

    private void saveStyles(Shape shape, List<Shape> list) {
        if (shape == null) {
            return;
        }
        Shape shape2 = ShapeFactory2.CreateCircle(0.0, 0.0, 0.0);
        shape2.setFill(shape.getFill());
        shape2.setOutline(shape.getOutline());
        shape2.setStroke(shape.getStroke());
        shape2.addMeta(shape);
        list.add(shape2);
        Shape[] shapeArray = shape.getParts();
        if (shapeArray != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                this.saveStyles(shapeArray[i], list);
            }
        }
    }

    private void restoreStyles(Shape shape, Iterator<Shape> iterator) {
        Shape[] shapeArray;
        String string;
        if (!iterator.hasNext()) {
            return;
        }
        Shape shape2 = iterator.next();
        if (shape2.getFill() != null) {
            shape.setFill(shape2.getFill());
        }
        if (shape2.getOutline() != null) {
            shape.setOutline(shape2.getOutline());
        }
        if (shape2.getStroke() != null) {
            shape.setStroke(shape2.getStroke());
        }
        if ((string = shape2.getMeta("part")) != null) {
            shape.setMeta("part", string);
        }
        if ((shapeArray = shape.getParts()) != null) {
            for (int i = 0; i < shapeArray.length; ++i) {
                this.restoreStyles(shapeArray[i], iterator);
            }
        }
    }

    private boolean isSupportedShape(Shape shape) {
        return shape.isGlyphLike() || this.element != null && ("point".equals(this.element.type) || "interval".equals(this.element.type));
    }

    public static Shape modifySymbol(Shape shape, StyleSpec styleSpec, Element element, VisContext visContext, boolean bl) {
        if (styleSpec != null && styleSpec.symbol != null) {
            SymbolAestheticValueProducer symbolAestheticValueProducer = new SymbolAestheticValueProducer(element, visContext, bl);
            shape = symbolAestheticValueProducer.modify(shape, styleSpec.symbol, null);
        }
        return shape;
    }

    private int findSymbolIndex(String string) {
        for (int i = 0; i < this.symbolNames.length; ++i) {
            String string2 = this.symbolNames[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }
}

