/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.aesthetic;

import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticPalette;
import com.ibm.vis.engine.internal.grammar.aesthetic.AestheticValueProducer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.MappingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisibilityAestheticValueProducer
extends AestheticValueProducer {
    @Override
    protected Object interpolate(Object object, Object object2, double d) {
        if (object == null || object2 == null) {
            return true;
        }
        if (object == object2) {
            return object;
        }
        return object;
    }

    @Override
    public Object getMappingValueSpec(MappingSpec mappingSpec) {
        if (mappingSpec != null && mappingSpec.visible == null) {
            throw new SpecException("Visibility aesthetic should use 'visible' aesthetic value in mapping.", ErrorCode.SPEC_MISSING_PARAMETER, null);
        }
        return mappingSpec == null ? null : mappingSpec.visible;
    }

    @Override
    public Object make(Object object) {
        if (object == null || !BasicFactory.isBoolean(object)) {
            return null;
        }
        return object;
    }

    @Override
    public Shape modify(Shape shape, Object object, String string) {
        if (object == null) {
            return shape;
        }
        if (string != null) {
            String string2 = "'modifies' type attribute is not supported for visibility aesthetic";
            throw new SpecException(string2, ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (BasicFactory.isBoolean(object)) {
            Boolean bl = (Boolean)object;
            shape.setVisible(bl);
        }
        return shape;
    }

    @Override
    public Object getAestheticFromPalette(int n, int n2, AestheticPalette aestheticPalette) {
        return aestheticPalette.getPaletteItem(n);
    }

    @Override
    public Object getDefaultForCategory(int n, int n2, double d) {
        if (n == 0) {
            return true;
        }
        return false;
    }
}

