/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.ShapeIterator;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class CoordinateTransform {
    private Scale[] scales;
    protected boolean isInitialized;

    protected abstract Shape transformShape(Shape var1, Dim var2, Scale[] var3);

    public abstract double[] inverseTransform(double[] var1, Dim var2, Scale[] var3);

    protected abstract double calculateGapSize(double var1, int var3);

    public boolean isTranspose() {
        return false;
    }

    public boolean needsInsideAxes() {
        return false;
    }

    public boolean isStacking() {
        return false;
    }

    public boolean isCluster() {
        return false;
    }

    public boolean isPolar() {
        return false;
    }

    public boolean isProjection() {
        return false;
    }

    public void updateBounds(Dim dim) {
    }

    protected void preProcess(ShapeList shapeList, Dim dim) {
    }

    public void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
    }

    public PreferredSizeSpec getDiameterSpec() {
        return null;
    }

    public boolean getClockwise() {
        return false;
    }

    public void transformShapes(ShapeList shapeList, Dim dim, Scale[] scaleArray) {
        this.transformForIterator(dim, scaleArray, shapeList.elementIterator());
        this.transformForIterator(dim, scaleArray, shapeList.nonElementIterator());
    }

    private void transformForIterator(Dim dim, Scale[] scaleArray, ShapeIterator<Shape> shapeIterator) {
        while (shapeIterator.hasNext()) {
            Object object = shapeIterator.next();
            Shape shape = this.transformShape((Shape)object, dim, scaleArray);
            if (shape != null) {
                shape.addMeta((Shape)object);
                shape.setNeedsConsistentLabels(((Shape)object).getNeedsConsistentLabels());
                shape.setVisible(((Shape)object).isVisible());
            }
            shapeIterator.replace(shape);
        }
    }

    public boolean isInversible() {
        return true;
    }

    public final Scale[] getScales() {
        return this.scales;
    }

    protected void setVisSize(Dim dim) {
    }

    public boolean appliesToAxisTickOrLabel() {
        return false;
    }

    public void setup(Scale[] scaleArray, Dim dim) {
    }

    public void setScales(Scale[] scaleArray) {
        this.scales = scaleArray;
    }

    public void cleanup() {
    }

    public Rect modifyArea(List<Axis> list, Rect rect) {
        return rect;
    }
}

