/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.PolarTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.ProjectionTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.TransposeTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.StackTransform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.PolarParametersSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.ProjectionParametersSpec;
import com.ibm.vis.spec.internal.TransformSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CoordinateTransformFactory {
    public static CoordinateTransform make(TransformSpec transformSpec, DimensionSpec[] dimensionSpecArray, int n, Vis vis) {
        assert (transformSpec != null);
        if ("cluster".equals(transformSpec.type)) {
            if (dimensionSpecArray == null) {
                throw new SpecException("Can't specify cluster transform when dimensions are empty.", ErrorCode.SPEC_IS_EMPTY, null);
            }
            return new ClusterTransform(dimensionSpecArray, vis);
        }
        if ("stack".equals(transformSpec.type)) {
            return new StackTransform();
        }
        if ("projection".equals(transformSpec.type)) {
            if (dimensionSpecArray == null) {
                throw new SpecException("Can't specify projection transform when dimensions are empty.", ErrorCode.SPEC_IS_EMPTY, null);
            }
            if (transformSpec.projectionParameters != null) {
                ProjectionParametersSpec projectionParametersSpec = transformSpec.projectionParameters;
                return new ProjectionTransform(projectionParametersSpec);
            }
            return new ProjectionTransform(null);
        }
        if ("transpose".equals(transformSpec.type)) {
            return new TransposeTransform();
        }
        if ("polar".equals(transformSpec.type)) {
            Number number = null;
            boolean bl = true;
            PreferredSizeSpec preferredSizeSpec = null;
            if (transformSpec.polarParameters != null) {
                PolarParametersSpec polarParametersSpec = transformSpec.polarParameters;
                number = polarParametersSpec.startAngle;
                bl = polarParametersSpec.CCW == false;
                preferredSizeSpec = polarParametersSpec.diameter;
            }
            return new PolarTransform(number, n, bl, preferredSizeSpec);
        }
        throw new IllegalArgumentException("Unknown type: " + transformSpec.type);
    }
}

