/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.facet.Faceting;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransformFactory;
import com.ibm.vis.engine.internal.grammar.coordinate.PolarTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.TransposeTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterTransform;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.AxisComparator;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleBuilder;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.grammar.values.ValueProviderFactory;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class Coordinates {
    public static final String Y = "y";
    public static final String X = "x";
    public static final String CX = "cx";
    public static final String CY = "cy";
    public static final String TRANSFORMS = "transforms";
    public static final String TRANSFORM = "transform";
    public static final String DX = "dx";
    public static final String DY = "dy";
    public static final String COORDINATES = "coordinates";
    public final Scale[] scales;
    public Axis[] axes;
    private final CoordinateTransform[] transforms;
    public final boolean insideAxes;
    public final Vis vis;
    public final VisContext visContext;
    public final CoordinatesSpec spec;
    public final String[][] coordinateFieldIDs;
    private boolean[] scalesFromSpecsWithoutUnits;
    private int nextElementShapeIndex;

    public static Coordinates createCoordinates(Vis vis, CoordinatesSpec coordinatesSpec) {
        return new Coordinates(vis, coordinatesSpec, null, null, false, null);
    }

    private Coordinates(Vis vis, CoordinatesSpec coordinatesSpec, Scale[] scaleArray, CoordinateTransform[] coordinateTransformArray, boolean bl, String[][] stringArray) {
        this.vis = vis;
        this.visContext = vis.getVisContext();
        this.spec = coordinatesSpec == null ? new CoordinatesSpec() : coordinatesSpec;
        if (scaleArray != null) {
            this.scales = scaleArray;
            this.transforms = coordinateTransformArray;
            this.insideAxes = bl;
            this.coordinateFieldIDs = stringArray;
        } else {
            int n = this.spec.dimensions == null ? 0 : this.spec.dimensions.length;
            this.scales = new Scale[n];
            this.coordinateFieldIDs = new String[n][];
            if (this.spec.transforms == null) {
                this.transforms = new CoordinateTransform[0];
                this.insideAxes = false;
            } else {
                boolean bl2 = false;
                this.transforms = new CoordinateTransform[this.spec.transforms.length];
                for (int i = 0; i < this.transforms.length; ++i) {
                    this.transforms[i] = CoordinateTransformFactory.make(this.spec.transforms[i], this.spec.dimensions, this.scales.length, vis);
                    if (!this.transforms[i].needsInsideAxes()) continue;
                    bl2 = true;
                }
                this.insideAxes = bl2;
            }
            this.prepareScaleAndAxes();
        }
    }

    public Coordinates removeStackTransform() {
        if (!this.containsStacking()) {
            return this;
        }
        CoordinateTransform[] coordinateTransformArray = new CoordinateTransform[this.transforms.length - 1];
        int n = 0;
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (coordinateTransform.isStacking()) continue;
            coordinateTransformArray[n++] = coordinateTransform;
        }
        Coordinates coordinates = new Coordinates(this.vis, this.spec, this.scales, coordinateTransformArray, this.insideAxes, this.coordinateFieldIDs);
        coordinates.axes = this.axes;
        coordinates.scalesFromSpecsWithoutUnits = this.scalesFromSpecsWithoutUnits;
        return coordinates;
    }

    private void prepareScaleAndAxes() {
        int n;
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        for (n = 0; n < this.scales.length; ++n) {
            DimensionSpec dimensionSpec = this.spec.dimensions[n];
            ScaleSpec scaleSpec = dimensionSpec.scale;
            if (scaleSpec == null) {
                this.scales[n] = null;
            } else {
                this.setScaleSpanWithoutUnits(scaleSpec, n);
                this.scales[n] = ScaleBuilder.createFromSpec(scaleSpec, this.isScreenYAxis(n), scaleSpec.local, null, null, this.vis, n, null);
            }
            if (this.spec.dimensions[n].axis == null) continue;
            AxisSpec[] axisSpecArray = this.spec.dimensions[n].axis;
            if (BasicFactory.isObject(axisSpecArray) && !BasicFactory.isArray(axisSpecArray)) {
                arrayList.add(new Axis(n, this, (AxisSpec)axisSpecArray, null, false));
                continue;
            }
            int n2 = this.spec.dimensions[n].axis.length;
            if (n2 <= 0) continue;
            arrayList.add(new Axis(n, this, this.spec.dimensions[n].axis[0], null, false));
            if (n2 != 2) continue;
            arrayList.add(new Axis(n, this, this.spec.dimensions[n].axis[1], null, true));
        }
        this.axes = new Axis[arrayList.size()];
        for (n = 0; n < this.axes.length; ++n) {
            this.axes[n] = (Axis)arrayList.get(n);
        }
    }

    private void setScaleSpanWithoutUnits(ScaleSpec scaleSpec, int n) {
        SpanSpec[] spanSpecArray = scaleSpec.spans;
        if (spanSpecArray != null) {
            for (SpanSpec spanSpec : spanSpecArray) {
                if (spanSpec.unit != null) continue;
                if (this.scalesFromSpecsWithoutUnits == null) {
                    this.scalesFromSpecsWithoutUnits = new boolean[this.scales.length];
                }
                this.scalesFromSpecsWithoutUnits[n] = true;
                return;
            }
        }
    }

    public void isOverlappingTick() {
        boolean bl;
        if (this.axes.length > 2) {
            bl = this.axes[1].getAxisSpec().boxStyle != null && !this.axes[0].getScale().isCategorical() && !this.axes[1].getScale().isCategorical();
            for (int i = 0; i < this.axes.length; ++i) {
                bl = this.axes[1].getAxisSpec().boxStyle != null && !this.axes[i].getScale().isCategorical() && !bl;
                this.axes[i].setisOverlappingTick(bl);
            }
        }
        if (this.axes.length <= 2 && this.axes.length > 1) {
            bl = this.axes[1].getAxisSpec().boxStyle != null && !this.axes[0].getScale().isCategorical() && !this.axes[1].getScale().isCategorical();
            this.axes[0].setisOverlappingTick(bl);
            this.axes[1].setisOverlappingTick(bl);
        } else {
            bl = false;
        }
    }

    public Dim getDefaultSize(Dim dim, ValueProvider[] valueProviderArray, String string) {
        Dim dim2 = new Dim(dim.getWidth(), dim.getHeight());
        if (this.scales.length > 1) {
            int n = valueProviderArray.length > 1 ? valueProviderArray.length - this.scales.length : 0;
            ValueProvider valueProvider = valueProviderArray.length > 1 + n ? valueProviderArray[1 + n] : ValueProviderFactory.DEFAULT;
            double d = this.scales[1].getDefaultElementSize(dim.getWidth(), valueProvider, string);
            if (string.equals("interval") && valueProvider.getGranularity() == null) {
                double d2 = this.scales[1].getMininalDistance(dim.getWidth(), valueProvider);
                double d3 = 5.0;
                d2 = Math.max(d2, d3);
                dim2.setWidth(Math.min(d, d2));
            } else {
                dim2.setWidth(d);
            }
        }
        if (this.scales.length > 0) {
            dim2.setHeight(this.scales[0].getDefaultElementSize(dim.getHeight(), valueProviderArray.length > 0 ? valueProviderArray[0] : ValueProviderFactory.DEFAULT, string));
            if (this.transposesAxes()) {
                dim2.setHeight(this.scales[0].getDefaultElementSize(dim.getWidth(), valueProviderArray.length > 0 ? valueProviderArray[0] : ValueProviderFactory.DEFAULT, string));
            }
        }
        this.isOverlappingTick();
        return dim2;
    }

    public Double getCoordinatePositions(double d, int n) {
        return this.scales[n].toZeroOne(d, null, null);
    }

    public Position getPosition(Row row, ValueProvider[] valueProviderArray) {
        int n = valueProviderArray.length - this.scales.length;
        if (n < 0) {
            return Position.NO_COORDS;
        }
        Position position = new Position(this.scales.length, n, 0);
        int n2 = 0;
        for (int i = 0; i < this.scales.length; ++i) {
            double d = valueProviderArray[n2].getNumber(row);
            position.base[i] = valueProviderArray[n2].toZeroOne(d, this.scales[i]);
            position.updateSuggestedSize(valueProviderArray[n2], this.scales[i], d, i);
            if (!Double.isNaN(d)) {
                Field field;
                position.index[i] = d;
                position.valueIsPercentage[i] = ValueProvider.ProviderType.PERCENTAGE.equals((Object)valueProviderArray[n2].getType());
                if (valueProviderArray[n2] != null && (field = valueProviderArray[n2].getBaseField()) != null) {
                    position.fields[i] = field;
                }
                position.setSpan(i, valueProviderArray[n2].getSpan());
            }
            ++n2;
            if (i >= n) continue;
            double d2 = valueProviderArray[n2].getNumber(row);
            position.extra[i] = valueProviderArray[n2].toZeroOne(d2, this.scales[i]);
            ++n2;
        }
        return position;
    }

    private boolean isScreenYAxis(int n) {
        return this.transposesAxes() ? n != 0 : n == 0;
    }

    public void prepareForElements(Element[] elementArray, Faceting faceting) {
        for (int i = 0; i < this.scales.length; ++i) {
            Object object;
            Serializable serializable;
            Object object2;
            boolean bl;
            ArrayList<Unit> arrayList;
            ArrayList<Field> arrayList2 = this.getFieldsInScale(elementArray, i);
            ArrayList<Unit> arrayList3 = this.getFieldUnits(arrayList2);
            DimensionSpec object4 = this.spec.dimensions[i];
            ScaleSpec scaleSpec = object4.scale;
            GrammarSpec grammarSpec = null;
            if (elementArray.length > 0) {
                grammarSpec = elementArray[0].grammar.gSpec;
            }
            if (this.scalesFromSpecsWithoutUnits != null && this.scalesFromSpecsWithoutUnits[i]) {
                arrayList = this.getSpanUnits(arrayList2);
                this.scales[i] = ScaleBuilder.createFromSpec(scaleSpec, this.isScreenYAxis(i), scaleSpec.local, arrayList2, arrayList, this.vis, i, this.matchSpantoField(grammarSpec));
            } else {
                ScaleBuilder.setFieldToScaleSpans(this.scales[i], this.vis, arrayList2, this.matchSpantoField(grammarSpec));
            }
            Cloneable cloneable = arrayList = i == 0 && this.containsStacking() ? Coordinates.makeStackRange(elementArray) : null;
            if (this.scales[i] != null) {
                if (this.scales[i].isLocalUndefined()) {
                    bl = this.allCategorical(arrayList3);
                    this.scales[i].localScale = bl;
                } else {
                    if (faceting != null && !faceting.isChartInChart() && faceting.isSharedAxis(i) && this.scales[i].localScale.booleanValue()) {
                        throw new SpecException("You cannot share axes which are local (they only show the data used in the individual panel). Either remove the shared flag for the axis or make the scale it is based on non-local", ErrorCode.SPEC_INVALID_VALUE, null);
                    }
                    bl = this.scales[i].localScale;
                }
            } else {
                bl = this.allCategorical(arrayList3);
            }
            if (arrayList != null) {
                bl = false;
            }
            Scale scale = new Scale(null, this.vis.getSize());
            ScaleBuilder scaleBuilder = ScaleBuilder.makeForMany(scale, arrayList2, bl, this.visContext);
            scaleBuilder.reverseCategoricalScales = this.isScreenYAxis(i);
            for (Unit unit : arrayList3) {
                Object object3;
                Object object5;
                object2 = Range.EMPTY;
                serializable = this.getFieldsForUnit(arrayList2, unit);
                Object object6 = ((ArrayList)serializable).iterator();
                while (object6.hasNext()) {
                    object5 = object6.next();
                    if (arrayList == null) continue;
                    object = (Range)((HashMap)((Object)arrayList)).get(((Field)object5).label);
                    if (object != null) {
                        object2 = ((Range)object2).createUnion((Range)object);
                        continue;
                    }
                    if (((Field)object5).range == null) continue;
                    object2 = ((Range)object2).createUnion(((Field)object5).range);
                }
                if (((Range)object2).equals(Range.EMPTY)) {
                    object2 = null;
                }
                object6 = ((ArrayList)serializable).get(0);
                object5 = null;
                if (arrayList != null) {
                    object5 = ((Field)object6).label;
                }
                object = ((Field)object6).getSpecifiedFormatter();
                if (((Field)object6).getLocalFormatter() != null && ((Field)object6).getLocalFormatterType() == Field.LocalFormatterType.POSITION) {
                    object = ((Field)object6).getLocalFormatter();
                }
                Double d = ((Field)object6).granularity;
                boolean bl2 = this.getSpanSpecIgnoreZero(i, scale.spans.size());
                if (unit.measure.categorical) {
                    String[] stringArray = Coordinates.getMergedCategories((List<Field>)((Object)serializable));
                    object3 = this.makeFitInformation(elementArray, i, this.allCategorical(arrayList3), bl2);
                    scaleBuilder.addCategoricalSpan(unit, stringArray, (RAVEFormatter)object, (ScaleFitInfo)object3);
                    continue;
                }
                boolean bl3 = this.scales[i] != null && this.scales[i].localScale != false;
                object3 = this.getRange(unit, (ArrayList<Field>)serializable, (Range)object2, bl3, bl2);
                ScaleFitInfo scaleFitInfo = this.makeFitInformation(elementArray, i, this.allCategorical(arrayList3), bl2);
                scaleBuilder.addNumericSpan(unit, (Range)object3, (RAVEFormatter)object, scaleFitInfo, d, i, (String)object5);
            }
            scale.defineSpanOutputRanges();
            if (this.scales[i] != null) {
                this.scales[i].checkSpansUnitMatching(scale);
                this.setInputDomainRangeFromFieldRange(elementArray, i);
                this.scales[i].useValuesFrom(scale);
                this.scales[i].validateOutRange();
                if (!this.scales[i].isOutRangesDefined()) {
                    this.scales[i].defineSpanOutputRanges();
                }
            } else {
                this.scales[i] = scale;
            }
            this.coordinateFieldIDs[i] = this.getFieldsArray(arrayList2);
            if (this.scales[i].localScale == null) {
                this.scales[i].localScale = bl;
            }
            List<Number> list = this.getFixedValuesIncludedInRange(elementArray, i);
            Scale scale2 = this.scales[i];
            object2 = list.iterator();
            while (object2.hasNext()) {
                serializable = (Number)object2.next();
                double d = ((Number)serializable).doubleValue();
                if (scale2.spans.isEmpty()) {
                    object = this.makeFitInformation(elementArray, i, this.allCategorical(arrayList3), false);
                    scaleBuilder.addNumericSpan(Unit.RATIO, new Range(d, d), null, (ScaleFitInfo)object, null, i, null);
                    continue;
                }
                scale2.includeValue(d);
            }
            if (this.scales[i].spans.size() <= 1) continue;
            this.setSpansToAxis(i);
        }
        for (Axis axis : this.axes) {
            axis.giveSizeInfoToScale();
        }
    }

    private boolean getSpanSpecIgnoreZero(int n, int n2) {
        if (this.spec == null || this.spec.dimensions == null || n >= this.spec.dimensions.length) {
            return false;
        }
        ScaleSpec scaleSpec = this.spec.dimensions[n].scale;
        if (scaleSpec == null || scaleSpec.spans == null || n2 >= scaleSpec.spans.length) {
            return false;
        }
        SpanSpec spanSpec = scaleSpec.spans[n2];
        return spanSpec != null && spanSpec.ignoreZero != null && spanSpec.ignoreZero != false;
    }

    protected HashMap<Integer, String> matchSpantoField(GrammarSpec grammarSpec) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (grammarSpec != null && grammarSpec.elements != null) {
            for (int i = 0; i < grammarSpec.elements.length; ++i) {
                if (grammarSpec.elements[i].position == null) continue;
                for (int j = 0; j < grammarSpec.elements[i].position.length; ++j) {
                    if (grammarSpec.elements[i].position[j] == null || grammarSpec.elements[i].position[j].field == null || grammarSpec.elements[i].position[j].span == null || hashMap.containsKey(grammarSpec.elements[i].position[j].span.intValue())) continue;
                    hashMap.put(grammarSpec.elements[i].position[j].span.intValue(), grammarSpec.elements[i].position[j].field.$ref);
                }
            }
        }
        return hashMap;
    }

    private void setInputDomainRangeFromFieldRange(Element[] elementArray, int n) {
        for (Element element : elementArray) {
            element.setInputDomainRange(this.scales[n]);
        }
    }

    private void setSpansToAxis(int n) {
        int n2;
        Axis axis;
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        for (int i = 0; i < this.axes.length; ++i) {
            arrayList.add(this.axes[i]);
        }
        ArrayList<ArrayList<ScaleSpan>> arrayList2 = this.scales[n].makeSpanGroups();
        if (this.spec.dimensions[n].axis != null) {
            Axis[] axisArray = this.getAxisForScale(n);
            if (axisArray.length == 1) {
                axisArray[0].setSpans(arrayList2.get(0));
                if (arrayList2.get(1).size() > 0) {
                    axis = new Axis(n, this, axisArray[0].getAxisSpec(), arrayList2.get(1), true);
                    arrayList.add(axis);
                }
            } else if (axisArray.length == 2) {
                if (this.isAxesOnSameLocation(axisArray[0], axisArray[1])) {
                    throw new SpecException("Given spec results in two axes drawn at same side", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                axisArray[0].setSpans(arrayList2.get(0));
                if (arrayList2.get(1).size() > 0) {
                    axisArray[1].setSpans(arrayList2.get(1));
                } else {
                    axisArray[1].setSpans(arrayList2.get(0));
                }
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            axis = (Axis)arrayList.get(n2);
            if (axis.getSpans() == null) continue;
            for (int i = 0; i < axis.getSpans().size(); ++i) {
                ScaleSpan scaleSpan = axis.getSpans().get(i);
                if (scaleSpan == null || scaleSpan.getInputRange() == null || scaleSpan.getInputRange().isComplete()) continue;
                arrayList.remove(n2);
            }
        }
        this.axes = new Axis[arrayList.size()];
        for (n2 = 0; n2 < this.axes.length; ++n2) {
            this.axes[n2] = (Axis)arrayList.get(n2);
        }
    }

    private boolean isAxesOnSameLocation(Axis axis, Axis axis2) {
        boolean bl;
        boolean bl2 = axis.isDrawOppositeSide();
        boolean bl3 = bl = !axis2.isDrawOppositeSide();
        return bl2 && !bl || !bl2 && bl;
    }

    private Axis[] getAxisForScale(int n) {
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        for (Axis axis : this.axes) {
            if (axis.getScaleIndex() != n) continue;
            arrayList.add(axis);
        }
        return arrayList.toArray(new Axis[arrayList.size()]);
    }

    private ArrayList<Unit> getSpanUnits(ArrayList<Field> arrayList) {
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>();
        for (Field field : arrayList) {
            arrayList2.add(field.unit);
        }
        return arrayList2;
    }

    private List<Number> getFixedValuesIncludedInRange(Element[] elementArray, int n) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Element element : elementArray) {
            arrayList.addAll(element.getFixedValues(n));
        }
        return arrayList;
    }

    private ScaleFitInfo makeFitInformation(Element[] elementArray, int n, boolean bl, boolean bl2) {
        boolean bl3 = !bl && n == this.scales.length - 1 && this.containsPolar();
        boolean bl4 = n == 0 && this.containsElementDesiringZero(elementArray);
        ScaleFitInfo scaleFitInfo = new ScaleFitInfo(!bl3, bl4, bl2, n);
        boolean bl5 = this.isScreenYAxis(n);
        for (Element element : elementArray) {
            element.addSpaceRequirements(scaleFitInfo, bl5);
        }
        return scaleFitInfo;
    }

    private boolean allCategorical(ArrayList<Unit> arrayList) {
        for (Unit unit : arrayList) {
            if (unit.measure.categorical) continue;
            return false;
        }
        return true;
    }

    private Range getRange(Unit unit, ArrayList<Field> arrayList, Range range, boolean bl, boolean bl2) {
        if (range != null && (this.containsPolar() || this.containsStacking() || bl)) {
            return range;
        }
        Range range2 = range;
        if (range2 == null) {
            range2 = Range.EMPTY;
        }
        for (Field field : arrayList) {
            Range range3 = bl2 ? field.getRangeIgnoringZeros() : field.range;
            if (!range3.isComplete()) continue;
            range2 = range2.createUnion(UnitConverter.convertRange(range3, field.unit, unit));
        }
        return range2;
    }

    private static String[] getMergedCategories(List<Field> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get((int)0).categories;
        }
        HashSet<Field> hashSet = new HashSet<Field>();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Field field : list) {
            if (hashSet.contains(field)) continue;
            hashSet.add(field);
            if (field.categories == null) continue;
            for (String string : field.categories) {
                if (hashSet2.contains(string)) continue;
                arrayList.add(string);
            }
            for (String string : field.categories) {
                hashSet2.add(string);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private ArrayList<Field> getFieldsForUnit(ArrayList<Field> arrayList, Unit unit) {
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        for (Field field : arrayList) {
            if (this.findMatchingUnit(field.unit, arrayList) != unit) continue;
            arrayList2.add(field);
        }
        return arrayList2;
    }

    private ArrayList<Unit> getFieldUnits(ArrayList<Field> arrayList) {
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>();
        for (Field field : arrayList) {
            Unit unit = this.findMatchingUnit(field.unit, arrayList);
            if (arrayList2.contains(unit)) continue;
            arrayList2.add(unit);
        }
        return arrayList2;
    }

    private String[] getFieldsArray(ArrayList<Field> arrayList) {
        if (arrayList.size() == 0) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Field field : arrayList) {
            linkedHashSet.add(field.id);
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private boolean containsElementDesiringZero(Element[] elementArray) {
        for (Element element : elementArray) {
            if (!element.desiresZero(this)) continue;
            return true;
        }
        return false;
    }

    public Shape modifyShape(Shape shape, Dim dim) {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            shape = coordinateTransform.transformShape(shape, dim, this.scales);
        }
        return shape;
    }

    public Shape modifyAxisTickOrLabel(Shape shape, Dim dim, int n, int n2) {
        ShapeList shapeList = new ShapeList();
        Shape shape2 = shape;
        boolean bl = false;
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.appliesToAxisTickOrLabel() || !(coordinateTransform instanceof TransposeTransform)) continue;
            bl = true;
        }
        for (CoordinateTransform coordinateTransform : this.transforms) {
            Object object;
            if (!coordinateTransform.appliesToAxisTickOrLabel()) continue;
            shapeList.addElementShape(shape);
            boolean bl2 = false;
            boolean bl3 = false;
            Rect rect = null;
            if (bl && coordinateTransform instanceof ClusterTransform && shape.getGeom() != null && n > 0 && (object = this.scales[n].getSimpleScaleSpan()) instanceof CategoricalScaleSpan) {
                bl2 = true;
                rect = (Rect)shape.getGeom().copy();
                if (((CategoricalScaleSpan)object).getCategoryCount() > n2 || this.vis.getVisContext().isViewportPan()) {
                    bl3 = true;
                }
            }
            shape.setID(shape.getID() + this.nextElementShapeIndex++);
            coordinateTransform.preProcess(shapeList, dim);
            coordinateTransform.transformShape(shape, dim, this.scales);
            if (rect != null && bl2) {
                object = (Rect)shape.getGeom();
                if (bl3 || ((Rect)object).getWidth() < 5.0) {
                    Point point = ((Rect)object).getCenter();
                    double d = rect.getWidth();
                    double d2 = rect.getHeight();
                    ((Rect)object).setX(point.getX() - d / 2.0);
                    ((Rect)object).setY(point.getY() - d2 / 2.0);
                    ((Rect)object).setWidth(d);
                    ((Rect)object).setHeight(d2);
                }
            }
            if (shapeList.getAllShapes().size() != 0) continue;
            shape2 = null;
        }
        return shape2;
    }

    public void modifyShapes(ShapeList shapeList, Dim dim) {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            coordinateTransform.setup(this.scales, dim);
            coordinateTransform.preProcess(shapeList, dim);
            coordinateTransform.initialize();
            coordinateTransform.transformShapes(shapeList, dim, this.scales);
        }
    }

    public double getAvailableWidth(double d, int n) {
        double d2 = 0.0;
        for (CoordinateTransform coordinateTransform : this.transforms) {
            d2 = coordinateTransform.calculateGapSize(d, n - 1);
        }
        return d - d2;
    }

    public void initializeGeometryForBounds(ScaleGeometry scaleGeometry, Dim dim) {
        if (this.insideAxes) {
            double d = Math.min(dim.getHeight(), dim.getWidth()) / 2.0;
            scaleGeometry.setBounds(Math.PI * 2 * d, d);
        } else {
            scaleGeometry.setBounds(dim.getWidth(), dim.getHeight());
        }
    }

    public boolean transposesAxes() {
        boolean bl = false;
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isTranspose()) continue;
            bl = !bl;
        }
        return bl;
    }

    public boolean containsPolar() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isPolar()) continue;
            return true;
        }
        return false;
    }

    public boolean containsCategorical() {
        for (int i = 0; i < this.scales.length; ++i) {
            if (!this.scales[i].isCategorical()) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Field> getFieldsInScale(Element[] elementArray, int n) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Element element : elementArray) {
            arrayList.addAll(element.getFieldsForDimension(n));
        }
        return arrayList;
    }

    protected Unit findMatchingUnit(Unit unit, ArrayList<Field> arrayList) {
        if (!unit.measure.isGeneric()) {
            return unit;
        }
        for (Field field : arrayList) {
            if (field.unit == unit) continue;
            if (unit.measure.categorical) {
                String string = field.unit.name;
                if (!string.equals(unit.name) || !field.unit.measure.categorical) continue;
                return field.unit;
            }
            if (!field.unit.measure.matches(unit.measure)) continue;
            if (unit.isCustomUnit()) {
                if (!field.unit.isCustomUnit() || !field.unit.name.equals(unit.name)) continue;
                return field.unit;
            }
            return field.unit;
        }
        return unit;
    }

    public int getDrawnPosition(int n) {
        if (n > 1) {
            n = 1;
        }
        if (this.transposesAxes() && n < 2) {
            return 1 - n;
        }
        return n;
    }

    public double[] getDataValuesFor(double d, double d2, Dim dim) {
        double[] dArray = new double[]{d2, d};
        for (int i = this.transforms.length - 1; i > -1; --i) {
            if (!this.transforms[i].isInversible()) continue;
            dArray = this.transforms[i].inverseTransform(dArray, dim, this.scales);
        }
        dArray[0] = dim.getHeight() - dArray[0];
        double[] dArray2 = new double[this.scales.length];
        for (int i = 0; i < this.scales.length && i < 2; ++i) {
            double d3 = i > 1 ? 1.0 : (i == 0 ? dim.getHeight() : dim.getWidth());
            Double d4 = this.scales[i].dimensionValueToDataValue(dArray[i], d3);
            if (d4 == null) {
                return null;
            }
            dArray2[i] = d4;
        }
        return dArray2;
    }

    public Axis getAxisForDimension(int n) {
        for (Axis axis : this.axes) {
            if (axis.getScaleIndex() != n) continue;
            return axis;
        }
        return null;
    }

    public boolean containsCluster() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isCluster()) continue;
            return true;
        }
        return false;
    }

    public boolean containsProjection() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isProjection()) continue;
            return true;
        }
        return false;
    }

    public boolean containsTranspose() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isTranspose()) continue;
            return true;
        }
        return false;
    }

    public boolean containsStacking() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            if (!coordinateTransform.isStacking()) continue;
            return true;
        }
        return false;
    }

    public double[] get2DScaleRanges() {
        double d = this.scales.length < 1 ? 0.0 : this.scales[0].dimensionToDataValueInterpolate(0.0, 1.0);
        double d2 = this.scales.length < 1 ? 1.0 : this.scales[0].dimensionToDataValueInterpolate(1.0, 1.0);
        double d3 = this.scales.length < 2 ? 0.0 : this.scales[1].dimensionToDataValueInterpolate(0.0, 1.0);
        double d4 = this.scales.length < 2 ? 1.0 : this.scales[1].dimensionToDataValueInterpolate(1.0, 1.0);
        return new double[]{d3, d4, d, d2};
    }

    public double getDistancefromBaseInYDirection(Dim dim) {
        double d = this.containsPolar() ? Math.min(dim.getWidth(), dim.getHeight()) : (this.transposesAxes() ? dim.getWidth() : dim.getHeight());
        return this.containsPolar() ? d / 2.0 : d;
    }

    public Point getOffsetInFreeDirection(Shape shape, double d, Dim dim) {
        Point point;
        double d2;
        Point point2 = this.getCoordinateCenter(dim);
        if (this.containsPolar()) {
            d2 = d;
            point = shape.getCenter();
        } else {
            d2 = Math.abs(d);
            Shape shape2 = ShapeFactory2.CreateCircle(point2.getX(), point2.getY() - d, 1.0);
            this.modifyShape(shape2, dim);
            point = shape2.getCenter();
        }
        double d3 = point.getX() - point2.getX();
        double d4 = point.getY() - point2.getY();
        double d5 = point2.distance(point);
        d3 = MathUtil.r3(d3 / d5).doubleValue();
        d4 = MathUtil.r3(d4 / d5).doubleValue();
        double d6 = d2 * d3;
        double d7 = d2 * d4;
        return new Point(d6, d7);
    }

    public Point getCoordinateCenter(Dim dim) {
        Shape shape = ShapeFactory2.CreateCircle(0.0, 0.0, 0.0);
        this.modifyShape(shape, dim);
        Point point = new Point(shape.getX(), shape.getY());
        point.setY(dim.getHeight() - point.getY());
        return point;
    }

    public boolean isStraightPolarGridLine() {
        return this.isValidRadar() && this.scales[1].isCategorical() && this.isDefinedSegmentedInSpec();
    }

    public boolean isValidRadar() {
        return this.containsPolar() && this.scales.length == 2 && this.axes.length == 2;
    }

    boolean isDefinedSegmentedInSpec() {
        AxisSpec axisSpec = this.getAxisForDimension(0).getAxisSpec();
        Boolean bl = axisSpec.segmented;
        return bl;
    }

    public boolean isPolygonal(String string) {
        return string != null && string.endsWith("Coords") && this.isStraightPolarGridLine();
    }

    public PolarTransform getPolarTransform() {
        for (int i = 0; i < this.transforms.length; ++i) {
            if (!this.transforms[i].isPolar()) continue;
            return (PolarTransform)this.transforms[i];
        }
        return null;
    }

    public boolean isBoundaryDrawn() {
        StyleSpec styleSpec = this.spec.style;
        return styleSpec != null && (styleSpec.stroke != null || styleSpec.outline != null);
    }

    public void setVisSizeForTransform(Dim dim) {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            coordinateTransform.setVisSize(dim);
        }
    }

    public static HashMap<String, Range> makeStackRange(Element[] elementArray) {
        HashMap<String, Range> hashMap = new HashMap<String, Range>();
        for (Element element : elementArray) {
            element.makeStackRange(hashMap);
        }
        return hashMap;
    }

    public Rect getLayoutBounds(Dim dim) {
        if (this.scales != null && this.scales.length > 0 && this.scales[0].spans != null) {
            if (!(this.scales[0].spans.size() != 1 || this.scales[0].spans.get(0).getTickUnit() != null && this.scales[0].spans.get((int)0).getTickUnit().measure.categorical)) {
                Range range = this.scales[0].spans.get(0).getOutRange();
                double d = range.getMin() * dim.getWidth();
                double d2 = range.getMin() * dim.getHeight();
                double d3 = range.getRange() * dim.getWidth();
                double d4 = range.getRange() * dim.getHeight();
                return new Rect(d, d2, d3, d4);
            }
            if (this.scales[0].spans.size() >= 1) {
                throw new SpecException("Only one numeric span is supported for layouts. \n Please specify numeric span correctly.", ErrorCode.SPEC_INVALID_VALUE, null);
            }
        }
        return new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
    }

    public void cleanupTransforms() {
        for (CoordinateTransform coordinateTransform : this.transforms) {
            coordinateTransform.cleanup();
        }
    }

    public final CoordinateTransform[] getTransforms() {
        return this.transforms;
    }

    public boolean needsToExtendChartToIntersectTheAxisZeroPoint() {
        return this.scales[0].isCategorical();
    }

    public boolean isInViewport(int n, int n2, Rect rect) {
        return rect.containsPt(n, n2);
    }

    double[] normalizedInverse(int n, int n2, Rect rect) {
        double[] dArray = new double[]{(double)n2 - rect.getY(), (double)n - rect.getX()};
        Dim dim = rect.getExtent();
        for (int i = this.transforms.length - 1; i > -1; --i) {
            if (!this.transforms[i].isInversible()) continue;
            dArray = this.transforms[i].inverseTransform(dArray, dim, this.scales);
        }
        if (this.containsPolar()) {
            double d = dArray[1];
            dArray[1] = dArray[0];
            dArray[0] = d;
        }
        dArray[0] = (rect.getHeight() - dArray[0]) / rect.getHeight();
        dArray[1] = dArray[1] / rect.getWidth();
        return dArray;
    }

    public double[] screenToCoordinates(int n, int n2, Rect rect) {
        double[] dArray = new double[this.scales.length];
        double[] dArray2 = this.normalizedInverse(n, n2, rect);
        boolean bl = this.containsCategorical();
        boolean bl2 = this.transposesAxes();
        for (int i = 0; i < this.scales.length; ++i) {
            dArray[i] = this.scales[i].getOutRange().toZeroOne(dArray2[i == 0 ? 0 : 1]);
            if (!bl || !bl2 || i == 0) continue;
            dArray[i] = 1.0 - dArray[i];
        }
        return dArray;
    }

    public void relayoutForNewAxisOutRange() {
        int n;
        for (n = 0; n < this.axes.length; ++n) {
            if (this.axes[n].isAlignWithOtherAxis()) continue;
            this.axes[n].relayoutForNewOutRange();
        }
        for (n = 0; n < this.axes.length; ++n) {
            if (!this.axes[n].isAlignWithOtherAxis()) continue;
            this.axes[n].relayoutForNewOutRange();
        }
    }

    public void relayoutForNewScaleOutRange(ScaleGeometry[] scaleGeometryArray) {
        for (int i = 0; i < this.scales.length; ++i) {
            this.scales[i].initializeForDisplayableExtent(scaleGeometryArray[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Rect layoutAxes(Grammar grammar, Rect rect, Rect rect2, int n, Boolean bl) {
        void var7_9;
        Axis axis;
        int n2;
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        Axis[] object = this.axes;
        int n3 = object.length;
        for (n2 = 0; n2 < n3; ++n2) {
            axis = object[n2];
            if (axis.getDrawPosition() != n) continue;
            arrayList.add(axis);
        }
        BasicFactory.sortList(arrayList, new AxisComparator());
        Rect rect3 = rect.copy();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ((Axis)arrayList.get(n3)).initializeForBounds(rect3);
        }
        n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            Axis axis2 = (Axis)arrayList.get(n3);
            axis = axis2.getAxisAlignedTo();
            if (axis != null) {
                axis.adjustLayout(rect3, rect2);
                n3 -= 2;
            } else {
                --n3;
            }
            axis2.adjustLayout(rect3, rect2);
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            axis = (Axis)arrayList.get(n2);
            axis.modifyInnerCellSize(rect3, bl);
        }
        for (CoordinateTransform coordinateTransform : this.transforms) {
            Rect rect4 = coordinateTransform.modifyArea(arrayList, (Rect)var7_9);
        }
        return var7_9;
    }
}

