/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class InsetTransform
extends CoordinateTransform {
    private final double left;
    private final double right;
    private final double top;
    private final double bottom;

    public InsetTransform(Number number, Number number2, Number number3, Number number4) {
        this.left = number == null ? 0.0 : number.doubleValue();
        this.right = number2 == null ? 0.0 : number2.doubleValue();
        this.top = number3 == null ? 0.0 : number3.doubleValue();
        this.bottom = number4 == null ? 0.0 : number4.doubleValue();
    }

    @Override
    public boolean needsInsideAxes() {
        return true;
    }

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        if (shape.isGlyphLike()) {
            Point point = shape.getCenter();
            double d = point.getX() * (1.0 - this.left - this.right) + this.left * dim.getWidth();
            double d2 = point.getY() * (1.0 - this.bottom - this.top) + this.top * dim.getHeight();
            shape.affine(1.0, d - point.getX(), 1.0, d2 - point.getY(), false);
        } else {
            shape.affine(1.0 - this.left - this.right, this.left * dim.getWidth(), 1.0 - this.bottom - this.top, this.top * dim.getHeight(), false);
        }
        return shape;
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        dArray[0] = (dArray[0] - this.top * dim.getHeight()) / (1.0 - this.bottom - this.top);
        dArray[1] = (dArray[1] - this.left * dim.getWidth()) / (1.0 - this.left - this.right);
        return dArray;
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        return 0.0;
    }
}

