/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.spec.internal.ProjectionMoveSpec;
import com.ibm.vis.spec.internal.ProjectionParametersSpec;

public class MapProjection
extends PointTransform {
    private static final int SIMPLE = 0;
    private static final int MERCATOR = 1;
    private static final int WINKEL = 2;
    private static final int CYLINDRICAL = 3;
    private static final int MILLER = 4;
    private static final int STEREOGRAPHIC = 5;
    private final int type;
    private final double cosLambda0;
    private final double sinLambda0;
    private Dim bounds;
    private Range[] ranges;
    private boolean stretch;
    double fromScX;
    double fromOffX;
    double fromScY;
    double fromOffY;
    double outSc;
    double outOffX;
    double outOffY;
    double midLong;
    double[][] moveFromBounds;
    double[][] moveTranform;
    double[][] moveInverseTransform;

    public MapProjection(ProjectionParametersSpec projectionParametersSpec, double d, double d2, double d3, double d4, Dim dim, Range range) {
        String string = null;
        Number number = null;
        String string2 = null;
        if (projectionParametersSpec != null) {
            string = projectionParametersSpec.name;
            number = projectionParametersSpec.standardLatitude;
            string2 = projectionParametersSpec.method;
            this.computeProjectionMoveTransforms(projectionParametersSpec.move);
        }
        this.type = string == null ? 0 : (string.startsWith("winkel") ? 2 : (string.startsWith("mercator") ? 1 : (string.startsWith("miller") ? 4 : (string.startsWith("cyl") ? 3 : (string.startsWith("stereo") ? 5 : 0)))));
        if (this.type != 0) {
            double d5;
            double d6 = range != null ? range.getMin() : d3;
            double d7 = d5 = range != null ? range.getMax() : d4;
            if (d6 < -90.0) {
                throw new SpecException("Minimum latitude is less than -90 degrees, cannot apply map transformation. Ensure latitude data is within the range [-90, 90] and longitude data within the range [-180, 180].", ErrorCode.DATA_INVALID, null);
            }
            if (d5 > 90.0) {
                throw new SpecException("Maximum latitude is greater than 90 degrees, cannot apply map transformation. Ensure latitude data is within the range [-90, 90] and longitude data within the range [-180, 180].", ErrorCode.DATA_INVALID, null);
            }
        }
        if (string != null && string.startsWith("mercator")) {
            d3 = Math.max(d3, -85.0);
            d4 = Math.min(d4, 85.0);
        }
        this.cosLambda0 = number == null ? (this.type == 5 ? Math.cos((d3 + d4) / 2.0 * Math.PI / 180.0) : Math.cos(0.6981317007977318)) : Math.cos(number.doubleValue() * Math.PI / 180.0);
        this.sinLambda0 = Math.sqrt(1.0 - this.cosLambda0 * this.cosLambda0);
        this.midLong = Math.PI * (d + d2) / 2.0 / 180.0;
        this.stretch = string2 != null && string2.startsWith("stretch");
        this.fromScX = d2 - d;
        this.fromOffX = d;
        this.fromScY = d3 - d4;
        this.fromOffY = d4;
        this.ranges = new Range[]{Range.EMPTY, Range.EMPTY};
        this.addToRange(this.ranges, d, d3, d2, d3);
        this.addToRange(this.ranges, d2, d3, d2, d4);
        this.addToRange(this.ranges, d2, d4, d, d4);
        this.addToRange(this.ranges, d, d4, d, d3);
        this.fixDegenerateRanges();
        this.bounds = new Dim(1.0, 1.0);
        this.updateBounds(dim);
    }

    private void fixDegenerateRanges() {
        double d;
        if (this.ranges[0].getRange() == 0.0) {
            d = this.ranges[0].getMin();
            this.ranges[0].setMin(d - 0.001);
            this.ranges[0].setMax(d + 0.001);
        }
        if (this.ranges[1].getRange() == 0.0) {
            d = this.ranges[1].getMin();
            this.ranges[1].setMin(d - 0.001);
            this.ranges[1].setMax(d + 0.001);
        }
    }

    public void updateBounds(Dim dim) {
        if (dim.getWidth() != this.bounds.getWidth() || dim.getHeight() != this.bounds.getHeight()) {
            this.fromScX = this.fromScX * this.bounds.getWidth() / dim.getWidth();
            this.fromScY = this.fromScY * this.bounds.getHeight() / dim.getHeight();
            double d = dim.getWidth() / this.ranges[0].getRange();
            double d2 = dim.getHeight() / this.ranges[1].getRange();
            this.outSc = this.stretch ? Math.max(d, d2) : Math.min(d, d2);
            this.outOffX = -this.ranges[0].getMin() * this.outSc + dim.getWidth() / 2.0 * (1.0 - this.outSc / d);
            this.outOffY = this.ranges[1].getMax() * this.outSc + dim.getHeight() / 2.0 * (1.0 - this.outSc / d2);
            this.bounds = dim;
        }
    }

    private void computeProjectionMoveTransforms(ProjectionMoveSpec[] projectionMoveSpecArray) {
        if (projectionMoveSpecArray == null || projectionMoveSpecArray.length == 0) {
            return;
        }
        if (this.moveFromBounds == null) {
            this.moveFromBounds = new double[projectionMoveSpecArray.length][4];
            this.moveTranform = new double[projectionMoveSpecArray.length][6];
            this.moveInverseTransform = new double[projectionMoveSpecArray.length][4];
        }
        for (int i = 0; i < projectionMoveSpecArray.length; ++i) {
            if (projectionMoveSpecArray[i].from[2].doubleValue() > projectionMoveSpecArray[i].from[3].doubleValue()) {
                throw new SpecException("ProjectionParameters:Lattitude min is greater than lattitude max", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
            this.moveFromBounds[i][0] = projectionMoveSpecArray[i].from[0].doubleValue();
            this.moveFromBounds[i][1] = projectionMoveSpecArray[i].from[1].doubleValue();
            this.moveFromBounds[i][2] = projectionMoveSpecArray[i].from[2].doubleValue();
            this.moveFromBounds[i][3] = projectionMoveSpecArray[i].from[3].doubleValue();
            double d = MapProjection.computeLongitudeCenter(projectionMoveSpecArray[i].from);
            double d2 = MapProjection.computeLongitudeCenter(projectionMoveSpecArray[i].to);
            double d3 = (projectionMoveSpecArray[i].from[2].doubleValue() + projectionMoveSpecArray[i].from[3].doubleValue()) * 0.5;
            double d4 = (projectionMoveSpecArray[i].to[2].doubleValue() + projectionMoveSpecArray[i].to[3].doubleValue()) * 0.5;
            this.moveTranform[i][0] = MapProjection.computeLongitudeDimension(d, d2);
            this.moveTranform[i][1] = d4 - d3;
            this.moveTranform[i][2] = MapProjection.computeLongitudeDimension(projectionMoveSpecArray[i].to[0].doubleValue(), projectionMoveSpecArray[i].to[1].doubleValue()) / MapProjection.computeLongitudeDimension(projectionMoveSpecArray[i].from[0].doubleValue(), projectionMoveSpecArray[i].from[1].doubleValue());
            this.moveTranform[i][3] = (projectionMoveSpecArray[i].to[3].doubleValue() - projectionMoveSpecArray[i].to[2].doubleValue()) / (projectionMoveSpecArray[i].from[3].doubleValue() - projectionMoveSpecArray[i].from[2].doubleValue());
            this.moveTranform[i][4] = d;
            this.moveTranform[i][5] = d3;
        }
    }

    private static double computeLongitudeCenter(Number[] numberArray) {
        double d;
        double d2;
        double d3 = 0.0;
        d3 = numberArray[0].doubleValue() > 0.0 && numberArray[1].doubleValue() < 0.0 ? ((d2 = 180.0 - numberArray[0].doubleValue()) > (d = numberArray[1].doubleValue() + 180.0) ? numberArray[0].doubleValue() + (d2 + d) * 0.5 : numberArray[1].doubleValue() - (d2 + d) * 0.5) : (numberArray[0].doubleValue() + numberArray[1].doubleValue()) * 0.5;
        return d3;
    }

    private static double computeLongitudeDimension(double d, double d2) {
        double d3 = 0.0;
        d3 = d > 0.0 && d2 < 0.0 ? 180.0 - d + d2 + 180.0 : d2 - d;
        return d3;
    }

    private static boolean isInsideLongitudeRange(double d, double d2, double d3) {
        if (d > 0.0 && d2 < 0.0) {
            return d3 >= d || d3 <= d2;
        }
        return d3 >= d && d3 <= d2;
    }

    protected Point applyProjectionMoveTransform(double d, double d2) {
        Point point = new Point(d, d2);
        if (this.moveFromBounds == null) {
            return point;
        }
        for (int i = 0; i < this.moveFromBounds.length; ++i) {
            if (!(this.moveFromBounds[i][2] <= d2) || !(d2 <= this.moveFromBounds[i][3]) || !MapProjection.isInsideLongitudeRange(this.moveFromBounds[i][0], this.moveFromBounds[i][1], d)) continue;
            point.setX((point.getX() - this.moveTranform[i][4]) * this.moveTranform[i][2] + this.moveTranform[i][4] + this.moveTranform[i][0]);
            point.setY((point.getY() - this.moveTranform[i][5]) * this.moveTranform[i][3] + this.moveTranform[i][5] + this.moveTranform[i][1]);
            if (point.getX() > 180.0) {
                point.setX(point.getX() - 360.0);
                break;
            }
            if (!(point.getX() < -180.0)) break;
            point.setX(360.0 + point.getX());
            break;
        }
        return point;
    }

    protected double[][] getProjectionMoveFromBounds() {
        return this.moveFromBounds;
    }

    protected double[][] getProjectionMoveTransform() {
        return this.moveTranform;
    }

    protected double[][] getProjectionMoveInverseTransform() {
        return this.moveInverseTransform;
    }

    private void addToRange(Range[] rangeArray, double d, double d2, double d3, double d4) {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Point point = this.t(d + (d3 - d) * (double)i / (double)n, d2 + (d4 - d2) * (double)i / (double)n);
            if (point == null) continue;
            rangeArray[0] = rangeArray[0].unionValue(point.getX());
            rangeArray[1] = rangeArray[1].unionValue(point.getY());
        }
    }

    @Override
    public Point transform(double d, double d2) {
        double d3 = d * this.fromScX + this.fromOffX;
        double d4 = d2 * this.fromScY + this.fromOffY;
        Point point = this.applyProjectionMoveTransform(d3, d4);
        Point point2 = this.t(point.getX(), point.getY());
        point2.setX(point2.getX() * this.outSc + this.outOffX);
        point2.setY(-point2.getY() * this.outSc + this.outOffY);
        return point2;
    }

    @Override
    public boolean preservesLines() {
        return this.type != 2 && this.type != 5;
    }

    private Point t(double d, double d2) {
        if (this.type == 1 || this.type == 4) {
            if (d2 < -85.0) {
                d2 = -85.0;
            } else if (d2 > 85.0) {
                d2 = 85.0;
            }
        }
        d = Math.PI * d / 180.0;
        d2 = Math.PI * d2 / 180.0;
        if (this.type == 2) {
            double d3 = Math.acos(Math.cos(d2) * Math.cos(d / 2.0));
            double d4 = Math.abs(d3) < 1.0E-6 ? 1.0 : Math.sin(d3) / d3;
            double d5 = d * this.cosLambda0 + 2.0 * Math.cos(d2) * Math.sin(d / 2.0) / d4;
            double d6 = d2 + Math.sin(d2) / d4;
            return new Point(d5 / 2.0, d6 / 2.0);
        }
        if (this.type == 1) {
            return new Point(d, Math.log(Math.tan(0.7853981633974483 + d2 / 2.0)));
        }
        if (this.type == 4) {
            return new Point(d, 1.25 * Math.log(Math.tan(0.7853981633974483 + 0.4 * d2)));
        }
        if (this.type == 3) {
            return new Point(d * this.cosLambda0, Math.sin(d2) / this.cosLambda0);
        }
        if (this.type == 5) {
            double d7 = Math.sin(d2);
            double d8 = Math.sin(d - this.midLong) * Math.cos(d2);
            double d9 = -Math.cos(d - this.midLong) * Math.cos(d2);
            double d10 = this.sinLambda0 * d9 + this.cosLambda0 * d7;
            return new Point(d8, d10);
        }
        return new Point(d, d2);
    }
}

