/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.MultiPartTextLine;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.struct.WedgeShape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PolarTransform
extends CoordinateTransform {
    private final boolean mapResponseToAngle;
    private final double startAngleRadian;
    private final boolean clockWise;
    private final PreferredSizeSpec diameter;

    public PolarTransform(Number number, int n, boolean bl, PreferredSizeSpec preferredSizeSpec) {
        assert (n > 0);
        double d = number == null ? 0.0 : number.doubleValue();
        this.mapResponseToAngle = n < 2;
        this.startAngleRadian = -d * Math.PI / 180.0;
        this.clockWise = bl;
        this.diameter = preferredSizeSpec;
    }

    @Override
    public boolean isPolar() {
        return true;
    }

    @Override
    public boolean needsInsideAxes() {
        return true;
    }

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        assert (shape != null);
        assert (dim != null);
        double d = Math.min(dim.getWidth(), dim.getHeight());
        double d2 = Math.min(dim.getWidth(), dim.getHeight());
        double d3 = StyleBuilder.getPreferredSize(this.diameter, d, false, d2);
        double d4 = shape.getOutsideStrokeWidth() * 2.0;
        double d5 = (d3 - d4) / 2.0;
        Shape shape2 = null;
        if (shape.isGlyphLike()) {
            shape2 = this.transformGlyph(shape, dim, d5);
        } else {
            int n = shape.getType();
            if (1004 == n) {
                shape2 = this.makeWedge(shape, dim, d5);
            } else if (1000 == n) {
                shape2 = this.transformCircle(shape, dim, d5);
            } else if (1009 == n) {
                shape2 = this.transformText(shape, dim, d5);
            } else if (1007 == n) {
                shape2 = this.transformMultiPartText(shape, dim, d5);
            } else if (1001 == n) {
                shape2 = this.transformLine(shape, dim, d5);
            } else if (shape instanceof PolyShape) {
                shape2 = Path.isBarLike(shape) ? this.transformBeam((PolyShape)shape, dim, d5) : this.transformPolyShape((PolyShape)shape, dim, d5);
            } else if (1010 == n) {
                shape2 = this.transformSchema((Schema)shape, dim);
            } else {
                throw new EngineException("Cannot polar transform: " + shape, ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
            }
        }
        shape2.setGlobalGradientFromCircle(dim.getWidth() / 2.0, dim.getHeight() / 2.0, d5);
        return shape2;
    }

    private Shape transformBeam(PolyShape polyShape, Dim dim, double d) {
        double[] dArray = polyShape.getXArray();
        double[] dArray2 = polyShape.getYArray();
        Shape[] shapeArray = new Shape[dArray.length / 2];
        for (int i = 0; i < dArray.length; i += 2) {
            double[] dArray3 = new double[]{dArray[i], dArray[i + 1]};
            double[] dArray4 = new double[]{dArray2[i], dArray2[i + 1]};
            ShapeLine shapeLine = new ShapeLine(dArray3, dArray4, false);
            shapeArray[i / 2] = this.transformLine(shapeLine, dim, d);
        }
        Rect rect = this.makeWedge(Shape.toShapeRect(polyShape.getBounds()), dim, d).getBounds();
        return new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, false);
    }

    private Shape transformGlyph(Shape shape, Dim dim, double d) {
        Point point = shape.getCenter();
        double d2 = point.getX();
        double d3 = point.getY();
        this.transformPoint(point, dim, d);
        shape.affine(1.0, point.getX() - d2, 1.0, point.getY() - d3, false);
        return shape;
    }

    private Shape transformSchema(Schema schema, Dim dim) {
        Shape[] shapeArray = schema.getParts();
        for (int i = 0; i < shapeArray.length; ++i) {
            Shape shape = this.transformShape(shapeArray[i], dim, null);
            if (shape == null) continue;
            shapeArray[i] = shape;
        }
        return schema;
    }

    private Shape transformLine(Shape shape, Dim dim, double d) {
        ShapeLine shapeLine = (ShapeLine)shape;
        if (this.mapResponseToAngle) {
            if (shapeLine.getXArray()[0] == shapeLine.getXArray()[1]) {
                double d2 = d * shapeLine.getXArray()[0] / dim.getWidth();
                double d3 = Math.PI * 2 * (1.0 - shapeLine.getYArray()[0] / dim.getHeight());
                double d4 = Math.PI * 2 * (1.0 - shapeLine.getYArray()[1] / dim.getHeight());
                Shape shape2 = ShapeFactory2.CreateArc(dim.getWidth() / 2.0, dim.getHeight() / 2.0, d * d2, d3 + this.startAngleRadian, d4 + this.startAngleRadian);
                shape2.copyInfoFrom(shapeLine);
                return shape2;
            }
        } else if (shapeLine.getYArray()[0] == shapeLine.getYArray()[1]) {
            double d5 = 1.0 - shapeLine.getYArray()[0] / dim.getHeight();
            double d6 = Math.PI * 2 * (shapeLine.getXArray()[0] / dim.getWidth());
            double d7 = Math.PI * 2 * (shapeLine.getXArray()[1] / dim.getWidth());
            Shape shape3 = ShapeFactory2.CreateArc(dim.getWidth() / 2.0, dim.getHeight() / 2.0, d * d5, d6 + this.startAngleRadian, d7 + this.startAngleRadian);
            shape3.copyInfoFrom(shapeLine);
            return shape3;
        }
        this.transformPolyShape((PolyShape)shape, dim, d);
        return shape;
    }

    private boolean isTickInLeftHalf(double d) {
        return d < 0.75 && d > 0.25;
    }

    private boolean isTickAtTopOrBottom(double d) {
        return d == 0.25 || d == 0.75;
    }

    private Shape transformText(Shape shape, Dim dim, double d) {
        Text text = (Text)shape;
        double d2 = this.mapResponseToAngle ? 1.0 - text.getPoint().getY() / dim.getHeight() : text.getPoint().getX() / dim.getWidth();
        double d3 = Math.PI * 2 * d2;
        this.transformPoint(text.getPoint(), dim, d);
        double d4 = d3 + this.startAngleRadian + Math.PI / (text.vertical ? 1.0 : 2.0);
        text.setTransform(this.makeRotateTransform(text.getPoint(), d4));
        if (text.tickLabelOrientation != null) {
            d2 += this.startAngleRadian / (Math.PI * 2);
            String string = "start";
            if ("horizontal".equals(text.tickLabelOrientation)) {
                text.updateTransform(this.makeHorizontalTickLabelTransform(text.getPoint(), d4));
            } else if ("auto".equals(text.tickLabelOrientation)) {
                if (this.isTickInLeftHalf(d2)) {
                    string = "end";
                } else if (this.isTickAtTopOrBottom(d2)) {
                    string = "middle";
                }
                text.align = string;
                text.updateTransform(this.makeAutoTickLabelTransform(text.getPoint(), d4));
            } else if ("vertical".equals(text.tickLabelOrientation)) {
                if (this.isTickInLeftHalf(d2) || this.isTickAtTopOrBottom(d2)) {
                    string = "end";
                }
                text.align = string;
                text.updateTransform(this.makeVerticalTickLabelTransform(text.getPoint(), d4));
            }
        } else {
            text.applyTextAngle();
            if (text.style != null && text.style.angle != null && text.style.angle.equals("polar")) {
                if (!this.isTickInLeftHalf(d2)) {
                    text.align = "start";
                    text.updateTransform(this.makeRotateTransform(text.getPoint(), Math.PI));
                } else {
                    text.align = "end";
                }
            }
        }
        return shape;
    }

    private Shape transformMultiPartText(Shape shape, Dim dim, double d) {
        MultiPartText multiPartText = (MultiPartText)shape;
        Text text = Text.createTextWithShapedValue(multiPartText.getLine(0).getText(), multiPartText.getPoint().getX(), multiPartText.getPoint().getY(), multiPartText.align, multiPartText.valign, multiPartText.getFont(), multiPartText.style, new StyleSpec(), "none", multiPartText.getSize(), multiPartText.isCreateTooltipForTruncated());
        text.tickLabelOrientation = multiPartText.tickLabelOrientation;
        text.vertical = multiPartText.vertical;
        this.transformText(text, dim, d);
        multiPartText.setTransform(text.getTransform());
        multiPartText.align = text.align;
        this.transformPoint(multiPartText.getPoint(), dim, d);
        boolean bl = multiPartText.hasSingleLine() && !multiPartText.getContent().hasMultipleContentParts();
        double d2 = -multiPartText.getHeight() / 2.0;
        d2 = multiPartText.getPoint().getY() < dim.getHeight() / 2.0 ? (d2 -= multiPartText.getFont().getHeight()) : (d2 += multiPartText.getFont().getHeight() / 2.0);
        for (MultiPartTextLine multiPartTextLine : multiPartText.getLines()) {
            multiPartTextLine.align = multiPartText.align;
            this.transformPoint(multiPartTextLine.getPoint(), dim, d);
            for (Shape shape2 : multiPartTextLine.getParts()) {
                if (1009 == shape2.getType()) {
                    ((Text)shape2).align = multiPartText.align;
                    ((Text)shape2).valign = bl ? multiPartText.valign : "end";
                    ((Text)shape2).getPoint().setX(text.getPoint().getX());
                    ((Text)shape2).getPoint().setY(text.getPoint().getY());
                    continue;
                }
                if (1004 != shape2.getType()) continue;
                shape2.setX(text.getPoint().getX());
                shape2.setY(text.getPoint().getY());
            }
            if (!bl) {
                multiPartTextLine.offsetY(d2);
                d2 += multiPartTextLine.getHeight();
            }
            multiPartTextLine.offsetX();
        }
        return shape;
    }

    private Shape transformCircle(Shape shape, Dim dim, double d) {
        Point point = shape.getCenter();
        this.transformPoint(point, dim, d);
        shape.setX(point.getX());
        shape.setY(point.getY());
        return shape;
    }

    private Shape makeWedge(Shape shape, Dim dim, double d) {
        assert (shape != null);
        assert (dim != null);
        Rect rect = (Rect)shape.getGeom();
        double d2 = this.calculateWedgeX(dim);
        double d3 = this.calculateWedgeY(dim);
        double d4 = this.calculateWedgeInnerRadius(d, rect, dim);
        double d5 = this.calculateWedgeOuterRadius(d, rect, dim);
        double d6 = this.calculateWedgeStartAngle(rect, dim);
        double d7 = this.calculateWedgeEndAngle(rect, dim);
        WedgeShape wedgeShape = ShapeFactory2.createWedge(d2, d3, d4, d5, d6, d7);
        wedgeShape.copyInfoFrom(shape);
        return wedgeShape;
    }

    private double calculateWedgeOuterRadius(double d, Rect rect, Dim dim) {
        double d2 = 0.0;
        d2 = this.mapResponseToAngle ? (rect.getX() + rect.getWidth()) / dim.getWidth() : 1.0 - rect.getY() / dim.getHeight();
        return d * d2;
    }

    private double calculateWedgeInnerRadius(double d, Rect rect, Dim dim) {
        double d2 = 0.0;
        if (this.mapResponseToAngle && dim.getWidth() != 0.0) {
            d2 = rect.getX() / dim.getWidth();
        } else if (dim.getHeight() != 0.0) {
            d2 = 1.0 - (rect.getY() + rect.getHeight()) / dim.getHeight();
        }
        return d * d2;
    }

    private double calculateWedgeEndAngle(Rect rect, Dim dim) {
        double d = 0.0;
        d = this.mapResponseToAngle ? (this.clockWise ? Math.PI * 2 * (1.0 - (rect.getY() + rect.getHeight()) / dim.getHeight()) : Math.PI * 2 * ((rect.getY() + rect.getHeight()) / dim.getHeight())) : (rect.getX() + rect.getWidth()) * Math.PI * 2.0 / dim.getWidth();
        return d + this.startAngleRadian;
    }

    private double calculateWedgeStartAngle(Rect rect, Dim dim) {
        double d = 0.0;
        d = this.mapResponseToAngle ? (this.clockWise ? Math.PI * 2 * (1.0 - rect.getY() / dim.getHeight()) : Math.PI * 2 * (rect.getY() / dim.getHeight())) : rect.getX() * Math.PI * 2.0 / dim.getWidth();
        return d + this.startAngleRadian;
    }

    private double calculateWedgeY(Dim dim) {
        return dim.getHeight() / 2.0;
    }

    private double calculateWedgeX(Dim dim) {
        return dim.getWidth() / 2.0;
    }

    private Shape transformPolyShape(PolyShape polyShape, Dim dim, double d) {
        for (int i = 0; i < polyShape.getXArray().length; ++i) {
            Point point = new Point(polyShape.getXArray()[i], polyShape.getYArray()[i]);
            this.transformPoint(point, dim, d);
            polyShape.getXArray()[i] = point.getX();
            polyShape.getYArray()[i] = point.getY();
        }
        return polyShape;
    }

    private Affine makeRotateTransform(Point point, double d) {
        return Affine.makeRotation(d, point.getX(), point.getY());
    }

    private void transformPoint(Point point, Dim dim, double d) {
        double d2 = this.calculateRadius(point, dim, d);
        double d3 = this.calculateTheta(point, dim);
        point.setX(dim.getWidth() / 2.0 + d2 * Math.cos(d3 + this.startAngleRadian));
        point.setY(dim.getHeight() / 2.0 + d2 * Math.sin(d3 + this.startAngleRadian));
    }

    private double calculateTheta(Point point, Dim dim) {
        double d = 0.0;
        d = this.mapResponseToAngle ? Math.PI * 2 * (1.0 - point.getY() / dim.getHeight()) : Math.PI * 2 * (point.getX() / dim.getWidth());
        return d;
    }

    private double calculateRadius(Point point, Dim dim, Double d) {
        double d2 = 0.0;
        d2 = this.mapResponseToAngle ? d * (point.getX() / dim.getWidth()) : d * (1.0 - point.getY() / dim.getHeight());
        return d2;
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        double d = Math.atan2(dArray[0] - dim.getHeight() / 2.0, dArray[1] - dim.getWidth() / 2.0);
        if ((d -= this.startAngleRadian) < 0.0) {
            d += Math.PI * 2;
        }
        d /= Math.PI * 2;
        if (this.mapResponseToAngle) {
            dArray[0] = d = dim.getHeight() - d * dim.getHeight();
            dArray[1] = dim.getWidth() / 2.0;
        } else {
            d *= dim.getWidth();
            double d2 = dArray[0] - dim.getHeight() / 2.0;
            double d3 = dArray[1] - dim.getWidth() / 2.0;
            double d4 = Math.sqrt(d3 * d3 + d2 * d2);
            double d5 = Math.min(dim.getWidth(), dim.getHeight()) / 2.0;
            double d6 = (1.0 - d4 / d5) * dim.getHeight();
            dArray[0] = d;
            dArray[1] = d6;
        }
        return dArray;
    }

    @Override
    public PreferredSizeSpec getDiameterSpec() {
        return this.diameter;
    }

    @Override
    public boolean getClockwise() {
        return this.clockWise;
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        return 0.0;
    }

    private Affine makeAutoTickLabelTransform(Point point, double d) {
        return this.makeRotateTransform(point, -d);
    }

    private Affine makeHorizontalTickLabelTransform(Point point, double d) {
        if (this.isTickAngleInLowerHalf(d)) {
            return this.makeRotateTransform(point, Math.PI);
        }
        return this.makeRotateTransform(point, 0.0);
    }

    private Affine makeVerticalTickLabelTransform(Point point, double d) {
        if (this.isTickAngleInRightHalf(d -= Math.PI)) {
            return this.makeRotateTransform(point, Math.PI);
        }
        return this.makeRotateTransform(point, 0.0);
    }

    private boolean isTickAngleInLowerHalf(double d) {
        return d > 1.5707963267948966 && d < 4.71238898038469;
    }

    private boolean isTickAngleInRightHalf(double d) {
        return d < 1.5707963267948966 || d > 4.71238898038469;
    }

    public Point transformPointShape(Point point, Dim dim) {
        assert (point != null);
        assert (dim != null);
        double d = Math.min(dim.getWidth(), dim.getHeight());
        double d2 = Math.min(dim.getWidth(), dim.getHeight());
        double d3 = StyleBuilder.getPreferredSize(this.diameter, d, false, d2);
        double d4 = d3 / 2.0;
        this.transformPoint(point, dim, d4);
        return point;
    }

    @Override
    public Rect modifyArea(List<Axis> list, Rect rect) {
        double d = 0.0;
        double d2 = 0.0;
        Dim dim = rect.getExtent();
        for (Axis axis : list) {
            if (axis.getDrawPosition() != 1 && (axis.getDrawPosition() != 0 || !axis.isDrawOppositeSide())) continue;
            double d3 = axis.getSpacing() * 4.0;
            double d4 = axis.getInitializedTickMarkSize();
            Dim dim2 = axis.getMaxTickLabelSize(dim);
            d = Math.max(d, dim2.getWidth() + d3 + d4);
            d2 = Math.max(d2, dim2.getHeight() + d3 + d4);
        }
        if (d * 2.0 > dim.getWidth() || d2 * 2.0 > dim.getHeight()) {
            return rect;
        }
        rect.setX(rect.getX() + d);
        rect.setWidth(rect.getWidth() - 2.0 * d);
        rect.setY(rect.getY() + d2);
        rect.setHeight(rect.getHeight() - 2.0 * d2);
        return rect;
    }
}

