/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Position {
    public static final Position NO_COORDS = new Position(0, 0, 0);
    public final Double[] base;
    public final Double[] extra;
    public final Double[] facet;
    public Field[] fields;
    public double[] index;
    public boolean[] valueIsPercentage;
    private final Integer[] span;
    private final Double[] suggestedSize = new Double[2];

    public Position(int n, int n2, int n3) {
        this.base = new Double[n];
        this.fields = new Field[n];
        this.span = new Integer[n];
        this.extra = n2 > 0 ? new Double[n2] : null;
        this.facet = n3 > 0 ? new Double[n3] : null;
        this.index = new double[n];
        this.valueIsPercentage = new boolean[n];
    }

    public static Position makeSimple(double[] dArray) {
        Position position = new Position(dArray.length, 0, 0);
        for (int i = 0; i < dArray.length; ++i) {
            position.base[i] = dArray[i];
            position.index[i] = i;
        }
        return position;
    }

    public Double get(int n) {
        return this.base[n];
    }

    public Double X() {
        return this.base[1];
    }

    public Double Y() {
        return this.base[0];
    }

    public Double X2() {
        return this.extra[1];
    }

    public Double Y2() {
        return this.extra[0];
    }

    public int length() {
        return this.base.length;
    }

    public boolean hasX2() {
        return this.extra != null && this.extra.length > 1;
    }

    public boolean hasY2() {
        return this.extra != null;
    }

    public boolean XYUndefined() {
        return this.base.length > 0 && this.base[0] == null || this.base.length > 1 && this.base[1] == null || this.hasY2() && this.extra[0] == null || this.hasX2() && this.extra[1] == null;
    }

    public boolean XPositionCoordinateUndefined() {
        return this.base.length > 1 && this.base[1] == null;
    }

    public Position setFacet(double[] dArray) {
        int n;
        int n2 = this.extra == null ? 0 : this.extra.length;
        Position position = new Position(this.base.length, n2, dArray.length);
        for (n = 0; n < this.base.length; ++n) {
            position.base[n] = this.base[n];
        }
        for (n = 0; n < n2; ++n) {
            position.extra[n] = this.extra[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            position.facet[n] = dArray[n];
        }
        return position;
    }

    public double getYOrigin(Scale scale) {
        Unit unit = this.fields[0] != null ? this.fields[0].unit : null;
        Integer n = this.span != null ? this.span[0] : null;
        return scale.getSpanOrigin(this.index[0], unit, n);
    }

    public boolean containsUndefinedXValues() {
        for (int i = 1; i < this.base.length; ++i) {
            Double d = this.base[i];
            if (d != null) continue;
            return true;
        }
        return false;
    }

    protected final void setSpan(int n, Integer n2) {
        this.span[n] = n2;
    }

    public final Double[] getSuggestedSize() {
        return this.suggestedSize;
    }

    public void updateSuggestedSize(ValueProvider valueProvider, Scale scale, Number number, int n) {
        Double d;
        ScaleSpan scaleSpan;
        if (number != null && (scaleSpan = valueProvider.getMatchingSpan(number, scale)) != null && (d = scaleSpan.getSuggestedSize(number)) != null) {
            this.getSuggestedSize()[n] = d;
        }
    }
}

