/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import java.util.Arrays;
import java.util.Comparator;

public class PositionComparator
implements Comparator<Number> {
    private final Position[] positions;
    private int depth = 1;

    public PositionComparator(Position[] positionArray, int n) {
        this.positions = positionArray;
        this.depth = n;
    }

    @Override
    public int compare(Number number, Number number2) {
        int n = number.intValue();
        int n2 = number2.intValue();
        for (int i = 1; i < this.depth; ++i) {
            Double[] doubleArray = this.positions[n].base;
            Double[] doubleArray2 = this.positions[n2].base;
            double d = doubleArray[i] - doubleArray2[i];
            if (d < 0.0) {
                return -1;
            }
            if (!(d > 0.0)) continue;
            return 1;
        }
        double d = n - n2;
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static int[] makeSortOrder(Position[] positionArray, int n) {
        int n2 = positionArray.length;
        Number[] numberArray = new Number[n2];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = i;
        }
        Arrays.sort(numberArray, new PositionComparator(positionArray, n));
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = numberArray[i].intValue();
        }
        return nArray;
    }
}

