/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.MapProjection;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ProjectionParametersSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ProjectionTransform
extends CoordinateTransform {
    private final ProjectionParametersSpec projectionParamSpec;
    private PointTransform transform;

    public ProjectionTransform(ProjectionParametersSpec projectionParametersSpec) {
        this.projectionParamSpec = projectionParametersSpec;
    }

    private void setTransforms(Dim dim, Scale[] scaleArray) {
        double d = scaleArray[0].dimensionToDataValueInterpolate(0.0, dim.getHeight());
        double d2 = scaleArray[0].dimensionToDataValueInterpolate(dim.getHeight(), dim.getHeight());
        double d3 = scaleArray[1].dimensionToDataValueInterpolate(0.0, dim.getWidth());
        double d4 = scaleArray[1].dimensionToDataValueInterpolate(dim.getWidth(), dim.getWidth());
        this.transform = new MapProjection(this.projectionParamSpec, d3, d4, d, d2, dim, scaleArray[0].spans.get(0).getInputRange());
    }

    @Override
    public void updateBounds(Dim dim) {
        if (this.transform != null && this.transform instanceof MapProjection) {
            ((MapProjection)this.transform).updateBounds(dim);
        }
    }

    @Override
    public boolean needsInsideAxes() {
        return true;
    }

    @Override
    public boolean isProjection() {
        return true;
    }

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        if (this.transform == null) {
            this.setTransforms(dim, scaleArray);
        }
        if (shape.isGlyphLike()) {
            Point point = shape.getCenter();
            Point point2 = this.transform.transform(point.getX(), point.getY());
            shape.affine(1.0, point2.getX() - point.getX(), 1.0, point2.getY() - point.getY(), false);
        } else if (shape.getParts() != null) {
            Shape[] shapeArray = shape.getParts();
            for (int i = 0; i < shapeArray.length; ++i) {
                shapeArray[i] = this.transformShape(shapeArray[i], dim, scaleArray);
            }
            ((Schema)shape).recalcuateBounds();
        } else {
            Geom geom = shape.applyPointTransform(this.transform);
            if (geom != null) {
                int n = ((Poly)geom).getPointCount();
                char[] cArray = new char[n];
                cArray[0] = 77;
                for (int i = 1; i < n; ++i) {
                    cArray[i] = 76;
                }
                if (shape.getGeom() instanceof Rect || shape.getGeom() instanceof Circle) {
                    cArray[n - 1] = 90;
                }
                Path path = new Path(((Poly)geom).getX(), ((Poly)geom).getY(), shape.isFilled(), cArray);
                path.copyInfoFrom(shape);
                shape = path;
            }
        }
        return shape;
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        return null;
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        return d;
    }

    @Override
    public boolean isInversible() {
        return false;
    }
}

