/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapeGroup
extends ShapeNode {
    private final HashMap<Integer, Integer> gapsAtLevel = new HashMap();
    private final HashMap<Integer, Integer> nodesAtLevel = new HashMap();
    private double gapSize = 0.0;
    private String alignment = "start";
    private boolean nodesReversed;

    public ShapeGroup(double d) {
        super(d);
        this.nodeIsLeaf = false;
    }

    public void clearCache() {
        ShapeGroup shapeGroup = (ShapeGroup)this.getRootNode();
        shapeGroup.gapsAtLevel.clear();
        shapeGroup.nodesAtLevel.clear();
    }

    public final void setIsReversed(boolean bl) {
        this.nodesReversed = bl;
    }

    public final boolean isReversed() {
        return this.nodesReversed;
    }

    @Override
    public List<ShapeNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    @Override
    public void preProcess() {
        for (ShapeNode shapeNode : this.children) {
            shapeNode.preProcess();
        }
    }

    @Override
    public double getAlignedStart() {
        double d = 0.0;
        if ("middle".equals(this.alignment)) {
            d = (this.getMaxWidth() - this.getPreferredWidth()) / 2.0;
        } else if ("end".equals(this.alignment)) {
            d = this.getMaxWidth() - this.getPreferredWidth();
        }
        return d;
    }

    public void setGapSize(double d) {
        this.gapSize = d;
    }

    @Override
    public double getGapSize() {
        if (this.children.size() == 0) {
            return 0.0;
        }
        return this.gapSize;
    }

    public void setAlignment(String string) {
        this.alignment = string;
    }

    @Override
    public int getNodesAtLevel(int n, int n2) {
        int n3 = 0;
        ShapeGroup shapeGroup = (ShapeGroup)this.getRootNode();
        Integer n4 = shapeGroup.nodesAtLevel.get(n);
        if (n4 != null) {
            n3 = n4;
        } else {
            n3 = this.calculateNodesAtLevel(n, n2);
            shapeGroup.nodesAtLevel.put(n, n3);
        }
        return n3;
    }

    @Override
    protected int calculateNodesAtLevel(int n, int n2) {
        int n3 = 0;
        if (n == n2) {
            n3 = this.children.size() == 0 ? 1 : this.children.size();
        } else {
            for (ShapeNode shapeNode : this.children) {
                n3 += shapeNode.calculateNodesAtLevel(n, n2 + 1);
            }
            if (this.children.size() == 0) {
                ++n3;
            }
        }
        return n3;
    }

    @Override
    public double getSizeOfNodesAtLevel(int n, int n2) {
        if (n == n2) {
            return this.getPreferredWidth();
        }
        int n3 = 0;
        for (ShapeNode shapeNode : this.getChildren()) {
            double d = shapeNode.getSizeOfNodesAtLevel(n, n2 + 1);
            if (d > 0.0 && shapeNode.isLeaf()) {
                return d * (double)this.getChildren().size();
            }
            n3 = (int)((double)n3 + d);
        }
        return n3;
    }

    protected int getNumberOfGapsAtLevel() {
        ShapeGroup shapeGroup = (ShapeGroup)this.getRootNode();
        Integer n = shapeGroup.gapsAtLevel.get(this.getLevel());
        if (n != null) {
            return n;
        }
        n = shapeGroup.getNodesAtLevel(this.getLevel(), 0) - 1;
        int n2 = 0;
        ShapeNode shapeNode = this.getParent();
        int n3 = this.getLevel() - 1;
        if (shapeNode != null) {
            n2 = shapeGroup.getNodesAtLevel(n3--, 0) - 1;
        }
        n = n - n2;
        shapeGroup.gapsAtLevel.put(this.getLevel(), n);
        return n;
    }
}

