/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.ShapeGroup;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapeNode {
    private final List<Shape> shapes = new ArrayList<Shape>();
    protected final List<ShapeNode> children = new ArrayList<ShapeNode>();
    protected final HashMap<Integer, Double> levelGapSize = new HashMap();
    private boolean nodeIsDirty = false;
    private ShapeNode parent = null;
    private double preferredWidth = 0.0;
    private double maxWidth = 0.0;
    private double padding = 0.0;
    private boolean nodeContainsElement = false;
    private int id = 0;
    protected boolean nodeIsLeaf = true;
    private double startX = 0.0;
    protected boolean nodeContainsLeaves = false;
    private ShapeNode previousSibling = null;
    private ShapeNode nextSibling = null;
    private static final List<ShapeNode> EMPTY_CHILD_LIST = new ArrayList<ShapeNode>();

    public ShapeNode(double d) {
        this.setMaxWidth(d);
    }

    public final ShapeNode getParent() {
        return this.parent;
    }

    public final void setParent(ShapeNode shapeNode) {
        this.parent = shapeNode;
    }

    public void calculateSizeAndGaps(double d, double d2) {
        this.calculateSizing(d, d2);
    }

    public double calculateSizing(double d, double d2) {
        this.setPreferredWidth(Math.min(d2, d));
        this.setMaxWidth(d2);
        return this.getPreferredWidth();
    }

    public double calculateGaps(double d) {
        return 0.0;
    }

    public void preProcess() {
    }

    public boolean hasChildren() {
        return false;
    }

    public final List<Shape> getShapes() {
        return this.shapes;
    }

    public final void addShape(Shape shape) {
        this.shapes.add(shape);
        this.setDirty(true);
        if (shape.isElement()) {
            this.setContainsElement(true);
        }
    }

    public final void setDirty(boolean bl) {
        this.nodeIsDirty = bl;
    }

    public final boolean isDirty() {
        return this.nodeIsDirty;
    }

    public final void setPreferredWidth(double d) {
        double d2 = d;
        this.preferredWidth = Math.max(0.0, d2);
    }

    public final double getPreferredWidth() {
        return this.preferredWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidth = Math.max(0.0, d);
    }

    public final double getMaxWidth() {
        return this.maxWidth;
    }

    public final ShapeNode getRootNode() {
        ShapeNode shapeNode = this;
        while (shapeNode.parent != null) {
            shapeNode = shapeNode.parent;
        }
        return shapeNode;
    }

    public final void setPadding(double d) {
        this.padding = d;
    }

    public final double getPadding() {
        return this.padding;
    }

    public double getAlignedStart() {
        return 0.0;
    }

    public List<ShapeNode> getChildren() {
        return EMPTY_CHILD_LIST;
    }

    public double getGapSize() {
        return 0.0;
    }

    private final void setContainsElement(boolean bl) {
        this.nodeContainsElement = bl;
    }

    public final boolean containsElement() {
        return this.nodeContainsElement;
    }

    public int getNodesAtLevel(int n, int n2) {
        return this.calculateNodesAtLevel(n, n2);
    }

    protected int calculateNodesAtLevel(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        return 0;
    }

    public double getSizeOfNodesAtLevel(int n, int n2) {
        if (n == n2) {
            return this.getPreferredWidth();
        }
        return 0.0;
    }

    public final void setIndex(int n) {
        this.id = n;
    }

    public final int getIndex() {
        return this.id;
    }

    public int getLevel() {
        int n = 0;
        ShapeNode shapeNode = this;
        while (shapeNode.getParent() != null) {
            shapeNode = shapeNode.getParent();
            ++n;
        }
        return n;
    }

    public void fixOrdering() {
    }

    public final boolean isLeaf() {
        return this.nodeIsLeaf;
    }

    public final void setStartX(double d) {
        this.startX = d;
    }

    public final double getStartX() {
        return this.startX;
    }

    public Collection<ShapeNode> findShapeNodes(Shape shape, int n) {
        return null;
    }

    public final double getGapSizeAtLevel(int n) {
        Double d = this.levelGapSize.get(n);
        if (d == null) {
            return Double.NaN;
        }
        return d;
    }

    public void setGapSizeAtLevel(int n, double d) {
        this.levelGapSize.put(n, d);
    }

    public double getLeafSize() {
        return 0.0;
    }

    public HashMap<Integer, ShapeNode> getIndexMap() {
        return null;
    }

    public void add(ShapeNode shapeNode, int n) {
        if (shapeNode.isLeaf()) {
            this.setContainsLeaves(true);
        }
        shapeNode.setParent(this);
        shapeNode.setPreviousSibling(null);
        shapeNode.setNextSibling(null);
        if (this.children.size() > 0) {
            ShapeNode shapeNode2 = this.children.get(this.children.size() - 1);
            shapeNode.setPreviousSibling(shapeNode2);
            shapeNode2.setNextSibling(shapeNode);
        }
        this.children.add(shapeNode);
        this.setDirty(true);
    }

    private void setContainsLeaves(boolean bl) {
        this.nodeContainsLeaves = bl;
    }

    public final int getNumberOfGaps() {
        if (this.children.size() > 0) {
            return this.children.size() - 1;
        }
        return 0;
    }

    public int getMaxNumberOfChildren() {
        return this.children.size();
    }

    public void reverse() {
        int n = this.children.size();
        int n2 = n >> 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i - 1;
            ShapeNode shapeNode = this.children.get(i);
            ShapeNode shapeNode2 = this.children.get(n3);
            this.children.set(n3, shapeNode);
            this.children.set(i, shapeNode2);
        }
    }

    protected boolean containsLeaves() {
        return this.nodeContainsLeaves;
    }

    public double getChildrenWidthTo(ShapeNode shapeNode) {
        ShapeNode shapeNode2 = shapeNode.getPreviousSibling();
        double d = this.getStartX() + this.getAlignedStart() + this.getPadding();
        if (shapeNode2 != null) {
            d = shapeNode2.getStartX() + shapeNode2.getPreferredWidth() + this.getGapSize();
        }
        return d;
    }

    public final ShapeNode getPreviousSibling() {
        return ((ShapeGroup)this.getParent()).isReversed() ? this.nextSibling : this.previousSibling;
    }

    public final void setPreviousSibling(ShapeNode shapeNode) {
        this.previousSibling = shapeNode;
    }

    public final ShapeNode getNextSibling() {
        return ((ShapeGroup)this.getParent()).isReversed() ? this.previousSibling : this.nextSibling;
    }

    public final void setNextSibling(ShapeNode shapeNode) {
        this.nextSibling = shapeNode;
    }
}

