/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate;

import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class TransposeTransform
extends CoordinateTransform {
    TransposeTransform() {
    }

    @Override
    public boolean isTranspose() {
        return true;
    }

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        Object object;
        assert (dim != null);
        if (shape.isGlyphLike()) {
            object = shape.getCenter();
            double d = dim.getWidth() - dim.getWidth() * ((Point)object).getY() / dim.getHeight();
            double d2 = dim.getHeight() * (1.0 - ((Point)object).getX() / dim.getWidth());
            shape.affine(1.0, d - ((Point)object).getX(), 1.0, d2 - ((Point)object).getY(), false);
        } else {
            shape.transpose(dim);
        }
        object = shape.getReversed();
        if (object != null) {
            if (((String)object).equals("x")) {
                shape.setReversed("y");
            }
            if (((String)object).equals("y")) {
                shape.setReversed("x");
            }
        }
        return shape;
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        double d;
        assert (dArray != null);
        assert (dim != null);
        double d2 = dim.getWidth() * (1.0 - dArray[0] / dim.getHeight());
        dArray[0] = d = dim.getHeight() * (1.0 - dArray[1] / dim.getWidth());
        dArray[1] = d2;
        return dArray;
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        return 0.0;
    }

    @Override
    public boolean appliesToAxisTickOrLabel() {
        return true;
    }
}

