/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.cluster;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeGroup;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Rect;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ClusterLayout {
    private final Map<Shape, Integer> shapeToCurrentIndex = new HashMap<Shape, Integer>(100);
    private final Set<String> movedShapes = new HashSet<String>();
    private double rootStartX = 0.0;

    public void layout(ShapeNode shapeNode) {
        this.layoutInternal(shapeNode, false);
    }

    public void layoutAll(ShapeNode shapeNode, Range range) {
        this.movedShapes.clear();
        if (range != null) {
            this.rootStartX = range.getMin();
        }
        this.layoutInternal(shapeNode, true);
    }

    private void layoutInternal(ShapeNode shapeNode, boolean bl) {
        double d = this.rootStartX;
        ShapeNode shapeNode2 = shapeNode.getParent();
        if (shapeNode2 != null) {
            d = shapeNode2.getChildrenWidthTo(shapeNode);
        }
        shapeNode.setStartX(d);
        if (shapeNode.isDirty()) {
            this.layoutShapes(shapeNode, shapeNode.getShapes(), d);
        }
        if (bl) {
            for (ShapeNode shapeNode3 : shapeNode.getChildren()) {
                this.layoutInternal(shapeNode3, bl);
            }
        }
    }

    private void layoutShapes(ShapeNode shapeNode, List<Shape> list, double d) {
        block0: for (Shape shape : list) {
            Object object;
            if (this.movedShapes.contains(shape.getID())) continue;
            Position[] positionArray = shape.getPositions();
            if (positionArray != null && positionArray.length > 1) {
                object = (PolyShape)shape;
                Integer n = this.shapeToCurrentIndex.get(shape);
                if (n == null) {
                    n = 0;
                }
                for (int i = n.intValue(); i < positionArray.length; ++i) {
                    int n2;
                    ShapeNode shapeNode2;
                    Position position = positionArray[i];
                    if (!((ClusterShapeNode)shapeNode).positionBelongsToNode(position)) continue;
                    double d2 = d + shapeNode.getPreferredWidth() / 2.0;
                    int n3 = position.length() - 1;
                    if (position.valueIsPercentage[n3] && (shapeNode2 = shapeNode.getParent()) != null) {
                        d2 = shapeNode2.getStartX() + shapeNode2.getPreferredWidth() * position.base[n3];
                    }
                    if (((PolyShape)object).getXArray().length == positionArray.length + 2) {
                        int n4 = i + 1;
                        ((PolyShape)object).getXArray()[n4] = d2;
                        if (n4 == 1) {
                            ((PolyShape)object).getXArray()[0] = d2;
                        } else if (i == positionArray.length - 1) {
                            ((PolyShape)object).getXArray()[n4 + 1] = d2;
                        }
                    } else {
                        ((PolyShape)object).getXArray()[i] = d2;
                    }
                    if ((n2 = i - 1) < 0) continue block0;
                    this.shapeToCurrentIndex.put(shape, n2);
                    continue block0;
                }
                continue;
            }
            this.movedShapes.add(shape.getID());
            object = ClusterLayout.affineSinglePositionShape(shape, shapeNode, d, shape.isElement(), shape.getBounds());
            if (shape.isGlyphLike()) {
                shape.affine(1.0, (double)object[2], 1.0, 0.0, false);
                continue;
            }
            shape.affine((double)object[0], (double)object[1], 1.0, 0.0, false);
        }
        shapeNode.setDirty(false);
    }

    private static double[] affineSinglePositionShape(Shape shape, ShapeNode shapeNode, double d, boolean bl, Rect rect) {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        int n = shape.getPosition().length() - 1;
        if (shape.getPosition().valueIsPercentage[n]) {
            ShapeNode shapeNode2 = shapeNode.getParent();
            if (shapeNode2 != null) {
                double d2 = shapeNode2.getStartX() + shapeNode2.getPreferredWidth() * shape.getPosition().base[n];
                double d3 = shapeNode2.getPreferredWidth() / rect.getWidth();
                dArray[0] = d3 = d3 > 1.0 ? 1.0 : d3;
                dArray[1] = d2 - d3 * (rect.getWidth() / 2.0 + rect.getX());
                dArray[2] = d2 - shape.getCenter().getX();
            }
        } else {
            double d4;
            ShapeGroup shapeGroup = (ShapeGroup)shapeNode.getRootNode();
            double d5 = 0.0;
            double d6 = rect.getWidth();
            if (bl) {
                d6 = shapeGroup.getMaxWidth() / (double)shapeGroup.getMaxNumberOfChildren();
            }
            d5 = shape.getCenter().getX();
            Range range = d6 == 0.0 ? new Range(d5 - 0.5, d5 + 0.5) : new Range(d5 - d6 / 2.0, d5 + d6 / 2.0);
            Range range2 = new Range(d, d + shapeNode.getPreferredWidth());
            dArray[0] = d4 = range2.getRange() / range.getRange();
            dArray[1] = range2.getMin() - range.getMin() * d4;
            dArray[2] = range2.mid() - range.mid();
        }
        return dArray;
    }
}

