/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.cluster;

import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeGroup;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.spechelper.ClusterGapSizeSpecHelper;
import com.ibm.vis.engine.internal.spechelper.ClusterWidthSizeSpecHelper;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ClusterShapeGroup
extends ShapeGroup {
    private final HashMap<Integer, ShapeNode> indexToShapeNode = new HashMap();
    private ClusterGapSizeSpecHelper gapSpecHelper = new ClusterGapSizeSpecHelper(null);
    protected final double fullVizWidth;
    private double preferredGapWidth = Double.NaN;
    private double leafSize = Double.NaN;
    private ClusterWidthSizeSpecHelper categoryWidthSpecHelper = new ClusterWidthSizeSpecHelper(null);
    protected boolean nodeNested = false;

    public ClusterShapeGroup(double d, double d2) {
        super(d);
        this.fullVizWidth = d2;
    }

    @Override
    public void calculateSizeAndGaps(double d, double d2) {
        if (this.isDirty()) {
            this.calculateSizing(d, d2);
            this.calculateGaps(d2);
        }
    }

    @Override
    public double calculateSizing(double d, double d2) {
        double d3;
        double d4 = d2 - this.getPadding() * 2.0;
        double d5 = 0.0;
        if (this.getChildren().size() > 1) {
            d5 = this.getMinGapWidth(d4);
        }
        if ((d3 = d4 - d5 * (double)this.getNumberOfGapsAtLevel()) < 0.0) {
            throw new EngineException("minimum cluster gap sizes will not fit in bounds", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        this.setMaxWidth(d3);
        double d6 = d - this.getPreferredGapWidth(d) * (double)this.getNumberOfGapsAtLevel();
        this.setPreferredWidth(d6);
        double d7 = 0.0;
        Object object = this.getChildren().iterator();
        while (object.hasNext()) {
            ShapeNode shapeNode = object.next();
            d7 += shapeNode.calculateSizing(this.getPreferredWidth(), d3);
        }
        if (this.getChildren().size() == 0 && Double.isNaN(d7 = ((ShapeNode)(object = this.getRootNode())).getLeafSize())) {
            int n = this.getRootNode().getNodesAtLevel(this.getLevel(), 0);
            d7 = this.getPreferredWidth() / (double)n;
        }
        this.setPreferredWidth(d7);
        return this.getPreferredWidth();
    }

    @Override
    public double calculateGaps(double d) {
        double d2;
        int n = this.getLevel();
        ShapeNode shapeNode = this.getRootNode();
        double d3 = shapeNode.getSizeOfNodesAtLevel(n, 0);
        double d4 = 0.0;
        if (this.getChildren().size() > 1 && Double.isNaN(d4 = shapeNode.getGapSizeAtLevel(n))) {
            d4 = this.calculateGapSizing(d3, d);
            shapeNode.setGapSizeAtLevel(n, d4);
        }
        if ((double)Math.round(d3 + (d2 = d4 * (double)this.getNumberOfGaps())) < d) {
            for (ShapeNode shapeNode2 : this.getChildren()) {
                d2 += shapeNode2.calculateGaps(d - d4 * (double)this.getNumberOfGapsAtLevel());
            }
        }
        this.setPreferredWidth(this.getPreferredWidth() + d2);
        this.setGapSize(d4);
        return d2;
    }

    private double calculateGapSizing(double d, double d2) {
        double d3 = this.getPreferredGapWidth(d2);
        double d4 = this.getMinGapWidth(d2);
        int n = this.getNumberOfGapsAtLevel();
        if (n > 0 && d3 > 0.0) {
            double d5 = (d2 - d) / (double)n;
            d5 = Math.min(d5, d3);
            if ((d5 = Math.max(d5, 0.0)) < d4) {
                throw new EngineException("minimum cluster gap sizes will not fit in bounds", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
            }
            d3 = d5;
        }
        return d3;
    }

    public List<ShapeNode> addShapeToMatchingNode(Shape shape) {
        ArrayList<ShapeNode> arrayList = new ArrayList<ShapeNode>();
        if (!this.includeShape(shape)) {
            return arrayList;
        }
        Collection<ShapeNode> collection = this.findShapeNodes(shape, 1);
        if (collection.size() > 0) {
            for (ShapeNode shapeNode : collection) {
                shapeNode.addShape(shape);
                arrayList.add(shapeNode);
            }
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public void add(ShapeNode shapeNode, int n) {
        super.add(shapeNode, n);
        this.mapLocationToNode(n, shapeNode);
    }

    @Override
    public Collection<ShapeNode> findShapeNodes(Shape shape, int n) {
        IntPrimitiveArrayList intPrimitiveArrayList = this.getIndexesFromShape(shape, n);
        Collection<ShapeNode> collection = this.getNodesFromIndexes(intPrimitiveArrayList);
        if (collection.size() == 0 || this.isLastShapePosition(shape, n)) {
            return collection;
        }
        ArrayList<ShapeNode> arrayList = new ArrayList<ShapeNode>();
        for (ShapeNode shapeNode : collection) {
            Collection<ShapeNode> collection2 = shapeNode.findShapeNodes(shape, n + 1);
            if (collection2 == null) continue;
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    protected IntPrimitiveArrayList getIndexesFromShape(Shape shape, int n) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        Position[] positionArray = shape.getPositions();
        for (int i = 0; i < positionArray.length; ++i) {
            int n2 = 0;
            if (positionArray[i].valueIsPercentage.length > n) {
                n2 = positionArray[i].valueIsPercentage[n] ? this.getIndexMap().keySet().iterator().next() : (int)Math.floor(positionArray[i].index[n]);
            }
            intPrimitiveArrayList.add(n2);
        }
        return intPrimitiveArrayList;
    }

    protected boolean isLastShapePosition(Shape shape, int n) {
        boolean bl = false;
        bl = shape.getPosition() != null ? n == shape.getPosition().length() - 1 : n == shape.getPositions()[0].length() - 1;
        return bl;
    }

    protected void mapLocationToNode(int n, ShapeNode shapeNode) {
        this.getIndexMap().put(n, shapeNode);
        shapeNode.setIndex(n);
    }

    protected Collection<ShapeNode> getNodesFromIndexes(IntPrimitiveArrayList intPrimitiveArrayList) {
        HashSet<ShapeNode> hashSet = new HashSet<ShapeNode>();
        HashMap<Integer, ShapeNode> hashMap = this.getIndexMap();
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            ShapeNode shapeNode = hashMap.get(intPrimitiveArrayList.get(i));
            if (shapeNode == null) continue;
            hashSet.add(shapeNode);
        }
        return hashSet;
    }

    public void setGapSpecHelper(ClusterGapSizeSpecHelper clusterGapSizeSpecHelper) {
        if (clusterGapSizeSpecHelper != null) {
            this.gapSpecHelper = clusterGapSizeSpecHelper;
        }
    }

    protected final double getPreferredGapWidth(double d) {
        if (Double.isNaN(this.preferredGapWidth)) {
            this.preferredGapWidth = this.gapSpecHelper.getPreferred(d, this.fullVizWidth);
        }
        return this.preferredGapWidth;
    }

    private final double getMinGapWidth(double d) {
        return this.gapSpecHelper.getMin(d, this.fullVizWidth);
    }

    @Override
    public final HashMap<Integer, ShapeNode> getIndexMap() {
        return this.indexToShapeNode;
    }

    protected final void setLeafSize(double d) {
        this.leafSize = d;
    }

    @Override
    public final double getLeafSize() {
        return this.leafSize;
    }

    public final boolean isNested() {
        return this.nodeNested;
    }

    public void setWidthSpecHelper(ClusterWidthSizeSpecHelper clusterWidthSizeSpecHelper) {
        if (clusterWidthSizeSpecHelper != null) {
            this.categoryWidthSpecHelper = clusterWidthSizeSpecHelper;
        }
    }

    public ClusterWidthSizeSpecHelper getWidthSpecHelper() {
        return this.categoryWidthSpecHelper;
    }

    @Override
    public void fixOrdering() {
        if (!this.isDirty()) {
            return;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            this.getChildren().get(i).fixOrdering();
        }
    }

    protected boolean includeShape(Shape shape) {
        Position[] positionArray = shape.getPositions();
        boolean bl = true;
        if (positionArray != null) {
            for (Position position : positionArray) {
                if (!position.containsUndefinedXValues()) continue;
                return false;
            }
        } else {
            bl = !shape.getPosition().containsUndefinedXValues();
        }
        return bl;
    }
}

