/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.cluster;

import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeGroup;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeGroup;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.spechelper.ClusterWidthSizeSpecHelper;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ClusterShapeNode
extends ShapeNode {
    protected final double fullVizWidth;

    public ClusterShapeNode(double d, double d2) {
        super(d);
        this.fullVizWidth = d2;
    }

    @Override
    public double calculateSizing(double d, double d2) {
        double d3;
        double d4;
        ClusterShapeGroup clusterShapeGroup = (ClusterShapeGroup)this.getRootNode();
        double d5 = clusterShapeGroup.getLeafSize();
        if (!Double.isNaN(d5)) {
            this.setPreferredWidth(d5);
            return clusterShapeGroup.getLeafSize();
        }
        ClusterShapeGroup clusterShapeGroup2 = (ClusterShapeGroup)this.getRootNode();
        ClusterWidthSizeSpecHelper clusterWidthSizeSpecHelper = clusterShapeGroup2.getWidthSpecHelper();
        double d6 = d4 = clusterWidthSizeSpecHelper.getPreferred(d, this.fullVizWidth);
        ShapeGroup shapeGroup = (ShapeGroup)this.getRootNode();
        int n = shapeGroup.getNodesAtLevel(this.getLevel() - 1, 0);
        if (Double.isNaN(d4)) {
            d6 = d / (double)n;
        }
        if ((d6 = Math.min(d6, d3 = d2 / (double)n)) < 1.0) {
            d6 = Math.min(1.0, d3);
        }
        if (d6 < clusterWidthSizeSpecHelper.getMin(d, this.fullVizWidth)) {
            throw new EngineException("minimum cluster sizes will not fit in bounds", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
        }
        clusterShapeGroup.setLeafSize(d6);
        this.setPreferredWidth(d6);
        return d6;
    }

    public boolean positionBelongsToNode(Position position) {
        ShapeNode shapeNode = this;
        int n = position.length() - 1;
        if (position.valueIsPercentage[n]) {
            --n;
            if ((shapeNode = shapeNode.getParent()) == null) {
                return false;
            }
        }
        for (int i = n; i > 0; --i) {
            if ((double)shapeNode.getIndex() != position.index[i]) {
                return false;
            }
            if ((shapeNode = shapeNode.getParent()) != null) continue;
            return false;
        }
        return true;
    }
}

