/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.cluster;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.ShapeIterator;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterLayout;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeGroup;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeNode;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.NestedClusterShapeGroup;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.spechelper.CategoryStructureSpecHelper;
import com.ibm.vis.engine.internal.spechelper.ScaleSpecHelper;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.DimensionSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ClusterTransform
extends CoordinateTransform {
    private final ArrayList<CategoryStructureSpecHelper> specHelpers;
    private Dim visSize;
    private ClusterShapeGroup rootShapeGroup;
    private final ScaleSpecHelper scaleSpec;
    private ClusterLayout layout = new ClusterLayout();
    private HashMap<Shape, List<ShapeNode>> shapeToNodes;
    private Range rootRange;

    public ClusterTransform(DimensionSpec[] dimensionSpecArray, Vis vis) {
        this.specHelpers = new ArrayList(dimensionSpecArray.length);
        for (DimensionSpec dimensionSpec : dimensionSpecArray) {
            CategoryStructureSpecHelper categoryStructureSpecHelper = new CategoryStructureSpecHelper(null);
            if (dimensionSpec.scale != null && dimensionSpec.scale.categoryStructure != null) {
                categoryStructureSpecHelper = new CategoryStructureSpecHelper(dimensionSpec.scale.categoryStructure);
            }
            this.specHelpers.add(categoryStructureSpecHelper);
        }
        this.visSize = vis.getSize();
        this.rootShapeGroup = new ClusterShapeGroup(this.visSize.getWidth(), this.visSize.getWidth());
        this.scaleSpec = new ScaleSpecHelper(dimensionSpecArray[1].scale);
    }

    @Override
    protected void setVisSize(Dim dim) {
        if (this.visSize.getWidth() != dim.getWidth() || this.visSize.getHeight() != dim.getHeight()) {
            this.visSize = dim;
            this.rootShapeGroup = new ClusterShapeGroup(this.visSize.getWidth(), this.visSize.getWidth());
            this.isInitialized = false;
        }
    }

    @Override
    protected double calculateGapSize(double d, int n) {
        double d2 = this.specHelpers.get(1).getGap().getPreferred(d, this.visSize.getWidth());
        return d2 * (double)n;
    }

    @Override
    protected Shape transformShape(Shape shape, Dim dim, Scale[] scaleArray) {
        List<ShapeNode> list;
        if (this.shapeToNodes != null && (list = this.shapeToNodes.get(shape)) != null && !list.isEmpty()) {
            for (ShapeNode shapeNode : list) {
                this.layout.layout(shapeNode);
            }
        }
        return shape;
    }

    private void setupShapeGroup(Scale[] scaleArray, int n, ClusterShapeGroup clusterShapeGroup) {
        boolean bl;
        boolean bl2 = bl = n == this.getScales().length - 1;
        if (bl && clusterShapeGroup.isNested()) {
            return;
        }
        Scale scale = scaleArray[n];
        List<Tick> list = scale.getAllTicks();
        if (scale.reverse) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Tick tick = list.get(i);
                this.createGroup((int)tick.value, n, clusterShapeGroup, scale.reverse);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Tick tick = list.get(i);
                this.createGroup((int)tick.value, n, clusterShapeGroup, scale.reverse);
            }
        }
    }

    private void createGroup(int n, int n2, ClusterShapeGroup clusterShapeGroup, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n2 == this.getScales().length - 1;
        if (bl2) {
            ClusterShapeNode clusterShapeNode = new ClusterShapeNode(this.rootRange.getRange(), this.visSize.getWidth());
            clusterShapeNode.setIndex(n);
            clusterShapeGroup.add(clusterShapeNode, n);
        } else {
            ClusterShapeGroup clusterShapeGroup2;
            CategoryStructureSpecHelper categoryStructureSpecHelper = this.specHelpers.get(n2 + 1);
            if (categoryStructureSpecHelper.isNested()) {
                clusterShapeGroup2 = new NestedClusterShapeGroup(this.rootRange.getRange(), this.visSize.getWidth());
                clusterShapeGroup2.setIsReversed(bl);
            } else {
                clusterShapeGroup2 = new ClusterShapeGroup(this.rootRange.getRange(), this.visSize.getWidth());
            }
            clusterShapeGroup2.setIndex(n);
            clusterShapeGroup2.setGapSpecHelper(categoryStructureSpecHelper.getGap());
            clusterShapeGroup.add(clusterShapeGroup2, n);
            this.setupShapeGroup(this.getScales(), n2 + 1, clusterShapeGroup2);
        }
    }

    @Override
    public double[] inverseTransform(double[] dArray, Dim dim, Scale[] scaleArray) {
        return dArray;
    }

    @Override
    public boolean isCluster() {
        return true;
    }

    @Override
    protected void preProcess(ShapeList shapeList, Dim dim) {
        if (this.shapeToNodes == null) {
            this.shapeToNodes = new HashMap(Math.max(shapeList.getElementShapes().size() * 4 / 3, 16));
        }
        ShapeIterator<Shape> shapeIterator = shapeList.elementIterator();
        while (shapeIterator.hasNext()) {
            Object object = shapeIterator.next();
            if (((Shape)object).getPosition() == null && ((Shape)object).getPositions() == null) {
                shapeIterator.remove();
                continue;
            }
            List<ShapeNode> list = this.rootShapeGroup.addShapeToMatchingNode((Shape)object);
            if (list.isEmpty()) {
                shapeIterator.remove();
                continue;
            }
            this.shapeToNodes.put((Shape)object, list);
        }
        this.rootShapeGroup.fixOrdering();
        this.rootShapeGroup.preProcess();
        this.validateRootRange(dim.getWidth());
        this.rootShapeGroup.calculateSizeAndGaps(this.rootRange.getRange(), this.rootRange.getRange());
    }

    @Override
    public void initialize() {
        this.layout.layoutAll(this.rootShapeGroup, this.rootRange);
    }

    @Override
    public void setup(Scale[] scaleArray, Dim dim) {
        this.setScales(scaleArray);
        this.rootRange = scaleArray == null || this.getScales().length < 2 || scaleArray[1] == null || scaleArray[1].getOutRange() == null ? new Range(0.0, dim.getWidth()) : scaleArray[1].getOutRange().remap(new Range(0.0, dim.getWidth()));
        CategoryStructureSpecHelper categoryStructureSpecHelper = this.specHelpers.get(1);
        boolean bl = categoryStructureSpecHelper.isNested();
        this.rootShapeGroup = bl ? new NestedClusterShapeGroup(this.rootRange.getRange(), this.visSize.getWidth()) : new ClusterShapeGroup(this.rootRange.getRange(), this.visSize.getWidth());
        this.rootShapeGroup.setGapSpecHelper(categoryStructureSpecHelper.getGap());
        this.setupShapeGroup(scaleArray, 1, this.rootShapeGroup);
        CategoryStructureSpecHelper categoryStructureSpecHelper2 = this.specHelpers.get(this.specHelpers.size() - 1);
        this.rootShapeGroup.setWidthSpecHelper(categoryStructureSpecHelper2.getWidth());
        this.rootShapeGroup.setAlignment(this.specHelpers.get(1).getAlign());
    }

    @Override
    public boolean appliesToAxisTickOrLabel() {
        return true;
    }

    @Override
    public void cleanup() {
        this.layout = new ClusterLayout();
        this.validateRootRange(this.visSize.getWidth());
        this.rootShapeGroup = new ClusterShapeGroup(this.rootRange.getRange(), this.visSize.getWidth());
        this.shapeToNodes = null;
    }

    private void validateRootRange(double d) {
        if (this.getScales() == null || this.getScales().length < 2 || this.getScales()[1] == null || this.getScales()[1].getOutRange() == null || this.rootRange == null) {
            this.rootRange = new Range(0.0, d);
        }
    }
}

