/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.cluster;

import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.coordinate.ShapeNode;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeGroup;
import com.ibm.vis.engine.internal.grammar.coordinate.cluster.ClusterShapeNode;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NestedClusterShapeGroup
extends ClusterShapeGroup {
    private int maxChildrenSize = 1;

    public NestedClusterShapeGroup(double d, double d2) {
        super(d, d2);
        this.nodeNested = true;
    }

    @Override
    public void preProcess() {
        super.preProcess();
        if (!this.containsLeaves()) {
            this.removeNesting();
        }
        if (this.isReversed()) {
            this.reverse();
        }
    }

    private void removeNesting() {
        List<ShapeNode> list = this.getChildren();
        this.maxChildrenSize = Math.max(this.maxChildrenSize, list.size());
        ArrayList<ShapeNode> arrayList = new ArrayList<ShapeNode>();
        for (int i = 0; i < list.size(); ++i) {
            ShapeNode shapeNode = list.get(i);
            if (this.containsElement(shapeNode)) continue;
            arrayList.add(shapeNode);
        }
        for (ShapeNode shapeNode : arrayList) {
            this.remove(shapeNode);
        }
    }

    private boolean containsElement(ShapeNode shapeNode) {
        if (shapeNode.containsElement()) {
            return true;
        }
        for (int i = 0; i < shapeNode.getChildren().size(); ++i) {
            ShapeNode shapeNode2 = shapeNode.getChildren().get(i);
            if (!this.containsElement(shapeNode2)) continue;
            return true;
        }
        return false;
    }

    protected void remove(ShapeNode shapeNode) {
        this.getIndexMap().remove(shapeNode.getIndex());
        this.getChildren().remove(shapeNode);
        ShapeNode shapeNode2 = shapeNode.getNextSibling();
        ShapeNode shapeNode3 = shapeNode.getPreviousSibling();
        if (shapeNode2 != null) {
            shapeNode2.setPreviousSibling(shapeNode3);
        }
        if (shapeNode3 != null) {
            shapeNode3.setNextSibling(shapeNode2);
        }
    }

    @Override
    public int getMaxNumberOfChildren() {
        return this.maxChildrenSize;
    }

    @Override
    public Collection<ShapeNode> findShapeNodes(Shape shape, int n) {
        Collection<ShapeNode> collection = new ArrayList<ShapeNode>();
        if (this.includeShape(shape) && (collection = super.findShapeNodes(shape, n)).size() == 0 && shape.isElement()) {
            collection = this.createNodesForShape(shape);
        }
        return collection;
    }

    private List<ShapeNode> createNodesForShape(Shape shape) {
        ArrayList<ShapeNode> arrayList = new ArrayList<ShapeNode>();
        Position[] positionArray = shape.getPositions();
        if (positionArray == null) {
            positionArray = new Position[]{shape.getPosition()};
        }
        for (Position position : positionArray) {
            ShapeNode shapeNode = this.createNodeFromPosition(position);
            if (shapeNode == null) continue;
            arrayList.add(shapeNode);
        }
        return arrayList;
    }

    private ShapeNode createNodeFromPosition(Position position) {
        ClusterShapeNode clusterShapeNode = null;
        ShapeNode shapeNode = this.getRootNode();
        for (int i = 1; i < position.index.length; ++i) {
            int n = (int)position.index[i];
            ShapeNode shapeNode2 = shapeNode.getIndexMap().get(n);
            if (shapeNode2 == null && i == position.index.length - 1) {
                ClusterShapeNode clusterShapeNode2 = new ClusterShapeNode(this.getMaxWidth(), this.fullVizWidth);
                shapeNode.add(clusterShapeNode2, n);
                clusterShapeNode = clusterShapeNode2;
                continue;
            }
            if (shapeNode2 == null) continue;
            shapeNode = shapeNode2;
        }
        return clusterShapeNode;
    }

    @Override
    public void fixOrdering() {
        Set<Integer> set = this.getIndexMap().keySet();
        if (set.size() > 1) {
            this.children.clear();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
            Object[] objectArray = arrayList.toArray(new Integer[arrayList.size()]);
            BasicFactory.sortArray(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ShapeNode shapeNode = this.getIndexMap().get(object);
                this.add(shapeNode, (Integer)object);
            }
            super.fixOrdering();
        }
    }
}

