/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.DoubleOrderedSet;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPath;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DoubleHashMap;

@Deprecated
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class CompositeFunctionalPath
implements FunctionalPath {
    private final FunctionalPath a;
    private final FunctionalPath b;
    private final DoubleHashMap<Double> yCache = new DoubleHashMap();
    private final DoubleHashMap<Double> yLeftCache = new DoubleHashMap();
    private final DoubleHashMap<Double> yRightCache = new DoubleHashMap();
    private Boolean nonNegative = null;
    private Boolean nonPositive = null;
    private DoubleOrderedSet xSamples = null;

    public CompositeFunctionalPath(FunctionalPath functionalPath, FunctionalPath functionalPath2) {
        this.a = functionalPath;
        this.b = functionalPath2;
    }

    @Override
    public boolean isNonNegative() {
        if (this.nonNegative != null) {
            return this.nonNegative;
        }
        DoubleOrderedSet doubleOrderedSet = this.getXSamples();
        for (int i = 0; i < doubleOrderedSet.size(); ++i) {
            if (!(this.getY(doubleOrderedSet.get(i)) < 0.0)) continue;
            this.nonNegative = false;
            return false;
        }
        this.nonNegative = true;
        return true;
    }

    @Override
    public boolean isNonPositive() {
        if (this.nonPositive != null) {
            return this.nonPositive;
        }
        DoubleOrderedSet doubleOrderedSet = this.getXSamples();
        for (int i = 0; i < doubleOrderedSet.size(); ++i) {
            if (!(this.getY(doubleOrderedSet.get(i)) > 0.0)) continue;
            this.nonPositive = false;
            return false;
        }
        this.nonPositive = true;
        return true;
    }

    @Override
    public DoubleOrderedSet getXSamples() {
        if (this.xSamples == null) {
            DoubleOrderedSet doubleOrderedSet = this.a.getXSamples();
            DoubleOrderedSet doubleOrderedSet2 = this.b.getXSamples();
            this.xSamples = new DoubleOrderedSet(Math.max(1, doubleOrderedSet.size() + doubleOrderedSet2.size()));
            this.xSamples.addAll(doubleOrderedSet);
            this.xSamples.addAll(doubleOrderedSet2);
        }
        return this.xSamples;
    }

    @Override
    public final double getY(double d) {
        Double d2 = this.yCache.get(d);
        if (d2 == null) {
            double d3 = this.combineValues(this.a.getY(d), this.b.getY(d));
            this.yCache.put(d, d3);
            return d3;
        }
        return d2;
    }

    @Override
    public double getRightY(double d) {
        Double d2 = this.yRightCache.get(d);
        if (d2 == null) {
            double d3 = this.combineValues(this.a.getRightY(d), this.b.getRightY(d));
            this.yRightCache.put(d, d3);
            return d3;
        }
        return d2;
    }

    @Override
    public double getLeftY(double d) {
        Double d2 = this.yLeftCache.get(d);
        if (d2 == null) {
            double d3 = this.combineValues(this.a.getLeftY(d), this.b.getLeftY(d));
            this.yLeftCache.put(d, d3);
            return d3;
        }
        return d2;
    }

    private double combineValues(double d, double d2) {
        if (Double.isNaN(d2)) {
            return d;
        }
        if (Double.isNaN(d)) {
            return d2;
        }
        return Math.abs(d) > Math.abs(d2) ? d : d2;
    }

    @Override
    public boolean isDiscontinuity(double d) {
        double d2 = this.getY(d);
        double d3 = this.getLeftY(d);
        double d4 = this.getRightY(d);
        boolean bl = Double.isNaN(d2) ? !Double.isNaN(d4) || !Double.isNaN(d3) : (Double.isNaN(d3) || Double.isNaN(d4) ? true : d3 != d2 || d4 != d2);
        return bl;
    }

    @Override
    public boolean isLeftContinuous(double d) {
        return this.a.isLeftContinuous(d) && this.b.isLeftContinuous(d);
    }
}

