/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DoubleOrderedSet {
    private double[] values;
    private int used;

    public DoubleOrderedSet(int n) {
        assert (n >= 0);
        this.values = new double[n];
        this.used = 0;
    }

    public void addAll(DoubleOrderedSet doubleOrderedSet) {
        double[] dArray = new double[this.used + doubleOrderedSet.used];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.used || n2 < doubleOrderedSet.used) {
            if (n >= this.used) {
                dArray[n3] = doubleOrderedSet.values[n2];
                ++n2;
            } else if (n2 >= doubleOrderedSet.used) {
                dArray[n3] = this.values[n];
                ++n;
            } else if (this.values[n] < doubleOrderedSet.values[n2]) {
                dArray[n3] = this.values[n];
                ++n;
            } else if (this.values[n] > doubleOrderedSet.values[n2]) {
                dArray[n3] = doubleOrderedSet.values[n2];
                ++n2;
            } else {
                dArray[n3] = this.values[n];
                ++n;
                ++n2;
            }
            ++n3;
        }
        this.values = dArray;
        this.used = n3;
    }

    private void ensureCapacity(int n) {
        if (this.values.length < n) {
            double[] dArray = new double[Math.max(n, 2 * this.values.length)];
            System.arraycopy(this.values, 0, dArray, 0, this.values.length);
            this.values = dArray;
        }
    }

    public void add(double d) {
        int n;
        this.ensureCapacity(this.used + 1);
        if (!Double.isNaN(d) && (n = this.findIndexOf(d)) < 0) {
            int n2 = -(n + 1);
            System.arraycopy(this.values, n2, this.values, n2 + 1, this.used - n2);
            ++this.used;
            this.values[n2] = d;
        }
    }

    public int size() {
        return this.used;
    }

    public double get(int n) {
        assert (n >= 0 && n < this.used);
        return this.values[n];
    }

    public boolean contains(double d) {
        return this.findIndexOf(d) >= 0;
    }

    public double[] asArray() {
        double[] dArray = new double[this.used];
        System.arraycopy(this.values, 0, dArray, 0, this.used);
        return dArray;
    }

    public boolean remove(double d) {
        int n = this.findIndexOf(d);
        if (n < 0) {
            return false;
        }
        --this.used;
        System.arraycopy(this.values, n + 1, this.values, n, this.used - n);
        return true;
    }

    private int findIndexOf(double d) {
        if (this.used == 0 || d < this.values[0]) {
            return -1;
        }
        if (d > this.values[this.used - 1]) {
            return -this.used - 1;
        }
        int n = 0;
        int n2 = this.used - 1;
        int n3 = (int)Math.floor((this.used - 1) / 2);
        while (n2 > n) {
            double d2 = this.values[n3];
            if (d2 == d) {
                return n3;
            }
            if (d2 > d) {
                n2 = n3 - 1;
                n3 = (int)Math.floor((n2 + n) / 2);
                continue;
            }
            n = n3 + 1;
            n3 = (int)Math.floor((n2 + n) / 2);
        }
        if (this.values[n3] == d) {
            return n3;
        }
        if (this.values[n3] > d) {
            return -(n3 + 1);
        }
        return -(n3 + 2);
    }

    public String toString() {
        if (this.used == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < this.used; ++i) {
            double d = this.values[i];
            stringBuilder.append(d);
            stringBuilder.append(',');
        }
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            DoubleOrderedSet doubleOrderedSet = (DoubleOrderedSet)object;
            if (this.used != doubleOrderedSet.used) {
                return false;
            }
            for (int i = 0; i < this.used; ++i) {
                if (this.values[i] == doubleOrderedSet.values[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.used;
    }

    public Range getDomain() {
        if (this.used == 0) {
            return Range.EMPTY;
        }
        return new Range(this.values[0], this.values[this.used - 1]);
    }

    public void retain(Range range) {
        if (this.used <= 0) {
            return;
        }
        Range range2 = this.getDomain();
        if (range2.contains(range.getMin()) || range2.contains(range.getMax()) || range.contains(range2.getMin()) || range.contains(range2.getMax())) {
            int n;
            int n2 = this.findIndexOf(range.getMin());
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            n = (n = this.findIndexOf(range.getMax())) < 0 ? -n - 1 : ++n;
            System.arraycopy(this.values, n2, this.values, 0, n - n2);
            this.used = n - n2;
        } else {
            this.used = 0;
        }
    }
}

