/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.DoubleOrderedSet;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Point;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FunctionalPathUtil {
    private FunctionalPathUtil() {
    }

    public static List<LinearFunctionalPath> splitSubShapes(LinearFunctionalPath linearFunctionalPath) {
        ArrayList<LinearFunctionalPath> arrayList = new ArrayList<LinearFunctionalPath>();
        DoubleOrderedSet doubleOrderedSet = linearFunctionalPath.getXAxisCrossingPoints();
        int n = doubleOrderedSet.size();
        if (n == 0) {
            arrayList.add(linearFunctionalPath);
        } else {
            DoubleOrderedSet doubleOrderedSet2 = linearFunctionalPath.getXSamples();
            int n2 = 0;
            LinearFunctionalPath linearFunctionalPath2 = new LinearFunctionalPath(Double.NaN);
            double d = doubleOrderedSet2.get(0);
            linearFunctionalPath2.moveTo(d, linearFunctionalPath.getRightY(d));
            for (int i = 1; i < doubleOrderedSet2.size(); ++i) {
                d = doubleOrderedSet2.get(i);
                if (n2 < n && doubleOrderedSet.get(n2) <= d) {
                    linearFunctionalPath2.lineTo(doubleOrderedSet.get(n2), 0.0);
                    arrayList.add(linearFunctionalPath2);
                    linearFunctionalPath2 = new LinearFunctionalPath(Double.NaN);
                    linearFunctionalPath2.moveTo(doubleOrderedSet.get(n2), 0.0);
                    ++n2;
                }
                linearFunctionalPath2.lineTo(d, linearFunctionalPath.getY(d));
            }
            arrayList.add(linearFunctionalPath2);
        }
        return arrayList;
    }

    public static LinearFunctionalPath makeStackingLine(ShapePoly shapePoly, double d) {
        assert (shapePoly.getXArray().length == shapePoly.getYArray().length);
        LinearFunctionalPath linearFunctionalPath = new LinearFunctionalPath(Double.NaN);
        if (shapePoly.isFilled()) {
            assert (shapePoly.getXArray().length >= 4);
            if (shapePoly.getPathMaker() != null) {
                List<Point> list = shapePoly.getPathMaker().getControlPoints(shapePoly);
                linearFunctionalPath.moveTo(shapePoly.getXArray()[1], d - shapePoly.getYArray()[1]);
                for (int i = 2; i < shapePoly.getXArray().length - 1; ++i) {
                    int n = (i - 2) * 2;
                    Point point = list.get(n);
                    Point point2 = list.get(n + 1);
                    linearFunctionalPath.curveTo(shapePoly.getXArray()[i], d - shapePoly.getYArray()[i], point.getX(), d - point.getY(), point2.getX(), d - point2.getY());
                }
            } else {
                linearFunctionalPath.moveTo(shapePoly.getXArray()[1], d - shapePoly.getYArray()[1]);
                for (int i = 2; i < shapePoly.getXArray().length - 1; ++i) {
                    linearFunctionalPath.lineTo(shapePoly.getXArray()[i], d - shapePoly.getYArray()[i]);
                }
            }
        } else {
            assert (shapePoly.getXArray().length >= 2);
            if (shapePoly.getPathMaker() != null) {
                List<Point> list = shapePoly.getPathMaker().getControlPoints(shapePoly);
                linearFunctionalPath.moveTo(shapePoly.getXArray()[0], d - shapePoly.getYArray()[0]);
                for (int i = 1; i < shapePoly.getXArray().length; ++i) {
                    int n = (i - 1) * 2;
                    Point point = list.get(n);
                    Point point3 = list.get(n + 1);
                    linearFunctionalPath.curveTo(shapePoly.getXArray()[i], d - shapePoly.getYArray()[i], point.getX(), d - point.getY(), point3.getX(), d - point3.getY());
                }
            } else {
                linearFunctionalPath.moveTo(shapePoly.getXArray()[0], d - shapePoly.getYArray()[0]);
                for (int i = 1; i < shapePoly.getXArray().length; ++i) {
                    linearFunctionalPath.lineTo(shapePoly.getXArray()[i], d - shapePoly.getYArray()[i]);
                }
            }
        }
        return linearFunctionalPath;
    }

    public static ShapePoly createSubPoly(LinearFunctionalPath linearFunctionalPath, FunctionalPath functionalPath, double d, PolyPathMaker polyPathMaker) {
        assert (linearFunctionalPath != null);
        ShapePoly shapePoly = functionalPath == null ? FunctionalPathUtil.makeLineSubPoly(linearFunctionalPath, d, polyPathMaker) : FunctionalPathUtil.makeAreaSubPoly(linearFunctionalPath, functionalPath, d, polyPathMaker);
        return shapePoly;
    }

    private static ShapePoly makeLineSubPoly(LinearFunctionalPath linearFunctionalPath, double d, PolyPathMaker polyPathMaker) {
        DoubleOrderedSet doubleOrderedSet = linearFunctionalPath.getXSamples();
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
        for (int i = 0; i < doubleOrderedSet.size(); ++i) {
            double d2 = doubleOrderedSet.get(i);
            double d3 = d - linearFunctionalPath.getRightY(d2);
            double[] dArray = linearFunctionalPath.getMultipleY(d2);
            double d4 = d - linearFunctionalPath.getLeftY(d2);
            if (doublePrimitiveArrayList.size() > 0 && !Double.isNaN(d4)) {
                doublePrimitiveArrayList.add(d2);
                doublePrimitiveArrayList2.add(d4);
            }
            for (int j = 0; j < dArray.length; ++j) {
                double d5 = d - dArray[j];
                if (Double.isNaN(d5) || d4 == d5) continue;
                doublePrimitiveArrayList.add(d2);
                doublePrimitiveArrayList2.add(d5);
            }
            if (Double.isNaN(d3) || d3 == d - dArray[dArray.length - 1] || i == doubleOrderedSet.size() - 1) continue;
            doublePrimitiveArrayList.add(d2);
            doublePrimitiveArrayList2.add(d3);
        }
        return new ShapePoly(doublePrimitiveArrayList.toArray(), doublePrimitiveArrayList2.toArray(), false, polyPathMaker);
    }

    private static ShapePoly makeAreaSubPoly(LinearFunctionalPath linearFunctionalPath, FunctionalPath functionalPath, double d, PolyPathMaker polyPathMaker) {
        Object object;
        double d2;
        double d3;
        int n;
        DoubleOrderedSet doubleOrderedSet = linearFunctionalPath.getXSamples();
        Range range = doubleOrderedSet.getDomain();
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
        for (n = 0; n < doubleOrderedSet.size(); ++n) {
            d3 = doubleOrderedSet.get(n);
            d2 = d - linearFunctionalPath.getRightY(d3);
            object = linearFunctionalPath.getMultipleY(d3);
            double d4 = d - linearFunctionalPath.getLeftY(d3);
            if (doublePrimitiveArrayList.size() > 0 && !Double.isNaN(d4)) {
                doublePrimitiveArrayList.add(d3);
                doublePrimitiveArrayList2.add(d4);
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                double d5 = d - object[i];
                if (Double.isNaN(d5) || d4 == d5) continue;
                doublePrimitiveArrayList.add(d3);
                doublePrimitiveArrayList2.add(d5);
            }
            if (d2 == d - object[((Object)object).length - 1] || Double.isNaN(d2)) continue;
            doublePrimitiveArrayList.add(d3);
            doublePrimitiveArrayList2.add(d2);
        }
        n = doublePrimitiveArrayList.size();
        d3 = 0.0;
        d2 = 0.0;
        if (doubleOrderedSet.size() != 0) {
            d3 = doubleOrderedSet.get(0);
            d2 = doubleOrderedSet.get(doubleOrderedSet.size() - 1);
        }
        object = functionalPath.getXSamples();
        doubleOrderedSet = new DoubleOrderedSet(((DoubleOrderedSet)object).size() + 2);
        doubleOrderedSet.addAll((DoubleOrderedSet)object);
        doubleOrderedSet.add(d3);
        doubleOrderedSet.add(d2);
        doubleOrderedSet.retain(range);
        boolean bl = true;
        for (int i = doubleOrderedSet.size() - 1; i >= 0; --i) {
            double d6 = doubleOrderedSet.get(i);
            double d7 = d - functionalPath.getRightY(d6);
            double d8 = d - functionalPath.getY(d6);
            double d9 = d - functionalPath.getLeftY(d6);
            if (!Double.isNaN(d7) && !bl) {
                doublePrimitiveArrayList.add(d6);
                doublePrimitiveArrayList2.add(d7);
            }
            if (!Double.isNaN(d8) && (bl || d8 != d7 && i != 0)) {
                doublePrimitiveArrayList.add(d6);
                doublePrimitiveArrayList2.add(d8);
            }
            if (!Double.isNaN(d9) && d8 != d9 && i != 0) {
                doublePrimitiveArrayList.add(d6);
                doublePrimitiveArrayList2.add(d9);
            }
            bl = false;
        }
        double[] dArray = doublePrimitiveArrayList.toArray();
        double[] dArray2 = doublePrimitiveArrayList2.toArray();
        ShapePoly shapePoly = new ShapePoly(dArray, dArray2, true, polyPathMaker);
        shapePoly.setNonTopPointsCount(doublePrimitiveArrayList.size() - n);
        return shapePoly;
    }
}

