/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.geom.Point;

public final class LineSegment {
    private final Point p1;
    private final Point p2;
    private final double m;
    private final double b;

    public LineSegment(Point point, Point point2) {
        assert (point != null);
        assert (point2 != null);
        assert (!Double.isNaN(point.getX()));
        assert (!Double.isNaN(point.getY()));
        assert (!Double.isInfinite(point.getX()));
        assert (!Double.isInfinite(point.getY()));
        assert (!Double.isInfinite(point2.getX()));
        assert (!Double.isInfinite(point2.getY()));
        this.p1 = point;
        this.p2 = point2;
        this.m = (point2.getY() - point.getY()) / (point2.getX() - point.getX());
        this.b = point2.getY() - this.m * point2.getX();
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    public double getXIntercept() {
        if (this.p1.getX() == this.p2.getX()) {
            return this.p1.getX();
        }
        return -this.b / this.m;
    }

    public Point interpolate(double d) {
        double d2 = this.p1.getX() * (1.0 - d) + this.p2.getX() * d;
        double d3 = this.p1.getY() * (1.0 - d) + this.p2.getY() * d;
        return new Point(d2, d3);
    }

    public double interpolateY(double d) {
        if (d == this.p1.getX()) {
            return this.p1.getY();
        }
        if (d == this.p2.getX()) {
            return this.p2.getY();
        }
        return this.m * d + this.b;
    }

    public boolean containsX(double d) {
        return d >= Math.min(this.p1.getX(), this.p2.getX()) && d <= Math.max(this.p1.getX(), this.p2.getX());
    }

    public boolean crossesXAxis() {
        return this.p1.getY() * this.p2.getY() < 0.0;
    }

    public String toString() {
        return "Line segment from " + this.p1 + " to " + this.p2;
    }
}

