/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.DoubleOrderedSet;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LineSegment;
import com.ibm.vis.engine.internal.nativeImpl.DoubleHashMap;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.geom.Point;
import java.util.ArrayList;
import java.util.List;

public class LinearFunctionalPath
implements FunctionalPath {
    private final List<LineSegment> segments = new ArrayList<LineSegment>();
    private final DoubleOrderedSet samples = new DoubleOrderedSet(10);
    private final DoubleOrderedSet xAxisCrossings = new DoubleOrderedSet(10);
    private boolean positive = true;
    private boolean negative = true;
    private int lastFound = -1;
    private LineSegment last = null;
    private Boolean lastPositive = null;
    private Point current = new Point(Double.NEGATIVE_INFINITY, 0.0);
    private final double defaultValue;
    private final DoubleHashMap<DoublePrimitiveArrayList> multipleYCache = new DoubleHashMap();
    private final DoubleHashMap<Double> yCache = new DoubleHashMap();
    private final DoubleHashMap<Double> yLeftCache = new DoubleHashMap();
    private final DoubleHashMap<Double> yRightCache = new DoubleHashMap();

    public LinearFunctionalPath(double d) {
        this.defaultValue = d;
    }

    public void moveTo(double d, double d2) {
        assert (this.yCache.isEmpty() && this.yLeftCache.isEmpty() && this.yRightCache.isEmpty());
        assert (d >= this.current.getX());
        this.samples.add(d);
        this.current = new Point(d, d2);
    }

    public void lineTo(double d, double d2) {
        assert (this.yCache.isEmpty() && this.yLeftCache.isEmpty() && this.yRightCache.isEmpty());
        assert (d >= this.current.getX());
        assert (!Double.isNaN(d2));
        this.samples.add(d);
        Point point = new Point(d, d2);
        LineSegment lineSegment = new LineSegment(this.current, point);
        this.segments.add(lineSegment);
        if (this.current.getY() < 0.0 || point.getY() < 0.0) {
            this.positive = false;
        }
        if (this.current.getY() > 0.0 || point.getY() > 0.0) {
            this.negative = false;
        }
        this.current = point;
        if (lineSegment.crossesXAxis()) {
            this.xAxisCrossings.add(lineSegment.getXIntercept());
        }
        if (this.last != null && (this.isStepCrossing(this.last, lineSegment) || this.isDelayedCrossing(this.last, lineSegment, this.lastPositive))) {
            this.xAxisCrossings.add(lineSegment.getP1().getX());
        }
        if (lineSegment.getP2().getY() > 0.0) {
            this.lastPositive = true;
        } else if (lineSegment.getP2().getY() < 0.0) {
            this.lastPositive = false;
        }
        this.last = lineSegment;
    }

    private void makeSegments(List<ShapeLine> list) {
        for (ShapeLine shapeLine : list) {
            this.lineTo(shapeLine.getXArray()[1], shapeLine.getYArray()[1]);
        }
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        assert (this.yCache.isEmpty() && this.yLeftCache.isEmpty() && this.yRightCache.isEmpty());
        double d7 = this.current.getX();
        double d8 = this.current.getY();
        ArrayList<ShapeLine> arrayList = new ArrayList<ShapeLine>();
        PolyGeom.curveTo(d7, d8, d, d2, d3, d4, d5, d6, arrayList);
        this.makeSegments(arrayList);
    }

    public double[] getMultipleY(double d) {
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.multipleYCache.get(d);
        if (doublePrimitiveArrayList != null) {
            return doublePrimitiveArrayList.toArray();
        }
        doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        double d2 = Double.NaN;
        for (LineSegment lineSegment : this.segments) {
            Point point = lineSegment.getP1();
            double d3 = point.getX();
            double d4 = point.getY();
            point = lineSegment.getP2();
            double d5 = point.getX();
            double d6 = point.getY();
            if (d3 != d || d5 != d || !(Math.abs(d4 - d6) > 1.0E-6)) continue;
            if (d4 != d2) {
                doublePrimitiveArrayList.add(d4);
            }
            doublePrimitiveArrayList.add(d6);
            d2 = d6;
        }
        if (doublePrimitiveArrayList.size() == 0) {
            doublePrimitiveArrayList.add(this.getY(d));
        }
        this.multipleYCache.put(d, doublePrimitiveArrayList);
        return doublePrimitiveArrayList.toArray();
    }

    @Override
    public double getY(double d) {
        assert (!Double.isNaN(d));
        Double d2 = this.yCache.get(d);
        if (d2 != null) {
            return d2;
        }
        if (this.multipleYCache.get(d) != null) {
            d2 = this.findMaxAbs(this.multipleYCache.get(d));
            this.yCache.put(d, d2);
            return d2;
        }
        List<LineSegment> list = this.findSegmentsContaining(d);
        if (list != null) {
            for (LineSegment lineSegment : list) {
                if (!lineSegment.containsX(d) || d == lineSegment.getP1().getX() && d != lineSegment.getP2().getX()) continue;
                d2 = lineSegment.interpolateY(d);
                this.yCache.put(d, d2);
                return d2;
            }
        }
        this.yCache.put(d, this.defaultValue);
        return this.defaultValue;
    }

    private Double findMaxAbs(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        double d = doublePrimitiveArrayList.get(0);
        for (int i = 1; i < doublePrimitiveArrayList.size(); ++i) {
            if (!(Math.abs(doublePrimitiveArrayList.get(i)) > Math.abs(d))) continue;
            d = doublePrimitiveArrayList.get(i);
        }
        return d;
    }

    @Override
    public double getRightY(double d) {
        List<LineSegment> list;
        assert (!Double.isNaN(d));
        Double d2 = this.yRightCache.get(d);
        if (d2 != null) {
            return d2;
        }
        List<LineSegment> list2 = list = this.getMultipleY(d).length > 1 ? this.segments : this.findSegmentsContaining(d);
        if (list != null) {
            for (LineSegment lineSegment : list) {
                double d3 = lineSegment.getP2().getX();
                if (!(d < d3) || !lineSegment.containsX(d)) continue;
                d2 = lineSegment.interpolateY(d);
                this.yRightCache.put(d, d2);
                return d2;
            }
        }
        this.yRightCache.put(d, this.defaultValue);
        return this.defaultValue;
    }

    @Override
    public double getLeftY(double d) {
        List<LineSegment> list;
        assert (!Double.isNaN(d));
        Double d2 = this.yLeftCache.get(d);
        if (d2 != null) {
            return d2;
        }
        List<LineSegment> list2 = list = this.getMultipleY(d).length > 1 ? this.segments : this.findSegmentsContaining(d);
        if (list != null) {
            for (LineSegment lineSegment : list) {
                double d3 = lineSegment.getP1().getX();
                if (!(d > d3) || !lineSegment.containsX(d)) continue;
                d2 = lineSegment.interpolateY(d);
                this.yLeftCache.put(d, d2);
                return d2;
            }
        }
        this.yLeftCache.put(d, this.defaultValue);
        return this.defaultValue;
    }

    private boolean included(Double d, double[] dArray) {
        for (double d2 : dArray) {
            if (d2 != d) continue;
            return true;
        }
        return false;
    }

    private List<LineSegment> findSegmentsContaining(double d) {
        ArrayList<LineSegment> arrayList = null;
        int n = this.findIndexOfSegmentContaining(d);
        if (n >= 0) {
            LineSegment lineSegment;
            arrayList = new ArrayList<LineSegment>(2);
            arrayList.add(this.segments.get(n));
            if (n + 1 < this.segments.size() && (lineSegment = this.segments.get(n + 1)).containsX(d)) {
                arrayList.add(lineSegment);
            }
            if (n - 1 >= 0 && (lineSegment = this.segments.get(n - 1)).containsX(d)) {
                arrayList.add(lineSegment);
            }
        }
        return arrayList;
    }

    private int findIndexOfSegmentContaining(double d) {
        int n = this.segments.size();
        if (n == 0) {
            return -1;
        }
        double d2 = this.segments.get(0).getP1().getX();
        double d3 = this.segments.get(n - 1).getP2().getX();
        if (d2 > d || d > d3) {
            return -1;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = this.lastFound;
        if (n4 < 0) {
            n4 = (int)Math.floor((n2 + n3) / 2);
        }
        while (n2 <= n3) {
            LineSegment lineSegment = this.segments.get(n4);
            if (lineSegment.containsX(d)) {
                this.lastFound = n4;
                return n4;
            }
            if (d > lineSegment.getP2().getX()) {
                n2 = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            n4 = (int)Math.floor((n2 + n3) / 2);
        }
        return -1;
    }

    @Override
    public boolean isDiscontinuity(double d) {
        double d2 = this.getRightY(d);
        double d3 = this.getY(d);
        double d4 = this.getLeftY(d);
        if (Double.isNaN(d3)) {
            return !Double.isNaN(d2) || !Double.isNaN(d4);
        }
        if (Double.isNaN(d2) || Double.isNaN(d4)) {
            return true;
        }
        return d2 != d3 || d4 != d3;
    }

    @Override
    public boolean isNonNegative() {
        return this.positive;
    }

    @Override
    public boolean isNonPositive() {
        return this.negative;
    }

    @Override
    public DoubleOrderedSet getXSamples() {
        return this.samples;
    }

    public DoubleOrderedSet getXAxisCrossingPoints() {
        return this.xAxisCrossings;
    }

    private boolean isStepCrossing(LineSegment lineSegment, LineSegment lineSegment2) {
        LineSegment lineSegment3;
        return lineSegment.getP2().getY() != lineSegment2.getP1().getY() && (lineSegment3 = new LineSegment(lineSegment.getP2(), lineSegment2.getP1())).crossesXAxis();
    }

    private boolean isDelayedCrossing(LineSegment lineSegment, LineSegment lineSegment2, Boolean bl) {
        return lineSegment.getP2().getY() == 0.0 && bl != null && (bl != false && lineSegment2.getP2().getY() < 0.0 || bl == false && lineSegment2.getP2().getY() > 0.0);
    }

    public List<LineSegment> getSegments() {
        return this.segments;
    }

    @Override
    public boolean isLeftContinuous(double d) {
        double[] dArray;
        double d2 = this.getLeftY(d);
        for (double d3 : dArray = this.getMultipleY(d)) {
            if (d3 != d2) continue;
            return true;
        }
        return false;
    }
}

