/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.functions;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.DoubleOrderedSet;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPath;
import java.util.HashMap;

public class PointFunctionalPath
implements FunctionalPath {
    private int negativeCount = 0;
    private int positiveCount = 0;
    private final HashMap<Double, Double> values = new HashMap();

    public void addPoint(double d, double d2) {
        Double d3 = this.values.get(d);
        if (d3 != null) {
            if (d3 > 0.0) {
                --this.positiveCount;
            } else if (d3 < 0.0) {
                --this.negativeCount;
            }
        }
        this.values.put(d, d2);
        if (d2 < 0.0) {
            ++this.negativeCount;
        } else if (d2 > 0.0) {
            ++this.positiveCount;
        }
    }

    public PointFunctionalPath copy() {
        PointFunctionalPath pointFunctionalPath = new PointFunctionalPath();
        for (Double d : this.values.keySet()) {
            pointFunctionalPath.addPoint(d, this.getY(d));
        }
        return pointFunctionalPath;
    }

    @Override
    public DoubleOrderedSet getXSamples() {
        DoubleOrderedSet doubleOrderedSet = new DoubleOrderedSet(this.values.size());
        for (Double d : this.values.keySet()) {
            doubleOrderedSet.add(d);
        }
        return doubleOrderedSet;
    }

    @Override
    public double getY(double d) {
        Double d2 = this.values.get(d);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    @Override
    public boolean isDiscontinuity(double d) {
        return this.getY(d) != 0.0;
    }

    @Override
    public double getRightY(double d) {
        return 0.0;
    }

    @Override
    public double getLeftY(double d) {
        return 0.0;
    }

    @Override
    public boolean isNonNegative() {
        return this.negativeCount == 0;
    }

    @Override
    public boolean isNonPositive() {
        return this.positiveCount == 0;
    }

    @Override
    public boolean isLeftContinuous(double d) {
        return this.getLeftY(d) == this.getY(d);
    }
}

