/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.CompositeFunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.DoubleOrderedSet;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPathUtil;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.PointFunctionalPath;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.ShapePoly;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DataStack {
    private FunctionalPath top = new PointFunctionalPath();

    DataStack() {
    }

    public double getStackingOffset(double d, double d2) {
        double d3 = this.top.getY(d);
        if (this.top instanceof PointFunctionalPath && d2 != 0.0) {
            double d4 = d2 + d3;
            ((PointFunctionalPath)this.top).addPoint(d, d4);
        }
        return d3;
    }

    public ShapePoly stackPath(LinearFunctionalPath linearFunctionalPath, double d, boolean bl, PolyPathMaker polyPathMaker) {
        LinearFunctionalPath linearFunctionalPath2 = this.makeStackedPath(linearFunctionalPath, this.top);
        ShapePoly shapePoly = bl ? FunctionalPathUtil.createSubPoly(linearFunctionalPath2, this.top, d, polyPathMaker) : FunctionalPathUtil.createSubPoly(linearFunctionalPath2, null, d, polyPathMaker);
        this.top = new CompositeFunctionalPath(this.top, linearFunctionalPath2);
        return shapePoly;
    }

    private LinearFunctionalPath makeStackedPath(LinearFunctionalPath linearFunctionalPath, FunctionalPath functionalPath) {
        DoubleOrderedSet doubleOrderedSet = this.findValidXSamples(linearFunctionalPath, functionalPath);
        LinearFunctionalPath linearFunctionalPath2 = new LinearFunctionalPath(Double.NaN);
        for (int i = 0; i < doubleOrderedSet.size(); ++i) {
            double d = doubleOrderedSet.get(i);
            double d2 = linearFunctionalPath.getRightY(d) + functionalPath.getRightY(d);
            double[] dArray = linearFunctionalPath.getMultipleY(d);
            double d3 = Double.NaN;
            if (!(linearFunctionalPath.isLeftContinuous(d) && functionalPath.isLeftContinuous(d) || Double.isNaN(d3 = linearFunctionalPath.getLeftY(d) + functionalPath.getLeftY(d)))) {
                linearFunctionalPath2.lineTo(d, d3);
            }
            for (int j = 0; j < dArray.length; ++j) {
                double d4 = dArray[j] + functionalPath.getY(d);
                if (Double.isNaN(d4) || d3 == d4) continue;
                if (j == 0 && i == 0) {
                    linearFunctionalPath2.moveTo(d, d4);
                }
                linearFunctionalPath2.lineTo(d, d4);
            }
            if (Double.isNaN(d2) || d2 == dArray[dArray.length - 1] + functionalPath.getY(d)) continue;
            linearFunctionalPath2.moveTo(d, d2);
        }
        return linearFunctionalPath2;
    }

    private DoubleOrderedSet findValidXSamples(FunctionalPath functionalPath, FunctionalPath functionalPath2) {
        DoubleOrderedSet doubleOrderedSet = functionalPath.getXSamples();
        DoubleOrderedSet doubleOrderedSet2 = new DoubleOrderedSet(doubleOrderedSet.size());
        doubleOrderedSet2.addAll(doubleOrderedSet);
        Range range = doubleOrderedSet2.getDomain();
        DoubleOrderedSet doubleOrderedSet3 = functionalPath2.getXSamples();
        for (int i = 0; i < doubleOrderedSet3.size(); ++i) {
            double d = doubleOrderedSet3.get(i);
            if (!range.contains(d)) continue;
            doubleOrderedSet2.add(d);
        }
        return doubleOrderedSet2;
    }
}

