/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.grammar.coordinate.stack.StackState;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.Stacker;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DefaultStacker
implements Stacker {
    private final StackState stackState;

    public DefaultStacker(StackState stackState) {
        this.stackState = stackState;
    }

    @Override
    public Shape stack(Shape shape, double d, double d2) {
        Rect rect = shape.getBounds();
        double d3 = MathUtil.r3(rect.getY()).doubleValue() == MathUtil.r3(d2).doubleValue() && rect.getHeight() > 0.0 ? rect.getY() + rect.getHeight() : rect.getY();
        double d4 = this.stackState.getStackingOffset(rect.getCenterX(), d3, d2);
        shape.affine(1.0, 0.0, 1.0, -d4, false);
        return shape;
    }
}

