/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPathUtil;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.StackState;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.Stacker;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Point;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GlyphStacker
implements Stacker {
    private final StackState stackState;
    private final HashMap<ShapePoly, LinearFunctionalPath> cachedFunctionalPaths;

    public GlyphStacker(StackState stackState) {
        this.stackState = stackState;
        this.cachedFunctionalPaths = new HashMap();
    }

    @Override
    public Shape stack(Shape shape, double d, double d2) {
        if (shape.getContainingShape() != null && 1003 == shape.getContainingShape().getType()) {
            return this.stackPointsOnLines(shape);
        }
        return this.stackIndependentGlyph(shape, d2);
    }

    private Shape stackPointsOnLines(Shape shape) {
        Shape shape2 = this.stackState.getTransformedPoly((ShapePoly)shape.getContainingShape());
        if (shape2 == null) {
            return null;
        }
        if (1003 == shape2.getType()) {
            return this.stackPointsOnSimplePoly(shape, (ShapePoly)shape2);
        }
        return this.stackPointsOnSchemaOfPolys(shape, (Schema)shape2);
    }

    private Shape stackPointsOnSimplePoly(Shape shape, ShapePoly shapePoly) {
        Point point = shape.getCenter();
        double d = this.getYofXFromPoly((ShapePoly)shape.getContainingShape(), shapePoly, point);
        if (Double.isNaN(d)) {
            return shape;
        }
        shape.affine(1.0, 0.0, 1.0, d - point.getY(), false);
        return shape;
    }

    private Shape stackPointsOnSchemaOfPolys(Shape shape, Schema schema) {
        Point point = shape.getCenter();
        for (Shape shape2 : schema.getParts()) {
            double d = this.getYofXFromPoly((ShapePoly)shape.getContainingShape(), (ShapePoly)shape2, point);
            if (Double.isNaN(d)) continue;
            shape.affine(1.0, 0.0, 1.0, d - point.getY(), false);
            return shape;
        }
        return shape;
    }

    double getYofXFromPoly(ShapePoly shapePoly, ShapePoly shapePoly2, Point point) {
        LinearFunctionalPath linearFunctionalPath = this.getFunctionalPath(shapePoly2);
        if (linearFunctionalPath == null) {
            if (!shapePoly2.isFilled() && shapePoly2.getXArray().length == 1 && Math.round(shapePoly2.getXArray()[0]) == Math.round(point.getX())) {
                return shapePoly2.getYArray()[0];
            }
            if (shapePoly2.isFilled() && shapePoly2.getXArray().length == 3 && Math.round(shapePoly2.getXArray()[1]) == Math.round(point.getX())) {
                return shapePoly2.getYArray()[1];
            }
            return Double.NaN;
        }
        double d = -linearFunctionalPath.getLeftY(point.getX());
        double d2 = -linearFunctionalPath.getRightY(point.getX());
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return Double.NaN;
        }
        LinearFunctionalPath linearFunctionalPath2 = this.getFunctionalPath(shapePoly);
        if (linearFunctionalPath2 != null && linearFunctionalPath2.isDiscontinuity(point.getX())) {
            if (Math.round(point.getY()) == Math.round(-linearFunctionalPath2.getLeftY(point.getX()))) {
                return d;
            }
            if (Math.round(point.getY()) == Math.round(-linearFunctionalPath2.getRightY(point.getX()))) {
                return d2;
            }
        }
        if (d == d2) {
            return d;
        }
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return d2;
    }

    private LinearFunctionalPath getFunctionalPath(ShapePoly shapePoly) {
        if (!shapePoly.isFilled() && shapePoly.getXArray().length < 2 || shapePoly.isFilled() && shapePoly.getXArray().length < 4) {
            return null;
        }
        LinearFunctionalPath linearFunctionalPath = this.cachedFunctionalPaths.get(shapePoly);
        if (linearFunctionalPath != null) {
            return linearFunctionalPath;
        }
        linearFunctionalPath = FunctionalPathUtil.makeStackingLine(shapePoly, 0.0);
        this.cachedFunctionalPaths.put(shapePoly, linearFunctionalPath);
        return linearFunctionalPath;
    }

    private Shape stackIndependentGlyph(Shape shape, double d) {
        Point point = shape.getCenter();
        double d2 = point.getY();
        double d3 = this.stackState.getStackingOffset(point.getX(), d2, d);
        shape.affine(1.0, 0.0, 1.0, -d3, false);
        return shape;
    }
}

