/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.coordinate.stack;

import com.ibm.vis.engine.internal.grammar.coordinate.functions.FunctionalPathUtil;
import com.ibm.vis.engine.internal.grammar.coordinate.functions.LinearFunctionalPath;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.StackState;
import com.ibm.vis.engine.internal.grammar.coordinate.stack.Stacker;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class PolyStacker
implements Stacker {
    private final StackState stackState;

    public PolyStacker(StackState stackState) {
        this.stackState = stackState;
    }

    @Override
    public Shape stack(Shape shape, double d, double d2) {
        ShapePoly shapePoly = (ShapePoly)shape;
        if (shapePoly.getXArray().length != shapePoly.getYArray().length) {
            return null;
        }
        if (!shapePoly.isFilled() && shapePoly.getXArray().length < 2) {
            LinearFunctionalPath linearFunctionalPath = new LinearFunctionalPath(Double.NaN);
            linearFunctionalPath.moveTo(shapePoly.getXArray()[0], d - shapePoly.getYArray()[0]);
            linearFunctionalPath.lineTo(shapePoly.getXArray()[0], d - shapePoly.getYArray()[0]);
            this.stackState.stack(linearFunctionalPath, d, shape.isFilled(), null);
            return null;
        }
        if (shapePoly.isFilled() && shapePoly.getXArray().length < 4) {
            LinearFunctionalPath linearFunctionalPath = new LinearFunctionalPath(Double.NaN);
            linearFunctionalPath.moveTo(shapePoly.getXArray()[0], d - shapePoly.getYArray()[0]);
            linearFunctionalPath.lineTo(shapePoly.getXArray()[1], d - shapePoly.getYArray()[1]);
            linearFunctionalPath.lineTo(shapePoly.getXArray()[2], d - shapePoly.getYArray()[2]);
            this.stackState.stack(linearFunctionalPath, d, shape.isFilled(), null);
            return null;
        }
        this.processMultipleValues(shapePoly, d);
        LinearFunctionalPath linearFunctionalPath = FunctionalPathUtil.makeStackingLine(shapePoly, d);
        List<LinearFunctionalPath> list = FunctionalPathUtil.splitSubShapes(linearFunctionalPath);
        ArrayList<ShapePoly> arrayList = new ArrayList<ShapePoly>();
        for (LinearFunctionalPath object2 : list) {
            ShapePoly shapePoly2 = this.stackState.stack(object2, d, shape.isFilled(), null);
            if (shapePoly2.getXArray().length <= 0 || shapePoly2.getYArray().length <= 0) continue;
            arrayList.add(shapePoly2);
        }
        if (arrayList.size() > 0) {
            Object object;
            if (arrayList.size() > 1) {
                Rect rect = shapePoly.getBounds();
                object = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), arrayList.toArray(new Shape[arrayList.size()]), shapePoly.isFilled());
            } else {
                object = (Shape)arrayList.get(0);
            }
            ((Shape)object).setRows(shapePoly.getRows());
            ((Shape)object).setSnap(shapePoly.getSnap());
            ((Shape)object).setStartArrowByName(shapePoly.getStartArrowName());
            ((Shape)object).setEndArrowByName(shapePoly.getEndArrowName());
            Object object2 = object;
            this.stackState.setTransformedShapeForPoly(shapePoly, (Shape)object2);
            return object2;
        }
        return null;
    }

    private void processMultipleValues(ShapePoly shapePoly, double d) {
        double[] dArray = shapePoly.getXArray();
        double[] dArray2 = shapePoly.getYArray();
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] != dArray[i - 1]) continue;
            dArray2[i] = dArray2[i - 1] + dArray2[i] - d;
        }
    }
}

